/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import me.pushy.sdk.lib.paho.BufferedMessage;
import me.pushy.sdk.lib.paho.IMqttActionListener;
import me.pushy.sdk.lib.paho.IMqttAsyncClient;
import me.pushy.sdk.lib.paho.IMqttMessageListener;
import me.pushy.sdk.lib.paho.MqttCallback;
import me.pushy.sdk.lib.paho.MqttCallbackExtended;
import me.pushy.sdk.lib.paho.MqttClientPersistence;
import me.pushy.sdk.lib.paho.MqttConnectOptions;
import me.pushy.sdk.lib.paho.MqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.MqttPersistenceException;
import me.pushy.sdk.lib.paho.MqttPingSender;
import me.pushy.sdk.lib.paho.MqttToken;
import me.pushy.sdk.lib.paho.MqttTopic;
import me.pushy.sdk.lib.paho.internal.ClientState;
import me.pushy.sdk.lib.paho.internal.CommsCallback;
import me.pushy.sdk.lib.paho.internal.CommsReceiver;
import me.pushy.sdk.lib.paho.internal.CommsSender;
import me.pushy.sdk.lib.paho.internal.CommsTokenStore;
import me.pushy.sdk.lib.paho.internal.DisconnectedMessageBuffer;
import me.pushy.sdk.lib.paho.internal.ExceptionHelper;
import me.pushy.sdk.lib.paho.internal.IDisconnectedBufferCallback;
import me.pushy.sdk.lib.paho.internal.NetworkModule;
import me.pushy.sdk.lib.paho.internal.wire.MqttConnack;
import me.pushy.sdk.lib.paho.internal.wire.MqttConnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttDisconnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttPublish;
import me.pushy.sdk.lib.paho.internal.wire.MqttWireMessage;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class ClientComms {
    public static String VERSION = "${project.version}";
    public static String BUILD_LEVEL = "L${build.level}";
    private static final String CLASS_NAME = ClientComms.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private static final byte CONNECTED = 0;
    private static final byte CONNECTING = 1;
    private static final byte DISCONNECTING = 2;
    private static final byte DISCONNECTED = 3;
    private static final byte CLOSED = 4;
    private IMqttAsyncClient client;
    private int networkModuleIndex;
    private NetworkModule[] networkModules;
    private CommsReceiver receiver;
    private CommsSender sender;
    private CommsCallback callback;
    private ClientState clientState;
    private MqttConnectOptions conOptions;
    private MqttClientPersistence persistence;
    private MqttPingSender pingSender;
    private CommsTokenStore tokenStore;
    private boolean stoppingComms = false;
    private byte conState = (byte)3;
    private Object conLock = new Object();
    private boolean closePending = false;
    private boolean resting = false;
    private DisconnectedMessageBuffer disconnectedMessageBuffer;

    public ClientComms(IMqttAsyncClient client, MqttClientPersistence persistence, MqttPingSender pingSender) throws MqttException {
        this.conState = (byte)3;
        this.client = client;
        this.persistence = persistence;
        this.pingSender = pingSender;
        this.pingSender.init(this);
        this.tokenStore = new CommsTokenStore(this.getClient().getClientId());
        this.callback = new CommsCallback(this);
        this.clientState = new ClientState(persistence, this.tokenStore, this.callback, this, pingSender);
        this.callback.setClientState(this.clientState);
        log.setResourceName(this.getClient().getClientId());
    }

    CommsReceiver getReceiver() {
        return this.receiver;
    }

    void internalSend(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "internalSend";
        log.fine(CLASS_NAME, "internalSend", "200", new Object[]{message.getKey(), message, token});
        if (token.getClient() != null) {
            log.fine(CLASS_NAME, "internalSend", "213", new Object[]{message.getKey(), message, token});
            throw new MqttException(32201);
        }
        token.internalTok.setClient(this.getClient());
        try {
            this.clientState.send(message, token);
        }
        catch (MqttException e) {
            if (message instanceof MqttPublish) {
                this.clientState.undo((MqttPublish)message);
            }
            throw e;
        }
    }

    public void sendNoWait(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "sendNoWait";
        if (this.isConnected() || !this.isConnected() && message instanceof MqttConnect || this.isDisconnecting() && message instanceof MqttDisconnect) {
            if (this.disconnectedMessageBuffer != null && this.disconnectedMessageBuffer.getMessageCount() != 0) {
                log.fine(CLASS_NAME, "sendNoWait", "507", new Object[]{message.getKey()});
                this.clientState.persistBufferedMessage(message);
                this.disconnectedMessageBuffer.putMessage(message, token);
            } else {
                this.internalSend(message, token);
            }
        } else if (this.disconnectedMessageBuffer != null && this.isResting()) {
            log.fine(CLASS_NAME, "sendNoWait", "508", new Object[]{message.getKey()});
            this.clientState.persistBufferedMessage(message);
            this.disconnectedMessageBuffer.putMessage(message, token);
        } else {
            log.fine(CLASS_NAME, "sendNoWait", "208");
            throw ExceptionHelper.createMqttException(32104);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MqttException {
        String methodName = "close";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isClosed()) {
                if (!this.isDisconnected()) {
                    log.fine(CLASS_NAME, "close", "224");
                    if (this.isConnecting()) {
                        throw new MqttException(32110);
                    }
                    if (this.isConnected()) {
                        throw ExceptionHelper.createMqttException(32100);
                    }
                    if (this.isDisconnecting()) {
                        this.closePending = true;
                        return;
                    }
                }
                this.conState = (byte)4;
                this.clientState.close();
                this.clientState = null;
                this.callback = null;
                this.persistence = null;
                this.sender = null;
                this.pingSender = null;
                this.receiver = null;
                this.networkModules = null;
                this.conOptions = null;
                this.tokenStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(MqttConnectOptions options, MqttToken token) throws MqttException {
        String methodName = "connect";
        Object object = this.conLock;
        synchronized (object) {
            if (!this.isDisconnected() || this.closePending) {
                log.fine(CLASS_NAME, "connect", "207", new Object[]{new Byte(this.conState)});
                if (this.isClosed() || this.closePending) {
                    throw new MqttException(32111);
                }
                if (this.isConnecting()) {
                    throw new MqttException(32110);
                }
                if (this.isDisconnecting()) {
                    throw new MqttException(32102);
                }
                throw ExceptionHelper.createMqttException(32100);
            }
            log.fine(CLASS_NAME, "connect", "214");
            this.conState = 1;
            this.conOptions = options;
            MqttConnect connect = new MqttConnect(this.client.getClientId(), this.conOptions.getMqttVersion(), this.conOptions.isCleanSession(), this.conOptions.getKeepAliveInterval(), this.conOptions.getUserName(), this.conOptions.getPassword(), this.conOptions.getWillMessage(), this.conOptions.getWillDestination());
            this.clientState.setKeepAliveSecs(this.conOptions.getKeepAliveInterval());
            this.clientState.setCleanSession(this.conOptions.isCleanSession());
            this.clientState.setMaxInflight(this.conOptions.getMaxInflight());
            this.tokenStore.open();
            ConnectBG conbg = new ConnectBG(this, token, connect);
            conbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectComplete(MqttConnack cack, MqttException mex) throws MqttException {
        String methodName = "connectComplete";
        int rc = cack.getReturnCode();
        Object object = this.conLock;
        synchronized (object) {
            if (rc == 0) {
                log.fine(CLASS_NAME, "connectComplete", "215");
                this.conState = 0;
                return;
            }
        }
        log.fine(CLASS_NAME, "connectComplete", "204", new Object[]{new Integer(rc)});
        throw mex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownConnection(MqttToken token, MqttException reason) {
        boolean wasConnected;
        String methodName = "shutdownConnection";
        MqttToken endToken = null;
        Object object = this.conLock;
        synchronized (object) {
            if (this.stoppingComms || this.closePending || this.isClosed()) {
                return;
            }
            this.stoppingComms = true;
            log.fine(CLASS_NAME, "shutdownConnection", "216");
            wasConnected = this.isConnected() || this.isDisconnecting();
            this.conState = (byte)2;
        }
        if (token != null && !token.isComplete()) {
            token.internalTok.setException(reason);
        }
        if (this.callback != null) {
            this.callback.stop();
        }
        try {
            NetworkModule networkModule;
            if (this.networkModules != null && (networkModule = this.networkModules[this.networkModuleIndex]) != null) {
                networkModule.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.receiver != null) {
            this.receiver.stop();
        }
        this.tokenStore.quiesce(new MqttException(32102));
        endToken = this.handleOldTokens(token, reason);
        try {
            this.clientState.disconnected(reason);
            if (this.clientState.getCleanSession()) {
                this.callback.removeMessageListeners();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.sender != null) {
            this.sender.stop();
        }
        if (this.pingSender != null) {
            this.pingSender.stop();
        }
        try {
            if (this.disconnectedMessageBuffer == null && this.persistence != null) {
                this.persistence.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.conLock;
        synchronized (object) {
            log.fine(CLASS_NAME, "shutdownConnection", "217");
            this.conState = (byte)3;
            this.stoppingComms = false;
        }
        if (endToken != null & this.callback != null) {
            this.callback.asyncOperationComplete(endToken);
        }
        if (wasConnected && this.callback != null) {
            this.callback.connectionLost(reason);
        }
        object = this.conLock;
        synchronized (object) {
            if (this.closePending) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private MqttToken handleOldTokens(MqttToken token, MqttException reason) {
        String methodName = "handleOldTokens";
        log.fine(CLASS_NAME, "handleOldTokens", "222");
        MqttToken tokToNotifyLater = null;
        try {
            if (token != null && this.tokenStore.getToken(token.internalTok.getKey()) == null) {
                this.tokenStore.saveToken(token, token.internalTok.getKey());
            }
            Vector toksToNot = this.clientState.resolveOldTokens(reason);
            Enumeration toksToNotE = toksToNot.elements();
            while (toksToNotE.hasMoreElements()) {
                MqttToken tok = (MqttToken)toksToNotE.nextElement();
                if (tok.internalTok.getKey().equals("Disc") || tok.internalTok.getKey().equals("Con")) {
                    tokToNotifyLater = tok;
                    continue;
                }
                this.callback.asyncOperationComplete(tok);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tokToNotifyLater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) throws MqttException {
        String methodName = "disconnect";
        Object object = this.conLock;
        synchronized (object) {
            if (this.isClosed()) {
                log.fine(CLASS_NAME, "disconnect", "223");
                throw ExceptionHelper.createMqttException(32111);
            }
            if (this.isDisconnected()) {
                log.fine(CLASS_NAME, "disconnect", "211");
                throw ExceptionHelper.createMqttException(32101);
            }
            if (this.isDisconnecting()) {
                log.fine(CLASS_NAME, "disconnect", "219");
                throw ExceptionHelper.createMqttException(32102);
            }
            if (Thread.currentThread() == this.callback.getThread()) {
                log.fine(CLASS_NAME, "disconnect", "210");
                throw ExceptionHelper.createMqttException(32107);
            }
            log.fine(CLASS_NAME, "disconnect", "218");
            this.conState = (byte)2;
            DisconnectBG discbg = new DisconnectBG(disconnect, quiesceTimeout, token);
            discbg.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.clientState.quiesce(quiesceTimeout);
        MqttToken token = new MqttToken(this.client.getClientId());
        try {
            this.internalSend(new MqttDisconnect(), token);
            token.waitForCompletion(disconnectTimeout);
        }
        catch (Exception exception) {
        }
        finally {
            token.internalTok.markComplete(null, null);
            this.shutdownConnection(token, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnected() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisconnecting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        Object object = this.conLock;
        synchronized (object) {
            return this.conState == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResting() {
        Object object = this.conLock;
        synchronized (object) {
            return this.resting;
        }
    }

    public void setCallback(MqttCallback mqttCallback) {
        this.callback.setCallback(mqttCallback);
    }

    public void setReconnectCallback(MqttCallbackExtended callback) {
        this.callback.setReconnectCallback(callback);
    }

    public void setManualAcks(boolean manualAcks) {
        this.callback.setManualAcks(manualAcks);
    }

    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.callback.messageArrivedComplete(messageId, qos);
    }

    public void setMessageListener(String topicFilter, IMqttMessageListener messageListener) {
        this.callback.setMessageListener(topicFilter, messageListener);
    }

    public void removeMessageListener(String topicFilter) {
        this.callback.removeMessageListener(topicFilter);
    }

    protected MqttTopic getTopic(String topic) {
        return new MqttTopic(topic, this);
    }

    public void setNetworkModuleIndex(int index) {
        this.networkModuleIndex = index;
    }

    public int getNetworkModuleIndex() {
        return this.networkModuleIndex;
    }

    public NetworkModule[] getNetworkModules() {
        return this.networkModules;
    }

    public void setNetworkModules(NetworkModule[] networkModules) {
        this.networkModules = networkModules;
    }

    public MqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.tokenStore.getOutstandingDelTokens();
    }

    protected void deliveryComplete(MqttPublish msg) throws MqttPersistenceException {
        this.clientState.deliveryComplete(msg);
    }

    protected void deliveryComplete(int messageId) throws MqttPersistenceException {
        this.clientState.deliveryComplete(messageId);
    }

    public IMqttAsyncClient getClient() {
        return this.client;
    }

    public long getKeepAlive() {
        return this.clientState.getKeepAlive();
    }

    public ClientState getClientState() {
        return this.clientState;
    }

    public MqttConnectOptions getConOptions() {
        return this.conOptions;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("conState", new Integer(this.conState));
        props.put("serverURI", this.getClient().getServerURI());
        props.put("callback", this.callback);
        props.put("stoppingComms", new Boolean(this.stoppingComms));
        return props;
    }

    public MqttToken checkForActivity() {
        return this.checkForActivity(null);
    }

    public MqttToken checkForActivity(IMqttActionListener pingCallback) {
        MqttToken token = null;
        try {
            token = this.clientState.checkForActivity(pingCallback);
        }
        catch (MqttException e) {
            this.handleRunException(e);
        }
        catch (Exception e) {
            this.handleRunException(e);
        }
        return token;
    }

    private void handleRunException(Exception ex) {
        String methodName = "handleRunException";
        log.fine(CLASS_NAME, "handleRunException", "804", null, ex);
        MqttException mex = !(ex instanceof MqttException) ? new MqttException(32109, (Throwable)ex) : (MqttException)ex;
        this.shutdownConnection(null, mex);
    }

    public void setRestingState(boolean resting) {
        this.resting = resting;
    }

    public void setDisconnectedMessageBuffer(DisconnectedMessageBuffer disconnectedMessageBuffer) {
        this.disconnectedMessageBuffer = disconnectedMessageBuffer;
    }

    public int getBufferedMessageCount() {
        return this.disconnectedMessageBuffer.getMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        MqttPublish send = (MqttPublish)this.disconnectedMessageBuffer.getMessage(bufferIndex).getMessage();
        return send.getMessage();
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.disconnectedMessageBuffer.deleteMessage(bufferIndex);
    }

    public void notifyReconnect() {
        String methodName = "notifyReconnect";
        if (this.disconnectedMessageBuffer != null) {
            log.fine(CLASS_NAME, "notifyReconnect", "509");
            this.disconnectedMessageBuffer.setPublishCallback(new IDisconnectedBufferCallback(){

                @Override
                public void publishBufferedMessage(BufferedMessage bufferedMessage) throws MqttException {
                    if (ClientComms.this.isConnected()) {
                        while (ClientComms.this.clientState.getActualInFlight() >= ClientComms.this.clientState.getMaxInFlight() - 1) {
                            Thread.yield();
                        }
                    } else {
                        log.fine(CLASS_NAME, "notifyReconnect", "208");
                        throw ExceptionHelper.createMqttException(32104);
                    }
                    log.fine(CLASS_NAME, "notifyReconnect", "510", new Object[]{bufferedMessage.getMessage().getKey()});
                    ClientComms.this.internalSend(bufferedMessage.getMessage(), bufferedMessage.getToken());
                    ClientComms.this.clientState.unPersistBufferedMessage(bufferedMessage.getMessage());
                }
            });
            new Thread(this.disconnectedMessageBuffer).start();
        }
    }

    private class DisconnectBG
    implements Runnable {
        Thread dBg = null;
        MqttDisconnect disconnect;
        long quiesceTimeout;
        MqttToken token;

        DisconnectBG(MqttDisconnect disconnect, long quiesceTimeout, MqttToken token) {
            this.disconnect = disconnect;
            this.quiesceTimeout = quiesceTimeout;
            this.token = token;
        }

        void start() {
            this.dBg = new Thread((Runnable)this, "MQTT Disc: " + ClientComms.this.getClient().getClientId());
            this.dBg.start();
        }

        @Override
        public void run() {
            String methodName = "disconnectBG:run";
            log.fine(CLASS_NAME, "disconnectBG:run", "221");
            ClientComms.this.clientState.quiesce(this.quiesceTimeout);
            try {
                ClientComms.this.internalSend(this.disconnect, this.token);
                this.token.internalTok.waitUntilSent();
            }
            catch (MqttException mqttException) {
            }
            finally {
                this.token.internalTok.markComplete(null, null);
                ClientComms.this.shutdownConnection(this.token, null);
            }
        }
    }

    private class ConnectBG
    implements Runnable {
        ClientComms clientComms = null;
        Thread cBg = null;
        MqttToken conToken;
        MqttConnect conPacket;

        ConnectBG(ClientComms cc, MqttToken cToken, MqttConnect cPacket) {
            this.clientComms = cc;
            this.conToken = cToken;
            this.conPacket = cPacket;
            this.cBg = new Thread((Runnable)this, "MQTT Con: " + ClientComms.this.getClient().getClientId());
        }

        void start() {
            this.cBg.start();
        }

        @Override
        public void run() {
            String methodName = "connectBG:run";
            MqttException mqttEx = null;
            log.fine(CLASS_NAME, "connectBG:run", "220");
            try {
                MqttDeliveryToken[] toks = ClientComms.this.tokenStore.getOutstandingDelTokens();
                for (int i = 0; i < toks.length; ++i) {
                    toks[i].internalTok.setException(null);
                }
                ClientComms.this.tokenStore.saveToken(this.conToken, this.conPacket);
                NetworkModule networkModule = ClientComms.this.networkModules[ClientComms.this.networkModuleIndex];
                networkModule.start();
                ClientComms.this.receiver = new CommsReceiver(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getInputStream());
                ClientComms.this.receiver.start("MQTT Rec: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.sender = new CommsSender(this.clientComms, ClientComms.this.clientState, ClientComms.this.tokenStore, networkModule.getOutputStream());
                ClientComms.this.sender.start("MQTT Snd: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.callback.start("MQTT Call: " + ClientComms.this.getClient().getClientId());
                ClientComms.this.internalSend(this.conPacket, this.conToken);
            }
            catch (MqttException ex) {
                log.fine(CLASS_NAME, "connectBG:run", "212", null, ex);
                mqttEx = ex;
            }
            catch (Exception ex) {
                log.fine(CLASS_NAME, "connectBG:run", "209", null, ex);
                mqttEx = ExceptionHelper.createMqttException(ex);
            }
            if (mqttEx != null) {
                ClientComms.this.shutdownConnection(this.conToken, mqttEx);
            }
        }
    }
}

