/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import java.io.EOFException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import me.pushy.sdk.lib.paho.IMqttActionListener;
import me.pushy.sdk.lib.paho.MqttClientPersistence;
import me.pushy.sdk.lib.paho.MqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.MqttPersistable;
import me.pushy.sdk.lib.paho.MqttPersistenceException;
import me.pushy.sdk.lib.paho.MqttPingSender;
import me.pushy.sdk.lib.paho.MqttToken;
import me.pushy.sdk.lib.paho.internal.ClientComms;
import me.pushy.sdk.lib.paho.internal.CommsCallback;
import me.pushy.sdk.lib.paho.internal.CommsTokenStore;
import me.pushy.sdk.lib.paho.internal.ExceptionHelper;
import me.pushy.sdk.lib.paho.internal.wire.MqttAck;
import me.pushy.sdk.lib.paho.internal.wire.MqttConnack;
import me.pushy.sdk.lib.paho.internal.wire.MqttConnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttPingReq;
import me.pushy.sdk.lib.paho.internal.wire.MqttPingResp;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubAck;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubComp;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubRec;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubRel;
import me.pushy.sdk.lib.paho.internal.wire.MqttPublish;
import me.pushy.sdk.lib.paho.internal.wire.MqttWireMessage;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class ClientState {
    private static final String CLASS_NAME = ClientState.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private static final String PERSISTENCE_SENT_PREFIX = "s-";
    private static final String PERSISTENCE_SENT_BUFFERED_PREFIX = "sb-";
    private static final String PERSISTENCE_CONFIRMED_PREFIX = "sc-";
    private static final String PERSISTENCE_RECEIVED_PREFIX = "r-";
    private static final int MIN_MSG_ID = 1;
    private static final int MAX_MSG_ID = 65535;
    private int nextMsgId = 0;
    private Hashtable inUseMsgIds;
    private volatile Vector pendingMessages;
    private volatile Vector pendingFlows;
    private CommsTokenStore tokenStore;
    private ClientComms clientComms = null;
    private CommsCallback callback = null;
    private long keepAlive;
    private boolean cleanSession;
    private MqttClientPersistence persistence;
    private int maxInflight = 0;
    private int actualInFlight = 0;
    private int inFlightPubRels = 0;
    private Object queueLock = new Object();
    private Object quiesceLock = new Object();
    private boolean quiescing = false;
    private long lastOutboundActivity = 0L;
    private long lastInboundActivity = 0L;
    private long lastPing = 0L;
    private MqttWireMessage pingCommand;
    private Object pingOutstandingLock = new Object();
    private int pingOutstanding = 0;
    private boolean connected = false;
    private Hashtable outboundQoS2 = null;
    private Hashtable outboundQoS1 = null;
    private Hashtable outboundQoS0 = null;
    private Hashtable inboundQoS2 = null;
    private MqttPingSender pingSender = null;

    protected ClientState(MqttClientPersistence persistence, CommsTokenStore tokenStore, CommsCallback callback, ClientComms clientComms, MqttPingSender pingSender) throws MqttException {
        log.setResourceName(clientComms.getClient().getClientId());
        log.finer(CLASS_NAME, "<Init>", "");
        this.inUseMsgIds = new Hashtable();
        this.pendingFlows = new Vector();
        this.outboundQoS2 = new Hashtable();
        this.outboundQoS1 = new Hashtable();
        this.outboundQoS0 = new Hashtable();
        this.inboundQoS2 = new Hashtable();
        this.pingCommand = new MqttPingReq();
        this.inFlightPubRels = 0;
        this.actualInFlight = 0;
        this.persistence = persistence;
        this.callback = callback;
        this.tokenStore = tokenStore;
        this.clientComms = clientComms;
        this.pingSender = pingSender;
        this.restoreState();
    }

    protected void setMaxInflight(int maxInflight) {
        this.maxInflight = maxInflight;
        this.pendingMessages = new Vector(this.maxInflight);
    }

    protected void setKeepAliveSecs(long keepAliveSecs) {
        this.keepAlive = keepAliveSecs * 1000L;
    }

    protected long getKeepAlive() {
        return this.keepAlive;
    }

    protected void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    protected boolean getCleanSession() {
        return this.cleanSession;
    }

    private String getSendPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_PREFIX + message.getMessageId();
    }

    private String getSendConfirmPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_CONFIRMED_PREFIX + message.getMessageId();
    }

    private String getReceivedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_RECEIVED_PREFIX + message.getMessageId();
    }

    private String getReceivedPersistenceKey(int messageId) {
        return PERSISTENCE_RECEIVED_PREFIX + messageId;
    }

    private String getSendBufferedPersistenceKey(MqttWireMessage message) {
        return PERSISTENCE_SENT_BUFFERED_PREFIX + message.getMessageId();
    }

    protected void clearState() throws MqttException {
        String methodName = "clearState";
        log.fine(CLASS_NAME, "clearState", ">");
        this.persistence.clear();
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
    }

    private MqttWireMessage restoreMessage(String key, MqttPersistable persistable) throws MqttException {
        String methodName = "restoreMessage";
        MqttWireMessage message = null;
        try {
            message = MqttWireMessage.createWireMessage(persistable);
        }
        catch (MqttException ex) {
            log.fine(CLASS_NAME, "restoreMessage", "602", new Object[]{key}, ex);
            if (ex.getCause() instanceof EOFException) {
                if (key != null) {
                    this.persistence.remove(key);
                }
            }
            throw ex;
        }
        log.fine(CLASS_NAME, "restoreMessage", "601", new Object[]{key, message});
        return message;
    }

    private void insertInOrder(Vector list, MqttWireMessage newMsg) {
        int newMsgId = newMsg.getMessageId();
        for (int i = 0; i < list.size(); ++i) {
            MqttWireMessage otherMsg = (MqttWireMessage)list.elementAt(i);
            int otherMsgId = otherMsg.getMessageId();
            if (otherMsgId <= newMsgId) continue;
            list.insertElementAt(newMsg, i);
            return;
        }
        list.addElement(newMsg);
    }

    private Vector reOrder(Vector list) {
        int i;
        Vector newList = new Vector();
        if (list.size() == 0) {
            return newList;
        }
        int previousMsgId = 0;
        int largestGap = 0;
        int largestGapMsgIdPosInList = 0;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            int currentMsgId = ((MqttWireMessage)list.elementAt(i2)).getMessageId();
            if (currentMsgId - previousMsgId > largestGap) {
                largestGap = currentMsgId - previousMsgId;
                largestGapMsgIdPosInList = i2;
            }
            previousMsgId = currentMsgId;
        }
        int highestMsgId = previousMsgId;
        int lowestMsgId = ((MqttWireMessage)list.elementAt(0)).getMessageId();
        if (65535 - highestMsgId + lowestMsgId > largestGap) {
            largestGapMsgIdPosInList = 0;
        }
        for (i = largestGapMsgIdPosInList; i < list.size(); ++i) {
            newList.addElement(list.elementAt(i));
        }
        for (i = 0; i < largestGapMsgIdPosInList; ++i) {
            newList.addElement(list.elementAt(i));
        }
        return newList;
    }

    protected void restoreState() throws MqttException {
        String key;
        String methodName = "restoreState";
        Enumeration messageKeys = this.persistence.keys();
        int highestMsgId = this.nextMsgId;
        Vector<String> orphanedPubRels = new Vector<String>();
        log.fine(CLASS_NAME, "restoreState", "600");
        while (messageKeys.hasMoreElements()) {
            MqttPubRel pubRelMessage;
            MqttDeliveryToken tok;
            MqttPublish sendMessage;
            MqttPersistable persistable;
            key = (String)messageKeys.nextElement();
            MqttWireMessage message = this.restoreMessage(key, persistable = this.persistence.get(key));
            if (message == null) continue;
            if (key.startsWith(PERSISTENCE_RECEIVED_PREFIX)) {
                log.fine(CLASS_NAME, "restoreState", "604", new Object[]{key, message});
                this.inboundQoS2.put(new Integer(message.getMessageId()), message);
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_PREFIX)) {
                sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (this.persistence.containsKey(this.getSendConfirmPersistenceKey(sendMessage))) {
                    MqttPersistable persistedConfirm = this.persistence.get(this.getSendConfirmPersistenceKey(sendMessage));
                    MqttPubRel confirmMessage = (MqttPubRel)this.restoreMessage(key, persistedConfirm);
                    if (confirmMessage != null) {
                        log.fine(CLASS_NAME, "restoreState", "605", new Object[]{key, message});
                        this.outboundQoS2.put(new Integer(confirmMessage.getMessageId()), confirmMessage);
                    } else {
                        log.fine(CLASS_NAME, "restoreState", "606", new Object[]{key, message});
                    }
                } else {
                    sendMessage.setDuplicate(true);
                    if (sendMessage.getMessage().getQos() == 2) {
                        log.fine(CLASS_NAME, "restoreState", "607", new Object[]{key, message});
                        this.outboundQoS2.put(new Integer(sendMessage.getMessageId()), sendMessage);
                    } else {
                        log.fine(CLASS_NAME, "restoreState", "608", new Object[]{key, message});
                        this.outboundQoS1.put(new Integer(sendMessage.getMessageId()), sendMessage);
                    }
                }
                tok = this.tokenStore.restoreToken(sendMessage);
                tok.internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(new Integer(sendMessage.getMessageId()), new Integer(sendMessage.getMessageId()));
                continue;
            }
            if (key.startsWith(PERSISTENCE_SENT_BUFFERED_PREFIX)) {
                sendMessage = (MqttPublish)message;
                highestMsgId = Math.max(sendMessage.getMessageId(), highestMsgId);
                if (sendMessage.getMessage().getQos() == 2) {
                    log.fine(CLASS_NAME, "restoreState", "607", new Object[]{key, message});
                    this.outboundQoS2.put(new Integer(sendMessage.getMessageId()), sendMessage);
                } else if (sendMessage.getMessage().getQos() == 1) {
                    log.fine(CLASS_NAME, "restoreState", "608", new Object[]{key, message});
                    this.outboundQoS1.put(new Integer(sendMessage.getMessageId()), sendMessage);
                } else {
                    log.fine(CLASS_NAME, "restoreState", "511", new Object[]{key, message});
                    this.outboundQoS0.put(new Integer(sendMessage.getMessageId()), sendMessage);
                    this.persistence.remove(key);
                }
                tok = this.tokenStore.restoreToken(sendMessage);
                tok.internalTok.setClient(this.clientComms.getClient());
                this.inUseMsgIds.put(new Integer(sendMessage.getMessageId()), new Integer(sendMessage.getMessageId()));
                continue;
            }
            if (!key.startsWith(PERSISTENCE_CONFIRMED_PREFIX) || this.persistence.containsKey(this.getSendPersistenceKey(pubRelMessage = (MqttPubRel)message))) continue;
            orphanedPubRels.addElement(key);
        }
        messageKeys = orphanedPubRels.elements();
        while (messageKeys.hasMoreElements()) {
            key = (String)messageKeys.nextElement();
            log.fine(CLASS_NAME, "restoreState", "609", new Object[]{key});
            this.persistence.remove(key);
        }
        this.nextMsgId = highestMsgId;
    }

    private void restoreInflightMessages() {
        MqttWireMessage msg;
        Object key;
        String methodName = "restoreInflightMessages";
        this.pendingMessages = new Vector(this.maxInflight);
        this.pendingFlows = new Vector();
        Enumeration keys = this.outboundQoS2.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttWireMessage)this.outboundQoS2.get(key);
            if (msg instanceof MqttPublish) {
                log.fine(CLASS_NAME, "restoreInflightMessages", "610", new Object[]{key});
                msg.setDuplicate(true);
                this.insertInOrder(this.pendingMessages, (MqttPublish)msg);
                continue;
            }
            if (!(msg instanceof MqttPubRel)) continue;
            log.fine(CLASS_NAME, "restoreInflightMessages", "611", new Object[]{key});
            this.insertInOrder(this.pendingFlows, (MqttPubRel)msg);
        }
        keys = this.outboundQoS1.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttPublish)this.outboundQoS1.get(key);
            msg.setDuplicate(true);
            log.fine(CLASS_NAME, "restoreInflightMessages", "612", new Object[]{key});
            this.insertInOrder(this.pendingMessages, msg);
        }
        keys = this.outboundQoS0.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            msg = (MqttPublish)this.outboundQoS0.get(key);
            log.fine(CLASS_NAME, "restoreInflightMessages", "512", new Object[]{key});
            this.insertInOrder(this.pendingMessages, msg);
        }
        this.pendingFlows = this.reOrder(this.pendingFlows);
        this.pendingMessages = this.reOrder(this.pendingMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(MqttWireMessage message, MqttToken token) throws MqttException {
        String methodName = "send";
        if (message.isMessageIdRequired() && message.getMessageId() == 0) {
            message.setMessageId(this.getNextMessageId());
        }
        if (token != null) {
            try {
                token.internalTok.setMessageID(message.getMessageId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (message instanceof MqttPublish) {
            Object object = this.queueLock;
            synchronized (object) {
                if (this.actualInFlight >= this.maxInflight) {
                    log.fine(CLASS_NAME, "send", "613", new Object[]{new Integer(this.actualInFlight)});
                    throw new MqttException(32202);
                }
                MqttMessage innerMessage = ((MqttPublish)message).getMessage();
                log.fine(CLASS_NAME, "send", "628", new Object[]{new Integer(message.getMessageId()), new Integer(innerMessage.getQos()), message});
                switch (innerMessage.getQos()) {
                    case 2: {
                        this.outboundQoS2.put(new Integer(message.getMessageId()), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                        break;
                    }
                    case 1: {
                        this.outboundQoS1.put(new Integer(message.getMessageId()), message);
                        this.persistence.put(this.getSendPersistenceKey(message), (MqttPublish)message);
                    }
                }
                this.tokenStore.saveToken(token, message);
                this.pendingMessages.addElement(message);
                this.queueLock.notifyAll();
            }
        }
        log.fine(CLASS_NAME, "send", "615", new Object[]{new Integer(message.getMessageId()), message});
        if (message instanceof MqttConnect) {
            Object object = this.queueLock;
            synchronized (object) {
                this.tokenStore.saveToken(token, message);
                this.pendingFlows.insertElementAt(message, 0);
                this.queueLock.notifyAll();
            }
        }
        if (message instanceof MqttPingReq) {
            this.pingCommand = message;
        } else if (message instanceof MqttPubRel) {
            this.outboundQoS2.put(new Integer(message.getMessageId()), message);
            this.persistence.put(this.getSendConfirmPersistenceKey(message), (MqttPubRel)message);
        } else if (message instanceof MqttPubComp) {
            this.persistence.remove(this.getReceivedPersistenceKey(message));
        }
        Object object = this.queueLock;
        synchronized (object) {
            if (!(message instanceof MqttAck)) {
                this.tokenStore.saveToken(token, message);
            }
            this.pendingFlows.addElement(message);
            this.queueLock.notifyAll();
        }
    }

    public void persistBufferedMessage(MqttWireMessage message) {
        String methodName = "persistBufferedMessage";
        String key = this.getSendBufferedPersistenceKey(message);
        try {
            message.setMessageId(this.getNextMessageId());
            try {
                this.persistence.put(key, (MqttPublish)message);
            }
            catch (MqttPersistenceException mpe) {
                log.fine(CLASS_NAME, "persistBufferedMessage", "515");
                this.persistence.open(this.clientComms.getClient().getClientId(), this.clientComms.getClient().getClientId());
                this.persistence.put(key, (MqttPublish)message);
            }
            log.fine(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{key});
        }
        catch (MqttException ex) {
            log.warning(CLASS_NAME, "persistBufferedMessage", "513", new Object[]{key});
        }
    }

    public void unPersistBufferedMessage(MqttWireMessage message) throws MqttPersistenceException {
        String methodName = "unPersistBufferedMessage";
        log.fine(CLASS_NAME, "unPersistBufferedMessage", "513", new Object[]{message.getKey()});
        this.persistence.remove(this.getSendBufferedPersistenceKey(message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undo(MqttPublish message) throws MqttPersistenceException {
        String methodName = "undo";
        Object object = this.queueLock;
        synchronized (object) {
            log.fine(CLASS_NAME, "undo", "618", new Object[]{new Integer(message.getMessageId()), new Integer(message.getMessage().getQos())});
            if (message.getMessage().getQos() == 1) {
                this.outboundQoS1.remove(new Integer(message.getMessageId()));
            } else {
                this.outboundQoS2.remove(new Integer(message.getMessageId()));
            }
            this.pendingMessages.removeElement(message);
            this.persistence.remove(this.getSendPersistenceKey(message));
            this.tokenStore.removeToken(message);
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttToken checkForActivity(IMqttActionListener pingCallback) throws MqttException {
        String methodName = "checkForActivity";
        log.fine(CLASS_NAME, "checkForActivity", "616", new Object[0]);
        Object object = this.quiesceLock;
        synchronized (object) {
            if (this.quiescing) {
                return null;
            }
        }
        MqttToken token = null;
        long nextPingTime = this.getKeepAlive();
        if (this.connected && this.keepAlive > 0L) {
            long time = System.currentTimeMillis();
            int delta = 100;
            Object object2 = this.pingOutstandingLock;
            synchronized (object2) {
                if (this.pingOutstanding > 0 && time - this.lastInboundActivity >= this.keepAlive + (long)delta) {
                    log.severe(CLASS_NAME, "checkForActivity", "619", new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity), new Long(time), new Long(this.lastPing)});
                    throw ExceptionHelper.createMqttException(32000);
                }
                if (this.pingOutstanding == 0 && time - this.lastOutboundActivity >= 2L * this.keepAlive) {
                    log.severe(CLASS_NAME, "checkForActivity", "642", new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity), new Long(time), new Long(this.lastPing)});
                    throw ExceptionHelper.createMqttException(32002);
                }
                if (this.pingOutstanding == 0 && time - this.lastInboundActivity >= this.keepAlive - (long)delta || time - this.lastOutboundActivity >= this.keepAlive - (long)delta) {
                    log.fine(CLASS_NAME, "checkForActivity", "620", new Object[]{new Long(this.keepAlive), new Long(this.lastOutboundActivity), new Long(this.lastInboundActivity)});
                    token = new MqttToken(this.clientComms.getClient().getClientId());
                    if (pingCallback != null) {
                        token.setActionCallback(pingCallback);
                    }
                    this.tokenStore.saveToken(token, this.pingCommand);
                    this.pendingFlows.insertElementAt(this.pingCommand, 0);
                    nextPingTime = this.getKeepAlive();
                    this.notifyQueueLock();
                } else {
                    log.fine(CLASS_NAME, "checkForActivity", "634", null);
                    nextPingTime = Math.max(1L, this.getKeepAlive() - (time - this.lastOutboundActivity));
                }
            }
            log.fine(CLASS_NAME, "checkForActivity", "624", new Object[]{new Long(nextPingTime)});
            this.pingSender.schedule(nextPingTime);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MqttWireMessage get() throws MqttException {
        String methodName = "get";
        MqttWireMessage result = null;
        Object object = this.queueLock;
        synchronized (object) {
            while (result == null) {
                if (this.pendingMessages.isEmpty() && this.pendingFlows.isEmpty() || this.pendingFlows.isEmpty() && this.actualInFlight >= this.maxInflight) {
                    try {
                        log.fine(CLASS_NAME, "get", "644");
                        this.queueLock.wait();
                        log.fine(CLASS_NAME, "get", "647");
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!(this.connected || !this.pendingFlows.isEmpty() && (MqttWireMessage)this.pendingFlows.elementAt(0) instanceof MqttConnect)) {
                    log.fine(CLASS_NAME, "get", "621");
                    return null;
                }
                if (!this.pendingFlows.isEmpty()) {
                    result = (MqttWireMessage)this.pendingFlows.remove(0);
                    if (result instanceof MqttPubRel) {
                        ++this.inFlightPubRels;
                        log.fine(CLASS_NAME, "get", "617", new Object[]{new Integer(this.inFlightPubRels)});
                    }
                    this.checkQuiesceLock();
                    continue;
                }
                if (this.pendingMessages.isEmpty()) continue;
                if (this.actualInFlight < this.maxInflight) {
                    result = (MqttWireMessage)this.pendingMessages.elementAt(0);
                    this.pendingMessages.removeElementAt(0);
                    ++this.actualInFlight;
                    log.fine(CLASS_NAME, "get", "623", new Object[]{new Integer(this.actualInFlight)});
                    continue;
                }
                log.fine(CLASS_NAME, "get", "622");
            }
        }
        return result;
    }

    public void setKeepAliveInterval(long interval) {
        this.keepAlive = interval;
    }

    public void notifySentBytes(int sentBytesCount) {
        String methodName = "notifySentBytes";
        if (sentBytesCount > 0) {
            this.lastOutboundActivity = System.currentTimeMillis();
        }
        log.fine(CLASS_NAME, "notifySentBytes", "643", new Object[]{new Integer(sentBytesCount)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifySent(MqttWireMessage message) {
        String methodName = "notifySent";
        this.lastOutboundActivity = System.currentTimeMillis();
        log.fine(CLASS_NAME, "notifySent", "625", new Object[]{message.getKey()});
        MqttToken token = this.tokenStore.getToken(message);
        token.internalTok.notifySent();
        if (message instanceof MqttPingReq) {
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                long time = System.currentTimeMillis();
                Object object2 = this.pingOutstandingLock;
                synchronized (object2) {
                    this.lastPing = time;
                    ++this.pingOutstanding;
                }
                log.fine(CLASS_NAME, "notifySent", "635", new Object[]{new Integer(this.pingOutstanding)});
            }
        }
        if (message instanceof MqttPublish && ((MqttPublish)message).getMessage().getQos() == 0) {
            token.internalTok.markComplete(null, null);
            this.callback.asyncOperationComplete(token);
            this.decrementInFlight();
            this.releaseMessageId(message.getMessageId());
            this.tokenStore.removeToken(message);
            this.checkQuiesceLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementInFlight() {
        String methodName = "decrementInFlight";
        Object object = this.queueLock;
        synchronized (object) {
            --this.actualInFlight;
            log.fine(CLASS_NAME, "decrementInFlight", "646", new Object[]{new Integer(this.actualInFlight)});
            if (!this.checkQuiesceLock()) {
                this.queueLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkQuiesceLock() {
        String methodName = "checkQuiesceLock";
        int tokC = this.tokenStore.count();
        if (this.quiescing && tokC == 0 && this.pendingFlows.size() == 0 && this.callback.isQuiesced()) {
            log.fine(CLASS_NAME, "checkQuiesceLock", "626", new Object[]{new Boolean(this.quiescing), new Integer(this.actualInFlight), new Integer(this.pendingFlows.size()), new Integer(this.inFlightPubRels), this.callback.isQuiesced(), new Integer(tokC)});
            Object object = this.quiesceLock;
            synchronized (object) {
                this.quiesceLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    public void notifyReceivedBytes(int receivedBytesCount) {
        String methodName = "notifyReceivedBytes";
        if (receivedBytesCount > 0) {
            this.lastInboundActivity = System.currentTimeMillis();
        }
        log.fine(CLASS_NAME, "notifyReceivedBytes", "630", new Object[]{new Integer(receivedBytesCount)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyReceivedAck(MqttAck ack) throws MqttException {
        String methodName = "notifyReceivedAck";
        this.lastInboundActivity = System.currentTimeMillis();
        log.fine(CLASS_NAME, "notifyReceivedAck", "627", new Object[]{new Integer(ack.getMessageId()), ack});
        MqttToken token = this.tokenStore.getToken(ack);
        MqttException mex = null;
        if (token == null) {
            log.fine(CLASS_NAME, "notifyReceivedAck", "662", new Object[]{new Integer(ack.getMessageId())});
        } else if (ack instanceof MqttPubRec) {
            MqttPubRel rel = new MqttPubRel((MqttPubRec)ack);
            this.send(rel, token);
        } else if (ack instanceof MqttPubAck || ack instanceof MqttPubComp) {
            this.notifyResult(ack, token, mex);
        } else if (ack instanceof MqttPingResp) {
            Object rel = this.pingOutstandingLock;
            synchronized (rel) {
                this.pingOutstanding = Math.max(0, this.pingOutstanding - 1);
                this.notifyResult(ack, token, mex);
                if (this.pingOutstanding == 0) {
                    this.tokenStore.removeToken(ack);
                }
            }
            log.fine(CLASS_NAME, "notifyReceivedAck", "636", new Object[]{new Integer(this.pingOutstanding)});
        } else if (ack instanceof MqttConnack) {
            Object object;
            int rc = ((MqttConnack)ack).getReturnCode();
            if (rc == 0) {
                object = this.queueLock;
                synchronized (object) {
                    if (this.cleanSession) {
                        this.clearState();
                        this.tokenStore.saveToken(token, ack);
                    }
                    this.inFlightPubRels = 0;
                    this.actualInFlight = 0;
                    this.restoreInflightMessages();
                    this.connected();
                }
            } else {
                mex = ExceptionHelper.createMqttException(rc);
                throw mex;
            }
            this.clientComms.connectComplete((MqttConnack)ack, mex);
            this.notifyResult(ack, token, mex);
            this.tokenStore.removeToken(ack);
            object = this.queueLock;
            synchronized (object) {
                this.queueLock.notifyAll();
            }
        } else {
            this.notifyResult(ack, token, mex);
            this.releaseMessageId(ack.getMessageId());
            this.tokenStore.removeToken(ack);
        }
        this.checkQuiesceLock();
    }

    protected void notifyReceivedMsg(MqttWireMessage message) throws MqttException {
        String methodName = "notifyReceivedMsg";
        this.lastInboundActivity = System.currentTimeMillis();
        log.fine(CLASS_NAME, "notifyReceivedMsg", "651", new Object[]{new Integer(message.getMessageId()), message});
        if (!this.quiescing) {
            if (message instanceof MqttPublish) {
                MqttPublish send = (MqttPublish)message;
                switch (send.getMessage().getQos()) {
                    case 0: 
                    case 1: {
                        if (this.callback == null) break;
                        this.callback.messageArrived(send);
                        break;
                    }
                    case 2: {
                        this.persistence.put(this.getReceivedPersistenceKey(message), (MqttPublish)message);
                        this.inboundQoS2.put(new Integer(send.getMessageId()), send);
                        this.send(new MqttPubRec(send), null);
                        break;
                    }
                }
            } else if (message instanceof MqttPubRel) {
                MqttPublish sendMsg = (MqttPublish)this.inboundQoS2.get(new Integer(message.getMessageId()));
                if (sendMsg != null) {
                    if (this.callback != null) {
                        this.callback.messageArrived(sendMsg);
                    }
                } else {
                    MqttPubComp pubComp = new MqttPubComp(message.getMessageId());
                    this.send(pubComp, null);
                }
            }
        }
    }

    protected void notifyComplete(MqttToken token) throws MqttException {
        String methodName = "notifyComplete";
        MqttWireMessage message = token.internalTok.getWireMessage();
        if (message != null && message instanceof MqttAck) {
            log.fine(CLASS_NAME, "notifyComplete", "629", new Object[]{new Integer(message.getMessageId()), token, message});
            MqttAck ack = (MqttAck)message;
            if (ack instanceof MqttPubAck) {
                this.persistence.remove(this.getSendPersistenceKey(message));
                this.outboundQoS1.remove(new Integer(ack.getMessageId()));
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
                log.fine(CLASS_NAME, "notifyComplete", "650", new Object[]{new Integer(ack.getMessageId())});
            } else if (ack instanceof MqttPubComp) {
                this.persistence.remove(this.getSendPersistenceKey(message));
                this.persistence.remove(this.getSendConfirmPersistenceKey(message));
                this.outboundQoS2.remove(new Integer(ack.getMessageId()));
                --this.inFlightPubRels;
                this.decrementInFlight();
                this.releaseMessageId(message.getMessageId());
                this.tokenStore.removeToken(message);
                log.fine(CLASS_NAME, "notifyComplete", "645", new Object[]{new Integer(ack.getMessageId()), new Integer(this.inFlightPubRels)});
            }
            this.checkQuiesceLock();
        }
    }

    protected void notifyResult(MqttWireMessage ack, MqttToken token, MqttException ex) {
        String methodName = "notifyResult";
        token.internalTok.markComplete(ack, ex);
        token.internalTok.notifyComplete();
        if (ack != null && ack instanceof MqttAck && !(ack instanceof MqttPubRec)) {
            log.fine(CLASS_NAME, "notifyResult", "648", new Object[]{token.internalTok.getKey(), ack, ex});
            this.callback.asyncOperationComplete(token);
        }
        if (ack == null) {
            log.fine(CLASS_NAME, "notifyResult", "649", new Object[]{token.internalTok.getKey(), ex});
            this.callback.asyncOperationComplete(token);
        }
    }

    public void connected() {
        String methodName = "connected";
        log.fine(CLASS_NAME, "connected", "631");
        this.connected = true;
        this.pingSender.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector resolveOldTokens(MqttException reason) {
        String methodName = "resolveOldTokens";
        log.fine(CLASS_NAME, "resolveOldTokens", "632", new Object[]{reason});
        MqttException shutReason = reason;
        if (reason == null) {
            shutReason = new MqttException(32102);
        }
        Vector outT = this.tokenStore.getOutstandingTokens();
        Enumeration outTE = outT.elements();
        while (outTE.hasMoreElements()) {
            MqttToken tok;
            MqttToken mqttToken = tok = (MqttToken)outTE.nextElement();
            synchronized (mqttToken) {
                if (!tok.isComplete() && !tok.internalTok.isCompletePending() && tok.getException() == null) {
                    tok.internalTok.setException(shutReason);
                }
            }
            if (tok instanceof MqttDeliveryToken) continue;
            this.tokenStore.removeToken(tok.internalTok.getKey());
        }
        return outT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnected(MqttException reason) {
        String methodName = "disconnected";
        log.fine(CLASS_NAME, "disconnected", "633", new Object[]{reason});
        this.connected = false;
        try {
            if (this.cleanSession) {
                this.clearState();
            }
            this.pendingMessages.clear();
            this.pendingFlows.clear();
            Object object = this.pingOutstandingLock;
            synchronized (object) {
                this.pingOutstanding = 0;
            }
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    private synchronized void releaseMessageId(int msgId) {
        this.inUseMsgIds.remove(new Integer(msgId));
    }

    private synchronized int getNextMessageId() throws MqttException {
        int startingMessageId = this.nextMsgId;
        int loopCount = 0;
        do {
            ++this.nextMsgId;
            if (this.nextMsgId > 65535) {
                this.nextMsgId = 1;
            }
            if (this.nextMsgId != startingMessageId || ++loopCount != 2) continue;
            throw ExceptionHelper.createMqttException(32001);
        } while (this.inUseMsgIds.containsKey(new Integer(this.nextMsgId)));
        Integer id = new Integer(this.nextMsgId);
        this.inUseMsgIds.put(id, id);
        return this.nextMsgId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quiesce(long timeout) {
        String methodName = "quiesce";
        if (timeout > 0L) {
            log.fine(CLASS_NAME, "quiesce", "637", new Object[]{new Long(timeout)});
            Object object = this.queueLock;
            synchronized (object) {
                this.quiescing = true;
            }
            this.callback.quiesce();
            this.notifyQueueLock();
            object = this.quiesceLock;
            synchronized (object) {
                try {
                    int tokc = this.tokenStore.count();
                    if (tokc > 0 || this.pendingFlows.size() > 0 || !this.callback.isQuiesced()) {
                        log.fine(CLASS_NAME, "quiesce", "639", new Object[]{new Integer(this.actualInFlight), new Integer(this.pendingFlows.size()), new Integer(this.inFlightPubRels), new Integer(tokc)});
                        this.quiesceLock.wait(timeout);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = this.queueLock;
            synchronized (object) {
                this.pendingMessages.clear();
                this.pendingFlows.clear();
                this.quiescing = false;
                this.actualInFlight = 0;
            }
            log.fine(CLASS_NAME, "quiesce", "640");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyQueueLock() {
        String methodName = "notifyQueueLock";
        Object object = this.queueLock;
        synchronized (object) {
            log.fine(CLASS_NAME, "notifyQueueLock", "638");
            this.queueLock.notifyAll();
        }
    }

    protected void deliveryComplete(MqttPublish message) throws MqttPersistenceException {
        String methodName = "deliveryComplete";
        log.fine(CLASS_NAME, "deliveryComplete", "641", new Object[]{new Integer(message.getMessageId())});
        this.persistence.remove(this.getReceivedPersistenceKey(message));
        this.inboundQoS2.remove(new Integer(message.getMessageId()));
    }

    protected void deliveryComplete(int messageId) throws MqttPersistenceException {
        String methodName = "deliveryComplete";
        log.fine(CLASS_NAME, "deliveryComplete", "641", new Object[]{new Integer(messageId)});
        this.persistence.remove(this.getReceivedPersistenceKey(messageId));
        this.inboundQoS2.remove(new Integer(messageId));
    }

    public int getActualInFlight() {
        return this.actualInFlight;
    }

    public int getMaxInFlight() {
        return this.maxInflight;
    }

    protected void close() {
        this.inUseMsgIds.clear();
        this.pendingMessages.clear();
        this.pendingFlows.clear();
        this.outboundQoS2.clear();
        this.outboundQoS1.clear();
        this.outboundQoS0.clear();
        this.inboundQoS2.clear();
        this.tokenStore.clear();
        this.inUseMsgIds = null;
        this.pendingMessages = null;
        this.pendingFlows = null;
        this.outboundQoS2 = null;
        this.outboundQoS1 = null;
        this.outboundQoS0 = null;
        this.inboundQoS2 = null;
        this.tokenStore = null;
        this.callback = null;
        this.clientComms = null;
        this.persistence = null;
        this.pingCommand = null;
    }

    public Properties getDebug() {
        Properties props = new Properties();
        props.put("In use msgids", this.inUseMsgIds);
        props.put("pendingMessages", this.pendingMessages);
        props.put("pendingFlows", this.pendingFlows);
        props.put("maxInflight", new Integer(this.maxInflight));
        props.put("nextMsgID", new Integer(this.nextMsgId));
        props.put("actualInFlight", new Integer(this.actualInFlight));
        props.put("inFlightPubRels", new Integer(this.inFlightPubRels));
        props.put("quiescing", (Object)this.quiescing);
        props.put("pingoutstanding", new Integer(this.pingOutstanding));
        props.put("lastOutboundActivity", new Long(this.lastOutboundActivity));
        props.put("lastInboundActivity", new Long(this.lastInboundActivity));
        props.put("outboundQoS2", this.outboundQoS2);
        props.put("outboundQoS1", this.outboundQoS1);
        props.put("outboundQoS0", this.outboundQoS0);
        props.put("inboundQoS2", this.inboundQoS2);
        props.put("tokens", this.tokenStore);
        return props;
    }
}

