/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import java.io.IOException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.internal.TCPNetworkModule;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class SSLNetworkModule
extends TCPNetworkModule {
    private static final String CLASS_NAME = SSLNetworkModule.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private String[] enabledCiphers;
    private int handshakeTimeoutSecs;
    private String host;
    private int port;

    public SSLNetworkModule(SSLSocketFactory factory, String host, int port, String resourceContext) {
        super(factory, host, port, resourceContext);
        this.host = host;
        this.port = port;
        log.setResourceName(resourceContext);
    }

    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    public void setEnabledCiphers(String[] enabledCiphers) {
        String methodName = "setEnabledCiphers";
        this.enabledCiphers = enabledCiphers;
        if (this.socket != null && enabledCiphers != null) {
            if (log.isLoggable(5)) {
                String ciphers = "";
                for (int i = 0; i < enabledCiphers.length; ++i) {
                    if (i > 0) {
                        ciphers = ciphers + ",";
                    }
                    ciphers = ciphers + enabledCiphers[i];
                }
                log.fine(CLASS_NAME, "setEnabledCiphers", "260", new Object[]{ciphers});
            }
            ((SSLSocket)this.socket).setEnabledCipherSuites(enabledCiphers);
        }
    }

    public void setSSLhandshakeTimeout(int timeout) {
        super.setConnectTimeout(timeout);
        this.handshakeTimeoutSecs = timeout;
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        this.setEnabledCiphers(this.enabledCiphers);
        int soTimeout = this.socket.getSoTimeout();
        if (soTimeout == 0) {
            this.socket.setSoTimeout(this.handshakeTimeoutSecs * 1000);
        }
        ((SSLSocket)this.socket).startHandshake();
        this.socket.setSoTimeout(soTimeout);
    }

    @Override
    public String getServerURI() {
        return "ssl://" + this.host + ":" + this.port;
    }
}

