/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import me.pushy.sdk.services.PushySocketService;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;

public class PushyServiceManager {
    public static void startSocketService(Context context) {
        if (PushyAuthentication.getDeviceCredentials(context) == null) {
            return;
        }
        if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, context)) {
            PushyLogger.d("Notifications have been disabled by the app");
            return;
        }
        PushyServiceManager.startSocketServiceWithAction(context, "Pushy.START");
    }

    public static void stopSocketService(Context context) {
        context.stopService(new Intent(context, PushySocketService.class));
    }

    private static void startSocketServiceWithAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushySocketService.class);
        actionIntent.setAction(action);
        try {
            context.startService(actionIntent);
        }
        catch (IllegalStateException exc) {
            Log.e((String)"Pushy", (String)"Unable to start Pushy socket service due to Android O background execution limits. Service will start when your app is in foreground and Pushy.listen() is called. Please consider changing your app's targetSdkLevel to 25 or lower to work around this restriction.");
        }
    }
}

