/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.SystemClock;
import android.provider.Settings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import me.pushy.sdk.lib.paho.IMqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttCallback;
import me.pushy.sdk.lib.paho.MqttClient;
import me.pushy.sdk.lib.paho.MqttConnectOptions;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.lib.paho.persist.MemoryPersistence;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyFatalException;

public class PushySocketService
extends Service {
    private WifiManager mWifiManager;
    private AlarmManager mAlarmManager;
    private ConnectivityManager mConnectivityManager;
    private WifiManager.WifiLock mWifiWakeLock;
    private boolean mIsDestroyed;
    private MqttConnection mSocket;
    private long mRetryInterval = 500L;
    public static final String ACTION_START = "Pushy.START";
    public static final String ACTION_RECONNECT = "Pushy.RECONNECT";
    public static final String ACTION_KEEP_ALIVE = "Pushy.KEEP_ALIVE";
    private static final long INITIAL_RETRY_INTERVAL = 500L;
    private static final long MAXIMUM_RETRY_INTERVAL = 60000L;
    private static short MQTT_CONNECT_TIMEOUT = (short)15;
    private static short MQTT_ACK_TIMEOUT = (short)15000;
    private static boolean MQTT_RETAINED_PUBLISH = false;
    private static short MQTT_DEFAULT_KEEP_ALIVE = (short)300;
    private static int MQTT_QUALITY_OF_SERVICE = 1;
    private BroadcastReceiver mConnectivityListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            boolean isNetworkAvailable = PushySocketService.this.isNetworkAvailable();
            if (isNetworkAvailable) {
                PushyLogger.d("Internet connected");
                if (!PushySocketService.this.mSocket.isConnected()) {
                    PushySocketService.this.reconnectAsync();
                } else if (PushySocketService.this.getConnectedNetwork() == 1 && PushySocketService.this.mSocket.getNetwork() == 0) {
                    PushySocketService.this.reconnectAsync();
                }
            } else {
                PushyLogger.d("Internet disconnected");
                PushySocketService.this.cancelReconnect();
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        PushyLogger.d("Creating service");
        this.mWifiManager = (WifiManager)this.getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)this.getSystemService("alarm");
        this.mConnectivityManager = (ConnectivityManager)this.getSystemService("connectivity");
        this.mSocket = new MqttConnection();
        this.handleCrashedService();
        this.start();
        this.registerReceiver(this.mConnectivityListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    public void onTaskRemoved(Intent rootIntent) {
        PushyLogger.d("Task removed, attempting restart in 3 seconds");
        Intent restartService = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
        restartService.setPackage(this.getPackageName());
        PendingIntent restartServiceIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartService, (int)0x40000000);
        this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + 3000L, restartServiceIntent);
    }

    private void handleCrashedService() {
        this.stopKeepAliveTimerAndWifiLock();
        this.cancelReconnect();
    }

    public void onDestroy() {
        PushyLogger.d("Service destroyed");
        this.mIsDestroyed = true;
        this.stop();
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null) {
            this.start();
        } else if (intent.getAction().equals(ACTION_START)) {
            this.start();
        } else if (intent.getAction().equals(ACTION_KEEP_ALIVE)) {
            this.sendKeepAlive();
        } else if (intent.getAction().equals(ACTION_RECONNECT)) {
            this.reconnectAsync();
        }
        return 1;
    }

    private void start() {
        if (!this.isNetworkAvailable()) {
            return;
        }
        if (this.mSocket.isConnecting() || this.mSocket.isConnected()) {
            return;
        }
        new ConnectAsync().execute(new Integer[0]);
    }

    private void stop() {
        this.cancelReconnect();
        this.stopKeepAliveTimerAndWifiLock();
        this.unregisterReceiver(this.mConnectivityListener);
        this.mSocket.disconnectExistingClient();
    }

    private void sendKeepAlive() {
        if (this.mSocket.isConnected()) {
            new SendKeepAliveAsync().execute(new Integer[0]);
        }
    }

    private int getKeepAliveInterval() {
        return PushyPreferences.getInt("pushyKeepAliveInterval", MQTT_DEFAULT_KEEP_ALIVE, (Context)this);
    }

    private void startKeepAliveTimerAndWifiLock() {
        long interval = this.getKeepAliveInterval() * 1000;
        PendingIntent pendingIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + interval, interval, pendingIntent);
        this.acquireWifiLock();
    }

    PendingIntent getAlarmPendingIntent(String action) {
        Intent keepAliveIntent = new Intent();
        keepAliveIntent.setClass((Context)this, PushySocketService.class);
        keepAliveIntent.setAction(action);
        return PendingIntent.getService((Context)this, (int)0, (Intent)keepAliveIntent, (int)0);
    }

    private void stopKeepAliveTimerAndWifiLock() {
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.cancel(keepAliveIntent);
        this.releaseWifiLock();
    }

    public void scheduleReconnect() {
        long now = System.currentTimeMillis();
        if (this.mRetryInterval >= 60000L) {
            this.mRetryInterval = 500L;
        }
        this.mRetryInterval = Math.min(this.mRetryInterval * 2L, 60000L);
        PushyLogger.d("Reconnecting in " + this.mRetryInterval + "ms.");
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.set(0, now + this.mRetryInterval, keepAliveIntent);
    }

    public void cancelReconnect() {
        PendingIntent reconnectIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.cancel(reconnectIntent);
    }

    private void reconnectAsync() {
        this.stopKeepAliveTimerAndWifiLock();
        if (this.mIsDestroyed) {
            PushyLogger.d("Not reconnecting (service destroyed)");
            return;
        }
        if (!this.isNetworkAvailable()) {
            PushyLogger.d("Not reconnecting (network not available)");
            return;
        }
        if (this.mSocket.isConnecting()) {
            PushyLogger.d("Already reconnecting");
            return;
        }
        PushyLogger.d("Reconnecting...");
        new ConnectAsync().execute(new Integer[0]);
    }

    private void releaseWifiLock() {
        if (this.mWifiWakeLock == null) {
            return;
        }
        try {
            this.mWifiWakeLock.release();
        }
        catch (Exception exc) {
            PushyLogger.d("Wi-Fi lock release failed");
        }
        this.mWifiWakeLock = null;
        PushyLogger.d("Wi-Fi lock released");
    }

    private void acquireWifiLock() {
        if (this.mWifiWakeLock != null) {
            return;
        }
        if (PushyPreferences.getBoolean("pushyWifiPolicyCompliance", false, (Context)this) && Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"wifi_sleep_policy", (int)2) != 2) {
            PushyLogger.d("Complying with device Wi-Fi sleep policy");
            return;
        }
        this.mWifiWakeLock = this.mWifiManager.createWifiLock(1, "Pushy");
        this.mWifiWakeLock.acquire();
        PushyLogger.d("Wi-Fi lock acquired");
    }

    private boolean isNetworkAvailable() {
        NetworkInfo activeNetworkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null;
    }

    private int getConnectedNetwork() {
        NetworkInfo wifi = this.mConnectivityManager.getNetworkInfo(1);
        NetworkInfo mobile = this.mConnectivityManager.getNetworkInfo(0);
        if (wifi != null && wifi.isConnected()) {
            return 1;
        }
        if (mobile != null && mobile.isConnected()) {
            return 0;
        }
        return -1;
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    private class MqttConnection
    implements MqttCallback {
        int mNetwork;
        boolean mIsConnecting;
        MqttClient mClient;

        private MqttConnection() {
        }

        public void connect() throws Exception {
            this.disconnectExistingClient();
            int keepAliveInterval = PushySocketService.this.getKeepAliveInterval();
            String brokerEndpoint = PushyEndpoints.getMQTTEndpoint((Context)PushySocketService.this);
            PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials((Context)PushySocketService.this);
            if (PushyStringUtils.stringIsNullOrEmpty(credentials.token)) {
                throw new Exception("The device is not registered.");
            }
            if (PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
                credentials.authKey = PushyAuthentication.obtainDeviceAuthKey(credentials.token, (Context)PushySocketService.this);
            }
            PushyLogger.d("Broker: " + brokerEndpoint);
            PushyLogger.d("Client ID: " + credentials.token);
            PushyLogger.d("Client Auth: " + credentials.authKey.substring(0, 22) + "... [truncated]");
            this.mClient = new MqttClient(brokerEndpoint, credentials.token, new MemoryPersistence());
            this.mClient.setCallback(this);
            this.mClient.setTimeToWait(MQTT_ACK_TIMEOUT);
            this.mNetwork = PushySocketService.this.getConnectedNetwork();
            MqttConnectOptions connectOptions = new MqttConnectOptions();
            connectOptions.setUserName(credentials.token);
            connectOptions.setPassword(credentials.authKey.toCharArray());
            connectOptions.setAutomaticReconnect(false);
            connectOptions.setCleanSession(false);
            connectOptions.setConnectionTimeout(MQTT_CONNECT_TIMEOUT);
            connectOptions.setKeepAliveInterval(keepAliveInterval);
            this.mClient.connect(connectOptions);
            this.subscribeToTopic(this.mClient.getClientId());
            PushySocketService.this.startKeepAliveTimerAndWifiLock();
            PushySocketService.this.mRetryInterval = 500L;
            PushyLogger.d("Connected successfully (sending keep alive every " + keepAliveInterval + " seconds)");
            if (PushySocketService.this.mIsDestroyed) {
                this.disconnectExistingClient();
                PushyLogger.d("Service destroyed, aborting connection");
            }
        }

        private void subscribeToTopic(String topic) throws Exception {
            this.mClient.subscribe(topic, MQTT_QUALITY_OF_SERVICE);
        }

        private void publish(String topic, String payload) throws Exception {
            if (this.mClient == null || !this.mClient.isConnected()) {
                throw new Exception("Publish failed: not connected");
            }
            this.mClient.publish(topic, payload.getBytes(), MQTT_QUALITY_OF_SERVICE, MQTT_RETAINED_PUBLISH);
        }

        public void sendKeepAlive() throws Exception {
            this.publish("keepalive", "");
        }

        public void disconnectExistingClient() {
            if (this.mClient == null || !this.mClient.isConnected()) {
                return;
            }
            try {
                this.mClient.disconnectForcibly(2000L, 2000L);
                this.mClient.close();
            }
            catch (MqttException mqttException) {
                // empty catch block
            }
        }

        public boolean isConnected() {
            return this.mClient != null && this.mClient.isConnected();
        }

        void parsePayload(byte[] payload, Intent intent) {
            try {
                String data = new String(payload);
                Map map = PushySingleton.getJackson().readValue(data, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() == null) continue;
                    if (entry.getValue().getClass() == String.class) {
                        intent.putExtra((String)entry.getKey(), (String)entry.getValue());
                    }
                    if (entry.getValue().getClass() == Boolean.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Boolean)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Integer.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Integer)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Long.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Long)entry.getValue()));
                    }
                    if (entry.getValue().getClass() == Double.class || entry.getValue().getClass() == Float.class) {
                        intent.putExtra((String)entry.getKey(), (Serializable)((Double)entry.getValue()));
                    }
                    if (entry.getValue().getClass() != ArrayList.class) continue;
                    intent.putExtra((String)entry.getKey(), (Serializable)((ArrayList)entry.getValue()).toArray());
                }
            }
            catch (Exception exc) {
                PushyLogger.e(exc.getMessage(), exc);
            }
        }

        @Override
        public void connectionLost(Throwable cause) {
            PushyLogger.d("Connection lost");
            PushySocketService.this.reconnectAsync();
        }

        @Override
        public void messageArrived(String topic, MqttMessage message) throws Exception {
            String packageName = PushySocketService.this.getPackageName();
            PushyLogger.d("Received push for package " + packageName);
            Intent pushBroadcast = new Intent();
            this.parsePayload(message.getPayload(), pushBroadcast);
            pushBroadcast.setPackage(packageName);
            pushBroadcast.setAction("pushy.me");
            PushySocketService.this.sendBroadcast(pushBroadcast);
        }

        @Override
        public void deliveryComplete(IMqttDeliveryToken token) {
        }

        public int getNetwork() {
            return this.mNetwork;
        }

        public boolean isConnecting() {
            return this.mIsConnecting;
        }

        public void setConnecting(boolean value) {
            this.mIsConnecting = value;
        }
    }

    public class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!PushySocketService.this.mSocket.isConnected()) {
                return 0;
            }
            PushyLogger.d("Sending keep alive");
            try {
                PushySocketService.this.mSocket.sendKeepAlive();
            }
            catch (Exception e) {
                PushyLogger.d("Keep alive error: " + e.toString(), e);
                PushySocketService.this.reconnectAsync();
            }
            return 0;
        }
    }

    public class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        public ConnectAsync() {
            PushySocketService.this.mSocket.setConnecting(true);
        }

        protected Integer doInBackground(Integer ... parameter) {
            block4: {
                PushyLogger.d("Connecting...");
                try {
                    PushySocketService.this.mSocket.connect();
                }
                catch (Exception e) {
                    PushyLogger.d("Connect exception: " + e.toString());
                    if (e.getClass() == PushyFatalException.class) {
                        PushyLogger.d("Fatal error encountered, stopping service");
                        PushySocketService.this.stopSelf();
                        return 0;
                    }
                    if (e.getClass() == MqttSecurityException.class && ((MqttSecurityException)e).getReasonCode() == 5) {
                        PushyLogger.d("MQTT connect returned error code 5, clearing the device credentials");
                        PushyAuthentication.clearDeviceCredentials((Context)PushySocketService.this);
                        PushySocketService.this.stopSelf();
                        return 0;
                    }
                    if (!PushySocketService.this.isNetworkAvailable()) break block4;
                    PushySocketService.this.scheduleReconnect();
                }
            }
            PushySocketService.this.mSocket.setConnecting(false);
            return 0;
        }
    }
}

