/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk;

import android.content.Context;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyRegistrationRequest;
import me.pushy.sdk.model.api.PushyRegistrationResponse;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPermissionVerification;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushyPubSub;
import me.pushy.sdk.util.PushyServiceManager;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyFatalException;
import me.pushy.sdk.util.exceptions.PushyJsonParseException;
import me.pushy.sdk.util.exceptions.PushyRegistrationException;

public class Pushy {
    public static void listen(Context context) {
        PushyServiceManager.start(context);
    }

    public static void subscribe(String[] topics, Context context) throws PushyException {
        PushyPubSub.subscribe(topics, context);
    }

    public static void subscribe(String topic, Context context) throws PushyException {
        Pushy.subscribe(new String[]{topic}, context);
    }

    public static void unsubscribe(String[] topics, Context context) throws PushyException {
        PushyPubSub.unsubscribe(topics, context);
    }

    public static void unsubscribe(String topic, Context context) throws PushyException {
        Pushy.unsubscribe(new String[]{topic}, context);
    }

    public static void togglePermissionVerification(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyPermissionVerification", value, context);
    }

    public static void toggleDirectConnectivity(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyDirectConnectivity", value, context);
    }

    public static void toggleWifiPolicyCompliance(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyWifiPolicyCompliance", value, context);
    }

    public static void toggleNotifications(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyNotificationsEnabled", value, context);
        if (value) {
            PushyServiceManager.start(context);
        } else {
            PushyServiceManager.stop(context);
        }
    }

    public static void setHeartbeatInterval(int seconds, Context context) {
        if (seconds < 60) {
            seconds = 60;
            PushyLogger.e("The minimum heartbeat interval is 60 seconds.");
        }
        PushyPreferences.saveInt("pushyKeepAliveInterval", seconds, context);
    }

    public static void setEnterpriseConfig(String apiEndpoint, String mqttEndpoint, Context context) {
        if (apiEndpoint != null && apiEndpoint.endsWith("/")) {
            apiEndpoint = apiEndpoint.substring(0, apiEndpoint.length() - 1);
        }
        if (mqttEndpoint != null && mqttEndpoint.endsWith("/")) {
            mqttEndpoint = mqttEndpoint.substring(0, mqttEndpoint.length() - 1);
        }
        if (!PushyStringUtils.equals(PushyPreferences.getString("pushyEnterpriseMQTTEndpoint", null, context), mqttEndpoint)) {
            PushyLogger.d("New enterprise MQTT endpoint, stopping socket service");
            PushyServiceManager.stop(context);
        }
        PushyPreferences.saveString("pushyEnterpriseAPIEndpoint", apiEndpoint, context);
        PushyPreferences.saveString("pushyEnterpriseMQTTEndpoint", mqttEndpoint, context);
    }

    public static boolean isRegistered(Context context) {
        return PushyAuthentication.getDeviceCredentials(context) != null;
    }

    public static void unregister(Context context) {
        PushyAuthentication.clearDeviceCredentials(context);
        PushyServiceManager.stop(context);
    }

    public static void setAppId(String appId, Context context) {
        String previousId = PushyPreferences.getString("pushyAppId", "", context);
        if (!previousId.equals(appId) && Pushy.isRegistered(context)) {
            Pushy.unregister(context);
        }
        PushyPreferences.saveString("pushyAppId", appId, context);
    }

    public static String register(Context context) throws PushyException {
        PushyRegistrationResponse response;
        String json;
        Object register;
        PushyPermissionVerification.verifyManifestPermissions(context);
        PushyDeviceCredentials persistedCredentials = PushyAuthentication.getDeviceCredentials(context);
        if (persistedCredentials != null) {
            if (PushyStringUtils.stringIsNullOrEmpty(persistedCredentials.authKey)) {
                try {
                    persistedCredentials.authKey = PushyAuthentication.obtainDeviceAuthKey(persistedCredentials.token, context);
                }
                catch (PushyFatalException pushyFatalException) {
                }
                catch (Exception exc) {
                    throw new PushyRegistrationException("Registration failed: " + exc.getMessage());
                }
            }
            if (PushyAuthentication.validateCredentials(persistedCredentials, context)) {
                Pushy.listen(context);
                return persistedCredentials.token;
            }
        }
        try {
            register = new PushyRegistrationRequest();
            String appId = PushyPreferences.getString("pushyAppId", null, context);
            if (appId != null) {
                ((PushyRegistrationRequest)register).appId = appId;
            } else {
                ((PushyRegistrationRequest)register).app = context.getPackageName();
            }
            json = PushySingleton.getJackson().writeValueAsString(register);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        register = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/register", json);
        try {
            response = PushySingleton.getJackson().readValue((String)register, PushyRegistrationResponse.class);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyRegistrationException("Registration failed: " + response.error);
        }
        if (response.token == null || response.auth == null) {
            throw new PushyRegistrationException("Registration failed, please try again later.");
        }
        PushyAuthentication.saveDeviceCredentials(new PushyDeviceCredentials(response.token, response.auth), context);
        Pushy.listen(context);
        return response.token;
    }

    public static PushyDeviceCredentials getDeviceCredentials(Context context) {
        return PushyAuthentication.getDeviceCredentials(context);
    }

    public static void setDeviceCredentials(PushyDeviceCredentials credentials, Context context) throws PushyException {
        if (PushyStringUtils.stringIsNullOrEmpty(credentials.token) || PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
            throw new PushyException("Please provide both the device token and auth key.");
        }
        if (!PushyAuthentication.validateCredentials(credentials, context)) {
            throw new PushyException("Authentication failed, please double-check the provided credentials.");
        }
        PushyAuthentication.saveDeviceCredentials(credentials, context);
        Pushy.listen(context);
    }
}

