/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho;

import java.io.UnsupportedEncodingException;
import me.pushy.sdk.lib.paho.MqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.MqttPersistenceException;
import me.pushy.sdk.lib.paho.internal.ClientComms;
import me.pushy.sdk.lib.paho.internal.wire.MqttPublish;
import me.pushy.sdk.lib.paho.util.Strings;

public class MqttTopic {
    public static final String TOPIC_LEVEL_SEPARATOR = "/";
    public static final String MULTI_LEVEL_WILDCARD = "#";
    public static final String SINGLE_LEVEL_WILDCARD = "+";
    public static final String MULTI_LEVEL_WILDCARD_PATTERN = "/#";
    public static final String TOPIC_WILDCARDS = "#+";
    private static final int MIN_TOPIC_LEN = 1;
    private static final int MAX_TOPIC_LEN = 65535;
    private static final char NUL = '\u0000';
    private ClientComms comms;
    private String name;

    public MqttTopic(String name, ClientComms comms) {
        this.comms = comms;
        this.name = name;
    }

    public MqttDeliveryToken publish(byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(message);
    }

    public MqttDeliveryToken publish(MqttMessage message) throws MqttException, MqttPersistenceException {
        MqttDeliveryToken token = new MqttDeliveryToken(this.comms.getClient().getClientId());
        token.setMessage(message);
        this.comms.sendNoWait(this.createPublish(message), token);
        token.internalTok.waitUntilSent();
        return token;
    }

    public String getName() {
        return this.name;
    }

    private MqttPublish createPublish(MqttMessage message) {
        return new MqttPublish(this.getName(), message);
    }

    public String toString() {
        return this.getName();
    }

    public static void validate(String topicString, boolean wildcardAllowed) throws IllegalStateException, IllegalArgumentException {
        int topicLen = 0;
        try {
            topicLen = topicString.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        if (topicLen < 1 || topicLen > 65535) {
            throw new IllegalArgumentException(String.format("Invalid topic length, should be in range[%d, %d]!", new Integer(1), new Integer(65535)));
        }
        if (wildcardAllowed) {
            if (Strings.equalsAny(topicString, new String[]{MULTI_LEVEL_WILDCARD, SINGLE_LEVEL_WILDCARD})) {
                return;
            }
            if (Strings.countMatches(topicString, MULTI_LEVEL_WILDCARD) > 1 || topicString.contains(MULTI_LEVEL_WILDCARD) && !topicString.endsWith(MULTI_LEVEL_WILDCARD_PATTERN)) {
                throw new IllegalArgumentException("Invalid usage of multi-level wildcard in topic string: " + topicString);
            }
            MqttTopic.validateSingleLevelWildcard(topicString);
            return;
        }
        if (Strings.containsAny((CharSequence)topicString, TOPIC_WILDCARDS)) {
            throw new IllegalArgumentException("The topic name MUST NOT contain any wildcard characters (#+)");
        }
    }

    private static void validateSingleLevelWildcard(String topicString) {
        char singleLevelWildcardChar = SINGLE_LEVEL_WILDCARD.charAt(0);
        char topicLevelSeparatorChar = TOPIC_LEVEL_SEPARATOR.charAt(0);
        char[] chars = topicString.toCharArray();
        int length = chars.length;
        char prev = '\u0000';
        char next = '\u0000';
        for (int i = 0; i < length; ++i) {
            prev = i - 1 >= 0 ? chars[i - 1] : (char)'\u0000';
            char c = next = i + 1 < length ? chars[i + 1] : (char)'\u0000';
            if (chars[i] != singleLevelWildcardChar || (prev == topicLevelSeparatorChar || prev == '\u0000') && (next == topicLevelSeparatorChar || next == '\u0000')) continue;
            throw new IllegalArgumentException(String.format("Invalid usage of single-level wildcard in topic string '%s'!", topicString));
        }
    }

    public static boolean isMatched(String topicFilter, String topicName) throws IllegalStateException, IllegalArgumentException {
        int curf;
        int curn = 0;
        int curn_end = topicName.length();
        int curf_end = topicFilter.length();
        MqttTopic.validate(topicFilter, true);
        MqttTopic.validate(topicName, false);
        if (topicFilter.equals(topicName)) {
            return true;
        }
        for (curf = 0; !(curf >= curf_end || curn >= curn_end || topicName.charAt(curn) == '/' && topicFilter.charAt(curf) != '/' || topicFilter.charAt(curf) != '+' && topicFilter.charAt(curf) != '#' && topicFilter.charAt(curf) != topicName.charAt(curn)); ++curf, ++curn) {
            if (topicFilter.charAt(curf) == '+') {
                int nextpos = curn + 1;
                while (nextpos < curn_end && topicName.charAt(nextpos) != '/') {
                    nextpos = ++curn + 1;
                }
                continue;
            }
            if (topicFilter.charAt(curf) != '#') continue;
            curn = curn_end - 1;
        }
        return curn == curn_end && curf == curf_end;
    }
}

