/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import java.io.IOException;
import java.io.InputStream;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttToken;
import me.pushy.sdk.lib.paho.internal.ClientComms;
import me.pushy.sdk.lib.paho.internal.ClientState;
import me.pushy.sdk.lib.paho.internal.CommsTokenStore;
import me.pushy.sdk.lib.paho.internal.wire.MqttAck;
import me.pushy.sdk.lib.paho.internal.wire.MqttInputStream;
import me.pushy.sdk.lib.paho.internal.wire.MqttWireMessage;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class CommsReceiver
implements Runnable {
    private static final String CLASS_NAME = CommsReceiver.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private boolean running = false;
    private Object lifecycle = new Object();
    private ClientState clientState = null;
    private ClientComms clientComms = null;
    private MqttInputStream in;
    private CommsTokenStore tokenStore = null;
    private Thread recThread = null;
    private volatile boolean receiving;

    public CommsReceiver(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, InputStream in) {
        this.in = new MqttInputStream(clientState, in);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String threadName) {
        String methodName = "start";
        log.fine(CLASS_NAME, "start", "855");
        Object object = this.lifecycle;
        synchronized (object) {
            if (!this.running) {
                this.running = true;
                this.recThread = new Thread((Runnable)this, threadName);
                this.recThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        String methodName = "stop";
        Object object = this.lifecycle;
        synchronized (object) {
            log.fine(CLASS_NAME, "stop", "850");
            if (this.running) {
                this.running = false;
                this.receiving = false;
                if (!Thread.currentThread().equals(this.recThread)) {
                    try {
                        this.recThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        this.recThread = null;
        log.fine(CLASS_NAME, "stop", "851");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String methodName = "run";
        MqttToken token = null;
        while (this.running && this.in != null) {
            try {
                log.fine(CLASS_NAME, "run", "852");
                this.receiving = this.in.available() > 0;
                MqttWireMessage message = this.in.readMqttWireMessage();
                this.receiving = false;
                if (message instanceof MqttAck) {
                    token = this.tokenStore.getToken(message);
                    if (token != null) {
                        MqttToken mqttToken = token;
                        synchronized (mqttToken) {
                            this.clientState.notifyReceivedAck((MqttAck)message);
                            continue;
                        }
                    }
                    throw new MqttException(6);
                }
                this.clientState.notifyReceivedMsg(message);
            }
            catch (MqttException ex) {
                log.fine(CLASS_NAME, "run", "856", null, ex);
                this.running = false;
                this.clientComms.shutdownConnection(token, ex);
            }
            catch (IOException ioe) {
                log.fine(CLASS_NAME, "run", "853");
                this.running = false;
                if (this.clientComms.isDisconnecting()) continue;
                this.clientComms.shutdownConnection(token, new MqttException(32109, (Throwable)ioe));
            }
            finally {
                this.receiving = false;
            }
        }
        log.fine(CLASS_NAME, "run", "854");
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isReceiving() {
        return this.receiving;
    }
}

