/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyPubSubRequest;
import me.pushy.sdk.model.api.PushyPubSubResponse;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyPubSubException;

public class PushyPubSub {
    public static void subscribe(String[] topics, Context context) throws PushyException {
        PushyPubSubResponse response;
        String json;
        PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials(context);
        if (credentials == null) {
            throw new PushyPubSubException("Subscribe failed: The device is not registered for push notifications.");
        }
        if (PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
            try {
                credentials.authKey = PushyAuthentication.obtainDeviceAuthKey(credentials.token, context);
            }
            catch (Exception exc) {
                throw new PushyPubSubException("Subscribe failed due to a missing device auth key: " + exc.getMessage());
            }
        }
        try {
            PushyPubSubRequest subscribe = new PushyPubSubRequest(topics, credentials);
            json = PushySingleton.getJackson().writeValueAsString(subscribe);
        }
        catch (Exception exc) {
            throw new PushyPubSubException("Subscribe failed due to invalid JSON:" + exc.getMessage());
        }
        String result = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/subscribe", json);
        try {
            response = PushySingleton.getJackson().readValue(result, PushyPubSubResponse.class);
        }
        catch (Exception exc) {
            throw new PushyPubSubException("Subscribe failed due to invalid response:" + exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyPubSubException("Subscribe failed: " + response.error);
        }
        if (!response.success) {
            throw new PushyPubSubException("Subscribe failed: An unexpected response was encountered.");
        }
    }

    public static void unsubscribe(String[] topics, Context context) throws PushyException {
        PushyPubSubResponse response;
        String json;
        PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials(context);
        if (credentials == null) {
            throw new PushyPubSubException("Unsubscribe failed: The device is not registered for push notifications.");
        }
        if (PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
            try {
                credentials.authKey = PushyAuthentication.obtainDeviceAuthKey(credentials.token, context);
            }
            catch (Exception exc) {
                throw new PushyPubSubException("Unsubscribe failed due to a missing device auth key: " + exc.getMessage());
            }
        }
        try {
            PushyPubSubRequest unsubscribe = new PushyPubSubRequest(topics, credentials);
            json = PushySingleton.getJackson().writeValueAsString(unsubscribe);
        }
        catch (Exception exc) {
            throw new PushyPubSubException("Unsubscribe failed due to invalid JSON:" + exc.getMessage());
        }
        String result = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/unsubscribe", json);
        try {
            response = PushySingleton.getJackson().readValue(result, PushyPubSubResponse.class);
        }
        catch (Exception exc) {
            throw new PushyPubSubException("Unsubscribe failed due to invalid response:" + exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyPubSubException("Unsubscribe failed: " + response.error);
        }
        if (!response.success) {
            throw new PushyPubSubException("Unsubscribe failed: An unexpected response was encountered.");
        }
    }
}

