/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.provider.Settings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import me.pushy.sdk.config.PushyMQTT;
import me.pushy.sdk.lib.paho.IMqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttCallback;
import me.pushy.sdk.lib.paho.MqttClient;
import me.pushy.sdk.lib.paho.MqttConnectOptions;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.persist.MemoryPersistence;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyNetworking;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;

public class PushyMqttConnection
implements MqttCallback {
    int mNetwork;
    boolean mIsConnecting;
    int mKeepAliveInterval;
    Context mContext;
    MqttClient mClient;
    WifiManager mWifiManager;
    Runnable mConnectionLostRunnable;
    WifiManager.WifiLock mWifiWakeLock;
    ConnectivityManager mConnectivityManager;

    public PushyMqttConnection(Context context, WifiManager wifiManager, ConnectivityManager connectivityManager, int keepAliveInterval, Runnable connectionLostRunnable) {
        this.mContext = context;
        this.mWifiManager = wifiManager;
        this.mKeepAliveInterval = keepAliveInterval;
        this.mConnectivityManager = connectivityManager;
        this.mConnectionLostRunnable = connectionLostRunnable;
    }

    public static int getKeepAliveInterval(Context context) {
        return PushyPreferences.getInt("pushyKeepAliveInterval", PushyMQTT.MQTT_DEFAULT_KEEP_ALIVE, context);
    }

    public void releaseWifiLock() {
        if (this.mWifiWakeLock == null) {
            return;
        }
        try {
            this.mWifiWakeLock.release();
        }
        catch (Exception exc) {
            PushyLogger.d("Wi-Fi lock release failed");
        }
        this.mWifiWakeLock = null;
        PushyLogger.d("Wi-Fi lock released");
    }

    public void acquireWifiLock() {
        if (this.mWifiWakeLock != null) {
            return;
        }
        if (PushyPreferences.getBoolean("pushyWifiPolicyCompliance", false, this.mContext) && Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"wifi_sleep_policy", (int)2) != 2) {
            PushyLogger.d("Complying with device Wi-Fi sleep policy");
            return;
        }
        this.mWifiWakeLock = this.mWifiManager.createWifiLock(1, "Pushy");
        this.mWifiWakeLock.acquire();
        PushyLogger.d("Wi-Fi lock acquired");
    }

    public void connect() throws Exception {
        this.disconnectExistingClient(false);
        String brokerEndpoint = PushyEndpoints.getMQTTEndpoint(this.mContext);
        PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials(this.mContext);
        if (PushyStringUtils.stringIsNullOrEmpty(credentials.token)) {
            throw new Exception("The device is not registered.");
        }
        if (PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
            credentials.authKey = PushyAuthentication.obtainDeviceAuthKey(credentials.token, this.mContext);
        }
        PushyLogger.d("Broker: " + brokerEndpoint);
        PushyLogger.d("Device Token: " + credentials.token);
        PushyLogger.d("Device Auth Key: " + credentials.authKey.substring(0, 22) + "... [truncated]");
        this.mClient = new MqttClient(brokerEndpoint, credentials.token, new MemoryPersistence());
        this.mClient.setCallback(this);
        this.mClient.setTimeToWait(PushyMQTT.MQTT_ACK_TIMEOUT);
        this.mNetwork = PushyNetworking.getConnectedNetwork(this.mConnectivityManager);
        MqttConnectOptions connectOptions = new MqttConnectOptions();
        connectOptions.setUserName(credentials.token);
        connectOptions.setPassword(credentials.authKey.toCharArray());
        connectOptions.setAutomaticReconnect(false);
        connectOptions.setCleanSession(false);
        connectOptions.setConnectionTimeout(PushyMQTT.MQTT_CONNECT_TIMEOUT);
        connectOptions.setKeepAliveInterval(this.mKeepAliveInterval);
        this.mClient.connect(connectOptions);
        this.subscribeToTopic(this.mClient.getClientId());
    }

    private void subscribeToTopic(String topic) throws Exception {
        this.mClient.subscribe(topic, PushyMQTT.MQTT_QUALITY_OF_SERVICE);
    }

    private void publish(String topic, String payload) throws Exception {
        if (this.mClient == null || !this.mClient.isConnected()) {
            throw new Exception("Publish failed: not connected");
        }
        this.mClient.publish(topic, payload.getBytes(), PushyMQTT.MQTT_QUALITY_OF_SERVICE, PushyMQTT.MQTT_RETAINED_PUBLISH);
    }

    public void sendKeepAlive() throws Exception {
        this.publish("keepalive", this.mClient.getClientId());
    }

    public void disconnectExistingClient(boolean async) {
        if (this.mClient == null || !this.mClient.isConnected()) {
            return;
        }
        if (async) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    PushyMqttConnection.this.disconnectExistingClientSync();
                }
            });
        } else {
            this.disconnectExistingClientSync();
        }
    }

    private void disconnectExistingClientSync() {
        try {
            this.mClient.disconnectForcibly(2000L, 2000L);
            this.mClient.close();
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.mClient != null && this.mClient.isConnected();
    }

    void parsePayload(byte[] payload, Intent intent) {
        try {
            String data = new String(payload);
            Map map = PushySingleton.getJackson().readValue(data, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getValue().getClass() == String.class) {
                    intent.putExtra((String)entry.getKey(), (String)entry.getValue());
                }
                if (entry.getValue().getClass() == Boolean.class) {
                    intent.putExtra((String)entry.getKey(), (Serializable)((Boolean)entry.getValue()));
                }
                if (entry.getValue().getClass() == Integer.class) {
                    intent.putExtra((String)entry.getKey(), (Serializable)((Integer)entry.getValue()));
                }
                if (entry.getValue().getClass() == Long.class) {
                    intent.putExtra((String)entry.getKey(), (Serializable)((Long)entry.getValue()));
                }
                if (entry.getValue().getClass() == Double.class || entry.getValue().getClass() == Float.class) {
                    intent.putExtra((String)entry.getKey(), (Serializable)((Double)entry.getValue()));
                }
                if (entry.getValue().getClass() != ArrayList.class) continue;
                intent.putExtra((String)entry.getKey(), (Serializable)((ArrayList)entry.getValue()).toArray());
            }
        }
        catch (Exception exc) {
            PushyLogger.e(exc.getMessage(), exc);
        }
    }

    @Override
    public void connectionLost(Throwable cause) {
        PushyLogger.d("Connection lost");
        if (this.mConnectionLostRunnable != null) {
            this.mConnectionLostRunnable.run();
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        String packageName = this.mContext.getPackageName();
        PushyLogger.d("Received push for package " + packageName);
        Intent pushBroadcast = new Intent();
        this.parsePayload(message.getPayload(), pushBroadcast);
        pushBroadcast.setPackage(packageName);
        pushBroadcast.setAction("pushy.me");
        this.mContext.sendBroadcast(pushBroadcast);
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public int getNetwork() {
        return this.mNetwork;
    }

    public boolean isConnecting() {
        return this.mIsConnecting;
    }

    public void setConnecting(boolean value) {
        this.mIsConnecting = value;
    }
}

