/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import java.io.IOException;
import me.pushy.sdk.lib.jackson.core.JsonProcessingException;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyAuthMigrationRequest;
import me.pushy.sdk.model.api.PushyAuthMigrationResponse;
import me.pushy.sdk.model.api.PushyAuthRequest;
import me.pushy.sdk.model.api.PushyAuthResponse;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyIO;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyFatalException;
import me.pushy.sdk.util.exceptions.PushyJsonParseException;

public class PushyAuthentication {
    public static PushyDeviceCredentials getDeviceCredentials(Context context) {
        PushyDeviceCredentials credentials = new PushyDeviceCredentials();
        credentials.token = PushyPreferences.getString(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), null, context);
        credentials.authKey = PushyPreferences.getString(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), null, context);
        String tokenPath = PushyPersistence.getEnvironmentExternalStoragePath("registration.id", context);
        String authKeyPath = PushyPersistence.getEnvironmentExternalStoragePath("registration.key", context);
        if (credentials.token == null) {
            try {
                if (PushyIO.fileExists(tokenPath)) {
                    credentials.token = PushyIO.readFromFile(tokenPath, context);
                }
                if (PushyIO.fileExists(authKeyPath)) {
                    credentials.authKey = PushyIO.readFromFile(authKeyPath, context);
                }
                if (!PushyStringUtils.stringIsNullOrEmpty(credentials.token)) {
                    PushyAuthentication.saveDeviceCredentials(credentials, context);
                }
            }
            catch (Exception exc) {
                PushyLogger.d("External storage access failed");
            }
        } else if (!PushyIO.fileExists(tokenPath) || credentials.authKey != null && !PushyIO.fileExists(authKeyPath)) {
            try {
                PushyAuthentication.saveDeviceCredentials(credentials, context);
            }
            catch (Exception exc) {
                PushyLogger.d("Persisting the credentials to external storage failed");
            }
        }
        if (credentials.token == null) {
            return null;
        }
        return credentials;
    }

    public static void clearDeviceCredentials(Context context) {
        PushyPreferences.remove(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), context);
        PushyPreferences.remove(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), context);
        try {
            PushyIO.deleteFile(PushyPersistence.getEnvironmentExternalStoragePath("registration.id", context));
            PushyIO.deleteFile(PushyPersistence.getEnvironmentExternalStoragePath("registration.key", context));
        }
        catch (Exception exc) {
            PushyLogger.d("Clearing device credentials from external storage failed");
        }
    }

    public static void saveDeviceCredentials(PushyDeviceCredentials credentials, Context context) {
        PushyPreferences.saveString(PushyPersistence.getEnvironmentPreferenceKey("pushyToken", context), credentials.token, context);
        if (credentials.authKey != null) {
            PushyPreferences.saveString(PushyPersistence.getEnvironmentPreferenceKey("pushyAuthKey", context), credentials.authKey, context);
        }
        try {
            PushyIO.writeToFile(PushyPersistence.getEnvironmentExternalStoragePath("registration.id", context), credentials.token, context);
            if (credentials.authKey != null) {
                PushyIO.writeToFile(PushyPersistence.getEnvironmentExternalStoragePath("registration.key", context), credentials.authKey, context);
            }
        }
        catch (Exception exc) {
            PushyLogger.d("Saving credentials to external storage failed");
        }
    }

    public static boolean validateCredentials(PushyDeviceCredentials credentials, Context context) throws PushyException {
        PushyAuthResponse response;
        String json;
        try {
            json = PushySingleton.getJackson().writeValueAsString(new PushyAuthRequest(credentials));
        }
        catch (JsonProcessingException exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        String jsonResponse = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/auth", json, context);
        try {
            response = PushySingleton.getJackson().readValue(jsonResponse, PushyAuthResponse.class);
        }
        catch (IOException exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            PushyLogger.e("Device auth validation failed: " + response.error);
            return false;
        }
        return response.success;
    }

    public static String obtainDeviceAuthKey(String token, Context context) throws Exception {
        String json = PushySingleton.getJackson().writeValueAsString(new PushyAuthMigrationRequest(token, context.getPackageName()));
        String jsonResponse = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/devices/auth/migrate", json, context);
        PushyAuthMigrationResponse response = PushySingleton.getJackson().readValue(jsonResponse, PushyAuthMigrationResponse.class);
        if (response.code == 404) {
            throw new PushyFatalException("Authentication migration failed due to unknown device: " + response.error);
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyException("Authentication migration failed: " + response.error);
        }
        if (PushyStringUtils.stringIsNullOrEmpty(response.auth)) {
            throw new PushyException("Authentication migration failed, please try again later.");
        }
        String authKey = response.auth;
        PushyDeviceCredentials credentials = new PushyDeviceCredentials(token, authKey);
        PushyAuthentication.saveDeviceCredentials(credentials, context);
        if (!PushyAuthentication.validateCredentials(credentials, context)) {
            throw new PushyException("Authentication validation failed, please try again later.");
        }
        return authKey;
    }
}

