/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import me.pushy.sdk.lib.jackson.annotation.JsonFormat;
import me.pushy.sdk.lib.jackson.core.JsonGenerator;
import me.pushy.sdk.lib.jackson.core.JsonParser;
import me.pushy.sdk.lib.jackson.databind.BeanProperty;
import me.pushy.sdk.lib.jackson.databind.JavaType;
import me.pushy.sdk.lib.jackson.databind.JsonMappingException;
import me.pushy.sdk.lib.jackson.databind.JsonNode;
import me.pushy.sdk.lib.jackson.databind.JsonSerializer;
import me.pushy.sdk.lib.jackson.databind.SerializationFeature;
import me.pushy.sdk.lib.jackson.databind.SerializerProvider;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import me.pushy.sdk.lib.jackson.databind.ser.ContextualSerializer;
import me.pushy.sdk.lib.jackson.databind.ser.std.StdScalarSerializer;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> type, Boolean useTimestamp, DateFormat customFormat) {
        super(type);
        this._useTimestamp = useTimestamp;
        this._customFormat = customFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format;
        if (property != null && (format = this.findFormatOverrides(serializers, property, this.handledType())) != null) {
            JsonFormat.Shape shape = format.getShape();
            if (shape.isNumeric()) {
                return this.withFormat(Boolean.TRUE, null);
            }
            if (shape == JsonFormat.Shape.STRING || format.hasPattern() || format.hasLocale() || format.hasTimeZone()) {
                TimeZone tz = format.getTimeZone();
                String pattern = format.hasPattern() ? format.getPattern() : "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                Locale loc = format.hasLocale() ? format.getLocale() : serializers.getLocale();
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = serializers.getTimeZone();
                }
                df.setTimeZone(tz);
                return this.withFormat(Boolean.FALSE, df);
            }
        }
        return this;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers, T value) {
        return false;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider serializers, Type typeHint) {
        return this.createSchemaNode(this._asTimestamp(serializers) ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._acceptJsonFormatVisitor(visitor, typeHint, this._asTimestamp(visitor.getProvider()));
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected boolean _asTimestamp(SerializerProvider serializers) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._customFormat == null) {
            if (serializers != null) {
                return serializers.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            throw new IllegalArgumentException("Null SerializerProvider passed for " + this.handledType().getName());
        }
        return false;
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint, boolean asNumber) throws JsonMappingException {
        if (asNumber) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.LONG, JsonValueFormat.UTC_MILLISEC);
        } else {
            this.visitStringFormat(visitor, typeHint, JsonValueFormat.DATE_TIME);
        }
    }
}

