/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.annotation.Annotation;
import me.pushy.sdk.lib.jackson.core.JsonGenerator;
import me.pushy.sdk.lib.jackson.databind.BeanProperty;
import me.pushy.sdk.lib.jackson.databind.JavaType;
import me.pushy.sdk.lib.jackson.databind.JsonMappingException;
import me.pushy.sdk.lib.jackson.databind.JsonSerializer;
import me.pushy.sdk.lib.jackson.databind.PropertyMetadata;
import me.pushy.sdk.lib.jackson.databind.PropertyName;
import me.pushy.sdk.lib.jackson.databind.SerializerProvider;
import me.pushy.sdk.lib.jackson.databind.introspect.AnnotatedMember;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import me.pushy.sdk.lib.jackson.databind.jsontype.TypeSerializer;
import me.pushy.sdk.lib.jackson.databind.node.ObjectNode;
import me.pushy.sdk.lib.jackson.databind.ser.PropertyWriter;

public class MapProperty
extends PropertyWriter {
    private static final long serialVersionUID = 1L;
    private static final BeanProperty BOGUS_PROP = new BeanProperty.Bogus();
    protected final TypeSerializer _typeSerializer;
    protected final BeanProperty _property;
    protected Object _key;
    protected JsonSerializer<Object> _keySerializer;
    protected JsonSerializer<Object> _valueSerializer;

    public MapProperty(TypeSerializer typeSer, BeanProperty prop) {
        super(prop == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : prop.getMetadata());
        this._typeSerializer = typeSer;
        this._property = prop == null ? BOGUS_PROP : prop;
    }

    public void reset(Object key, JsonSerializer<Object> keySer, JsonSerializer<Object> valueSer) {
        this._key = key;
        this._keySerializer = keySer;
        this._valueSerializer = valueSer;
    }

    @Override
    public String getName() {
        if (this._key instanceof String) {
            return (String)this._key;
        }
        return String.valueOf(this._key);
    }

    @Override
    public PropertyName getFullName() {
        return new PropertyName(this.getName());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._property.getAnnotation(acls);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this._property.getContextAnnotation(acls);
    }

    @Override
    public void serializeAsField(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this._keySerializer.serialize(this._key, gen, provider);
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(value, gen, provider);
        } else {
            this._valueSerializer.serializeWithType(value, gen, provider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsOmittedField(Object value, JsonGenerator gen, SerializerProvider provider) throws Exception {
        if (!gen.canOmitFields()) {
            gen.writeOmittedField(this.getName());
        }
    }

    @Override
    public void serializeAsElement(Object value, JsonGenerator gen, SerializerProvider provider) throws Exception {
        if (this._typeSerializer == null) {
            this._valueSerializer.serialize(value, gen, provider);
        } else {
            this._valueSerializer.serializeWithType(value, gen, provider, this._typeSerializer);
        }
    }

    @Override
    public void serializeAsPlaceholder(Object value, JsonGenerator gen, SerializerProvider provider) throws Exception {
        gen.writeNull();
    }

    @Override
    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor, SerializerProvider provider) throws JsonMappingException {
        this._property.depositSchemaProperty(objectVisitor, provider);
    }

    @Override
    @Deprecated
    public void depositSchemaProperty(ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
    }

    @Override
    public JavaType getType() {
        return this._property.getType();
    }

    @Override
    public PropertyName getWrapperName() {
        return this._property.getWrapperName();
    }

    @Override
    public AnnotatedMember getMember() {
        return this._property.getMember();
    }
}

