/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import me.pushy.sdk.util.PushyLogger;

public class PushyBroadcastManager {
    static Method mOnReceiveMethod;
    static BroadcastReceiver mBroadcastReceiver;

    public static void sendBroadcast(Context context, Intent intent) {
        PackageManager pm;
        List matches;
        if (mBroadcastReceiver != null && mOnReceiveMethod != null) {
            try {
                mOnReceiveMethod.invoke((Object)mBroadcastReceiver, context, intent);
                Log.d((String)"Pushy", (String)("Invoking cached push receiver via reflection: " + mBroadcastReceiver.getClass().getName()));
                return;
            }
            catch (Exception exc) {
                Log.e((String)"Pushy", (String)"Invoking cached push receiver via reflection failed", (Throwable)exc);
            }
        }
        if ((matches = (pm = context.getPackageManager()).queryBroadcastReceivers(intent, 0)).size() == 0) {
            PushyLogger.e("No suitable push BroadcastReceiver declared in AndroidManifest.xml matching the following intent filter: pushy.me");
            return;
        }
        ResolveInfo resolveInfo = (ResolveInfo)matches.get(0);
        try {
            Class<?> receiverClass = Class.forName(resolveInfo.activityInfo.name);
            Constructor<?> receiverConstructor = receiverClass.getDeclaredConstructor(new Class[0]);
            mBroadcastReceiver = (BroadcastReceiver)receiverConstructor.newInstance(new Object[0]);
            mOnReceiveMethod = mBroadcastReceiver.getClass().getDeclaredMethod("onReceive", Context.class, Intent.class);
            mOnReceiveMethod.invoke((Object)mBroadcastReceiver, context, intent);
            Log.d((String)"Pushy", (String)("Invoking push receiver via reflection: " + resolveInfo.activityInfo.name));
        }
        catch (Exception exc) {
            Log.e((String)"Pushy", (String)"Invoking push receiver via reflection failed", (Throwable)exc);
        }
    }
}

