/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import me.pushy.sdk.model.PushyBroadcastReceiver;
import me.pushy.sdk.util.PushyLogger;

public class PushyBroadcastManager {
    static List<PushyBroadcastReceiver> mCachedPushReceivers;

    public static void sendBroadcast(Context context, Intent intent) {
        if (mCachedPushReceivers != null && mCachedPushReceivers.size() > 0) {
            for (PushyBroadcastReceiver receiver : mCachedPushReceivers) {
                Log.d((String)"Pushy", (String)("Invoking cached push receiver via reflection: " + receiver.getReceiver().getClass().getName()));
                receiver.execute(context, intent);
            }
            return;
        }
        mCachedPushReceivers = new ArrayList<PushyBroadcastReceiver>();
        PackageManager pm = context.getPackageManager();
        List matches = pm.queryBroadcastReceivers(intent, 0);
        if (matches.size() == 0) {
            PushyLogger.e("No suitable push BroadcastReceiver declared in AndroidManifest.xml matching the following intent filter: pushy.me");
            return;
        }
        for (ResolveInfo resolveInfo : matches) {
            try {
                Class<?> receiverClass = Class.forName(resolveInfo.activityInfo.name);
                Constructor<?> receiverConstructor = receiverClass.getDeclaredConstructor(new Class[0]);
                BroadcastReceiver broadcastReceiver = (BroadcastReceiver)receiverConstructor.newInstance(new Object[0]);
                Method onReceiveMethod = broadcastReceiver.getClass().getDeclaredMethod("onReceive", Context.class, Intent.class);
                PushyBroadcastReceiver receiver = new PushyBroadcastReceiver(broadcastReceiver, onReceiveMethod);
                mCachedPushReceivers.add(receiver);
                Log.d((String)"Pushy", (String)("Invoking push receiver via reflection: " + resolveInfo.activityInfo.name));
                receiver.execute(context, intent);
            }
            catch (Exception exc) {
                Log.e((String)"Pushy", (String)"Invoking push receiver via reflection failed", (Throwable)exc);
            }
        }
    }
}

