/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.content.Context;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.util.Collections;
import java.util.Map;
import me.pushy.sdk.Pushy;
import me.pushy.sdk.util.PushyAPI;
import me.pushy.sdk.util.PushyBroadcastManager;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;

public class PushyFirebaseService
extends FirebaseMessagingService {
    public void onMessageReceived(RemoteMessage remoteMessage) {
        Map payload = remoteMessage.getData();
        if (payload == null || payload.size() == 0) {
            PushyLogger.e("Received empty push from FCM");
            return;
        }
        PushyLogger.d("Received push via FCM for package " + this.getPackageName() + "\n" + payload);
        try {
            PushyBroadcastManager.publishNotification((Context)this, Collections.unmodifiableMap(payload));
            PushyAPI.setPushDelivered(payload, (Context)this);
        }
        catch (Exception exc) {
            PushyLogger.e("Publishing notification failed: " + exc.getMessage(), exc);
        }
    }

    public void onNewToken(String token) {
        if (!Pushy.isRegistered((Context)this)) {
            PushyLogger.d("FCM onNewToken() called when device is not registered");
            return;
        }
        if (!PushyPreferences.getBoolean("pushyFCMEnabled", false, (Context)this)) {
            PushyLogger.d("FCM onNewToken() called when FCM fallback is not enabled");
            return;
        }
        if (token.equals(PushyPreferences.getString("pushyFCMToken", "", (Context)this))) {
            PushyLogger.d("FCM onNewToken() called with old token");
            return;
        }
        PushyLogger.d("FCM device token refreshed: " + token);
        try {
            PushyAPI.setFCMToken(token, (Context)this);
        }
        catch (Exception e) {
            PushyLogger.e(e.getMessage(), e);
        }
    }
}

