/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal;

import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttSecurityException;

public class ExceptionHelper {
    public static MqttException createMqttException(int reasonCode) {
        if (reasonCode == 4 || reasonCode == 5) {
            return new MqttSecurityException(reasonCode);
        }
        return new MqttException(reasonCode);
    }

    public static MqttException createMqttException(Throwable cause) {
        if (cause.getClass().getName().equals("java.security.GeneralSecurityException")) {
            return new MqttSecurityException(cause);
        }
        return new MqttException(cause);
    }

    public static boolean isClassAvailable(String className) {
        boolean result = false;
        try {
            Class.forName(className);
            result = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return result;
    }

    private ExceptionHelper() {
    }
}

