/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.jackson.databind.ser.impl;

import java.io.IOException;
import me.pushy.sdk.lib.jackson.annotation.ObjectIdGenerator;
import me.pushy.sdk.lib.jackson.core.JsonGenerator;
import me.pushy.sdk.lib.jackson.core.SerializableString;
import me.pushy.sdk.lib.jackson.databind.SerializerProvider;
import me.pushy.sdk.lib.jackson.databind.ser.impl.ObjectIdWriter;

public final class WritableObjectId {
    public final ObjectIdGenerator<?> generator;
    public Object id;
    protected boolean idWritten = false;

    public WritableObjectId(ObjectIdGenerator<?> generator) {
        this.generator = generator;
    }

    public boolean writeAsId(JsonGenerator gen, SerializerProvider provider, ObjectIdWriter w) throws IOException {
        if (this.id != null && (this.idWritten || w.alwaysAsId)) {
            if (gen.canWriteObjectId()) {
                gen.writeObjectRef(String.valueOf(this.id));
            } else {
                w.serializer.serialize(this.id, gen, provider);
            }
            return true;
        }
        return false;
    }

    public Object generateId(Object forPojo) {
        if (this.id == null) {
            this.id = this.generator.generateId(forPojo);
        }
        return this.id;
    }

    public void writeAsField(JsonGenerator gen, SerializerProvider provider, ObjectIdWriter w) throws IOException {
        this.idWritten = true;
        if (gen.canWriteObjectId()) {
            gen.writeObjectId(String.valueOf(this.id));
            return;
        }
        SerializableString name = w.propertyName;
        if (name != null) {
            gen.writeFieldName(name);
            w.serializer.serialize(this.id, gen, provider);
        }
    }
}

