/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttPersistable;
import me.pushy.sdk.lib.paho.internal.ExceptionHelper;
import me.pushy.sdk.lib.paho.internal.wire.CountingInputStream;
import me.pushy.sdk.lib.paho.internal.wire.MqttConnack;
import me.pushy.sdk.lib.paho.internal.wire.MqttConnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttDisconnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttPingReq;
import me.pushy.sdk.lib.paho.internal.wire.MqttPingResp;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubAck;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubComp;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubRec;
import me.pushy.sdk.lib.paho.internal.wire.MqttPubRel;
import me.pushy.sdk.lib.paho.internal.wire.MqttPublish;
import me.pushy.sdk.lib.paho.internal.wire.MqttSuback;
import me.pushy.sdk.lib.paho.internal.wire.MqttSubscribe;
import me.pushy.sdk.lib.paho.internal.wire.MqttUnsubAck;
import me.pushy.sdk.lib.paho.internal.wire.MqttUnsubscribe;
import me.pushy.sdk.lib.paho.internal.wire.MultiByteArrayInputStream;
import me.pushy.sdk.lib.paho.internal.wire.MultiByteInteger;

public abstract class MqttWireMessage {
    public static final byte MESSAGE_TYPE_CONNECT = 1;
    public static final byte MESSAGE_TYPE_CONNACK = 2;
    public static final byte MESSAGE_TYPE_PUBLISH = 3;
    public static final byte MESSAGE_TYPE_PUBACK = 4;
    public static final byte MESSAGE_TYPE_PUBREC = 5;
    public static final byte MESSAGE_TYPE_PUBREL = 6;
    public static final byte MESSAGE_TYPE_PUBCOMP = 7;
    public static final byte MESSAGE_TYPE_SUBSCRIBE = 8;
    public static final byte MESSAGE_TYPE_SUBACK = 9;
    public static final byte MESSAGE_TYPE_UNSUBSCRIBE = 10;
    public static final byte MESSAGE_TYPE_UNSUBACK = 11;
    public static final byte MESSAGE_TYPE_PINGREQ = 12;
    public static final byte MESSAGE_TYPE_PINGRESP = 13;
    public static final byte MESSAGE_TYPE_DISCONNECT = 14;
    protected static final String STRING_ENCODING = "UTF-8";
    private static final String[] PACKET_NAMES = new String[]{"reserved", "CONNECT", "CONNACK", "PUBLISH", "PUBACK", "PUBREC", "PUBREL", "PUBCOMP", "SUBSCRIBE", "SUBACK", "UNSUBSCRIBE", "UNSUBACK", "PINGREQ", "PINGRESP", "DISCONNECT"};
    private byte type;
    protected int msgId;
    protected boolean duplicate = false;

    public MqttWireMessage(byte type) {
        this.type = type;
        this.msgId = 0;
    }

    protected abstract byte getMessageInfo();

    public byte[] getPayload() throws MqttException {
        return new byte[0];
    }

    public byte getType() {
        return this.type;
    }

    public int getMessageId() {
        return this.msgId;
    }

    public void setMessageId(int msgId) {
        this.msgId = msgId;
    }

    public String getKey() {
        return new Integer(this.getMessageId()).toString();
    }

    public byte[] getHeader() throws MqttException {
        try {
            int first = (this.getType() & 0xF) << 4 ^ this.getMessageInfo() & 0xF;
            byte[] varHeader = this.getVariableHeader();
            int remLen = varHeader.length + this.getPayload().length;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeByte(first);
            dos.write(MqttWireMessage.encodeMBI(remLen));
            dos.write(varHeader);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new MqttException(ioe);
        }
    }

    protected abstract byte[] getVariableHeader() throws MqttException;

    public boolean isMessageIdRequired() {
        return true;
    }

    public static MqttWireMessage createWireMessage(MqttPersistable data) throws MqttException {
        byte[] payload = data.getPayloadBytes();
        if (payload == null) {
            payload = new byte[]{};
        }
        MultiByteArrayInputStream mbais = new MultiByteArrayInputStream(data.getHeaderBytes(), data.getHeaderOffset(), data.getHeaderLength(), payload, data.getPayloadOffset(), data.getPayloadLength());
        return MqttWireMessage.createWireMessage(mbais);
    }

    public static MqttWireMessage createWireMessage(byte[] bytes) throws MqttException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return MqttWireMessage.createWireMessage(bais);
    }

    private static MqttWireMessage createWireMessage(InputStream inputStream) throws MqttException {
        try {
            MqttWireMessage result;
            CountingInputStream counter = new CountingInputStream(inputStream);
            DataInputStream in = new DataInputStream(counter);
            int first = in.readUnsignedByte();
            byte type = (byte)(first >> 4);
            byte info = (byte)(first &= 0xF);
            long remLen = MqttWireMessage.readMBI(in).getValue();
            long totalToRead = (long)counter.getCounter() + remLen;
            long remainder = totalToRead - (long)counter.getCounter();
            byte[] data = new byte[]{};
            if (remainder > 0L) {
                data = new byte[(int)remainder];
                in.readFully(data, 0, data.length);
            }
            if (type == 1) {
                result = new MqttConnect(info, data);
            } else if (type == 3) {
                result = new MqttPublish(info, data);
            } else if (type == 4) {
                result = new MqttPubAck(info, data);
            } else if (type == 7) {
                result = new MqttPubComp(info, data);
            } else if (type == 2) {
                result = new MqttConnack(info, data);
            } else if (type == 12) {
                result = new MqttPingReq(info, data);
            } else if (type == 13) {
                result = new MqttPingResp(info, data);
            } else if (type == 8) {
                result = new MqttSubscribe(info, data);
            } else if (type == 9) {
                result = new MqttSuback(info, data);
            } else if (type == 10) {
                result = new MqttUnsubscribe(info, data);
            } else if (type == 11) {
                result = new MqttUnsubAck(info, data);
            } else if (type == 6) {
                result = new MqttPubRel(info, data);
            } else if (type == 5) {
                result = new MqttPubRec(info, data);
            } else if (type == 14) {
                result = new MqttDisconnect(info, data);
            } else {
                throw ExceptionHelper.createMqttException(6);
            }
            return result;
        }
        catch (IOException io) {
            throw new MqttException(io);
        }
    }

    protected static byte[] encodeMBI(long number) {
        int numBytes = 0;
        long no = number;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        do {
            byte digit = (byte)(no % 128L);
            if ((no /= 128L) > 0L) {
                digit = (byte)(digit | 0x80);
            }
            bos.write(digit);
        } while (no > 0L && ++numBytes < 4);
        return bos.toByteArray();
    }

    protected static MultiByteInteger readMBI(DataInputStream in) throws IOException {
        byte digit;
        long msgLength = 0L;
        int multiplier = 1;
        int count = 0;
        do {
            digit = in.readByte();
            ++count;
            msgLength += (long)((digit & 0x7F) * multiplier);
            multiplier *= 128;
        } while ((digit & 0x80) != 0);
        return new MultiByteInteger(msgLength, count);
    }

    protected byte[] encodeMessageId() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeShort(this.msgId);
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public boolean isRetryable() {
        return false;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    protected void encodeUTF8(DataOutputStream dos, String stringToEncode) throws MqttException {
        try {
            byte[] encodedString = stringToEncode.getBytes(STRING_ENCODING);
            byte byte1 = (byte)(encodedString.length >>> 8 & 0xFF);
            byte byte2 = (byte)(encodedString.length >>> 0 & 0xFF);
            dos.write(byte1);
            dos.write(byte2);
            dos.write(encodedString);
        }
        catch (UnsupportedEncodingException ex) {
            throw new MqttException(ex);
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    protected String decodeUTF8(DataInputStream input) throws MqttException {
        try {
            int encodedLength = input.readUnsignedShort();
            byte[] encodedString = new byte[encodedLength];
            input.readFully(encodedString);
            return new String(encodedString, STRING_ENCODING);
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    public String toString() {
        return PACKET_NAMES[this.type];
    }
}

