/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.app.AlarmManager;
import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.SystemClock;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.receivers.PushyPushReceiver;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyMqttConnection;
import me.pushy.sdk.util.PushyNetworking;
import me.pushy.sdk.util.PushyParcelableUtil;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.exceptions.PushyFatalException;

public class PushySocketService
extends Service {
    private WifiManager mWifiManager;
    private AlarmManager mAlarmManager;
    private ConnectivityManager mConnectivityManager;
    private boolean mIsDestroyed;
    private static PushyMqttConnection mSocket;
    private long mRetryInterval = 500L;
    public static final String ACTION_START = "Pushy.START";
    public static final String ACTION_RECONNECT = "Pushy.RECONNECT";
    public static final String ACTION_KEEP_ALIVE = "Pushy.KEEP_ALIVE";
    private BroadcastReceiver mConnectivityListener = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (PushyNetworking.isNetworkAvailable(PushySocketService.this.mConnectivityManager)) {
                PushyLogger.d("Internet connected");
                if (!mSocket.isConnected()) {
                    PushySocketService.this.reconnectAsync();
                } else if (PushyNetworking.getConnectedNetwork(PushySocketService.this.mConnectivityManager) == 1 && mSocket.getNetwork() == 0) {
                    PushySocketService.this.reconnectAsync();
                }
            } else {
                PushyLogger.d("Internet disconnected");
                PushySocketService.this.cancelReconnect();
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        PushyLogger.d("Creating service");
        this.mWifiManager = (WifiManager)this.getApplicationContext().getSystemService("wifi");
        this.mAlarmManager = (AlarmManager)this.getApplicationContext().getSystemService("alarm");
        this.mConnectivityManager = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        mSocket = new PushyMqttConnection((Context)this, this.mWifiManager, this.mConnectivityManager, new ConnectionLostRunnable());
        this.handleCrashedService();
        this.start();
        this.registerReceiver(this.mConnectivityListener, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        new StartForegroundAsync().execute(new Integer[0]);
    }

    public static boolean isConnected() {
        return mSocket != null && mSocket.isConnected();
    }

    public static void setForegroundNotification(Notification notification, Context context) {
        String result = null;
        if (notification != null) {
            notification.contentIntent = null;
            result = PushyParcelableUtil.byteArrayToString(PushyParcelableUtil.marshall((Parcelable)notification));
        }
        PushySingleton.getSettings(context).edit().putString("pushyForegroundNotification", result).commit();
    }

    public static boolean isForegroundServiceEnabled(Context context) {
        return PushySingleton.getSettings(context).getString("pushyForegroundNotification", null) != null;
    }

    private static Notification getForegroundNotification(Context context) {
        String raw = PushySingleton.getSettings(context).getString("pushyForegroundNotification", null);
        if (raw == null) {
            return null;
        }
        byte[] array = PushyParcelableUtil.stringToByteArray(raw);
        Notification notification = (Notification)PushyParcelableUtil.unmarshall(array, Notification.CREATOR);
        notification.contentIntent = PushyPushReceiver.getMainActivityPendingIntent(context);
        return notification;
    }

    public void onTaskRemoved(Intent rootIntent) {
        PushyLogger.d("Task removed, attempting restart in 3 seconds");
        Intent restartService = new Intent(this.getApplicationContext(), ((Object)((Object)this)).getClass());
        restartService.setPackage(this.getPackageName());
        PendingIntent restartServiceIntent = PendingIntent.getService((Context)this.getApplicationContext(), (int)1, (Intent)restartService, (int)0x40000000);
        this.mAlarmManager.set(3, SystemClock.elapsedRealtime() + 3000L, restartServiceIntent);
    }

    private void handleCrashedService() {
        this.stopKeepAliveTimerAndWifiLock();
        this.cancelReconnect();
    }

    public void onDestroy() {
        PushyLogger.d("Service destroyed");
        this.mIsDestroyed = true;
        this.stop();
        new StopForegroundAsync().execute(new Integer[0]);
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent == null || intent.getAction() == null) {
            this.start();
        } else if (intent.getAction().equals(ACTION_START)) {
            this.start();
        } else if (intent.getAction().equals(ACTION_KEEP_ALIVE)) {
            this.sendKeepAlive();
        } else if (intent.getAction().equals(ACTION_RECONNECT)) {
            this.reconnectAsync();
        }
        return 1;
    }

    private void start() {
        if (!PushyNetworking.isNetworkAvailable(this.mConnectivityManager)) {
            return;
        }
        if (mSocket.isConnecting() || mSocket.isConnected()) {
            return;
        }
        new ConnectAsync().execute(new Integer[0]);
    }

    private void stop() {
        this.cancelReconnect();
        this.stopKeepAliveTimerAndWifiLock();
        this.unregisterReceiver(this.mConnectivityListener);
        mSocket.disconnectExistingClientAsync();
    }

    private void sendKeepAlive() {
        if (mSocket.isConnected()) {
            new SendKeepAliveAsync().execute(new Integer[0]);
        }
    }

    private void startKeepAliveTimerAndWifiLock() {
        long interval = PushyMqttConnection.getKeepAliveInterval((Context)this) * 1000;
        PendingIntent pendingIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.setRepeating(0, System.currentTimeMillis() + interval, interval, pendingIntent);
        mSocket.acquireWifiLock();
    }

    PendingIntent getAlarmPendingIntent(String action) {
        Intent keepAliveIntent = new Intent();
        keepAliveIntent.setClass((Context)this, PushySocketService.class);
        keepAliveIntent.setAction(action);
        return PendingIntent.getService((Context)this, (int)0, (Intent)keepAliveIntent, (int)0);
    }

    private void stopKeepAliveTimerAndWifiLock() {
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_KEEP_ALIVE);
        this.mAlarmManager.cancel(keepAliveIntent);
        mSocket.releaseWifiLock();
    }

    public void scheduleReconnect() {
        long now = System.currentTimeMillis();
        if (this.mRetryInterval < 60000L) {
            this.mRetryInterval = Math.min(this.mRetryInterval * 2L, 60000L);
        }
        PushyLogger.d("Reconnecting in " + this.mRetryInterval + "ms.");
        PendingIntent keepAliveIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.set(0, now + this.mRetryInterval, keepAliveIntent);
    }

    public void cancelReconnect() {
        PendingIntent reconnectIntent = this.getAlarmPendingIntent(ACTION_RECONNECT);
        this.mAlarmManager.cancel(reconnectIntent);
    }

    private void reconnectAsync() {
        this.stopKeepAliveTimerAndWifiLock();
        if (this.mIsDestroyed) {
            PushyLogger.d("Not reconnecting (service destroyed)");
            return;
        }
        if (!PushyNetworking.isNetworkAvailable(this.mConnectivityManager)) {
            PushyLogger.d("Not reconnecting (network not available)");
            return;
        }
        if (mSocket.isConnecting()) {
            PushyLogger.d("Already reconnecting");
            return;
        }
        PushyLogger.d("Reconnecting...");
        new ConnectAsync().execute(new Integer[0]);
    }

    public IBinder onBind(Intent intent) {
        return null;
    }

    public class StopForegroundAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (PushySocketService.isForegroundServiceEnabled((Context)PushySocketService.this)) {
                PushySocketService.this.stopForeground(true);
            }
            return 0;
        }
    }

    public class StartForegroundAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (PushySocketService.isForegroundServiceEnabled((Context)PushySocketService.this)) {
                PushySocketService.this.startForeground(100031, PushySocketService.getForegroundNotification((Context)PushySocketService.this));
            }
            return 0;
        }
    }

    public class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!mSocket.isConnected()) {
                return 0;
            }
            PushyLogger.d("Sending keep alive");
            try {
                mSocket.sendKeepAlive();
            }
            catch (Exception e) {
                PushyLogger.d("Keep alive error: " + e.toString(), e);
                mSocket.disconnectExistingClientSync();
                PushySocketService.this.reconnectAsync();
            }
            return 0;
        }
    }

    public class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        public ConnectAsync() {
            mSocket.setConnecting(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(Integer ... parameter) {
            if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, PushySocketService.this.getApplicationContext())) {
                PushyLogger.d("Notifications have been disabled by the app");
                PushySocketService.this.cancelReconnect();
                PushySocketService.this.stopSelf();
                return 0;
            }
            PushyLogger.d("Connecting...");
            try {
                mSocket.connect();
                if (PushySocketService.this.mIsDestroyed) {
                    mSocket.disconnectExistingClientSync();
                    PushyLogger.d("Service destroyed, aborting connection");
                    Integer n = 0;
                    return n;
                }
                PushySocketService.this.mRetryInterval = 500L;
                PushySocketService.this.startKeepAliveTimerAndWifiLock();
                PushyLogger.d("Connected successfully (sending keep alive every " + PushyMqttConnection.getKeepAliveInterval((Context)PushySocketService.this) + " seconds)");
            }
            catch (Exception e) {
                PushyLogger.d("Connect exception: " + e.toString(), e);
                if (e.getClass() == PushyFatalException.class) {
                    PushyLogger.d("Fatal error encountered, stopping service");
                    PushySocketService.this.stopSelf();
                    Integer n = 0;
                    return n;
                }
                if (e.getClass() == MqttSecurityException.class && ((MqttSecurityException)e).getReasonCode() == 5) {
                    PushyLogger.d("MQTT connect returned error code 5, clearing the device credentials");
                    PushyAuthentication.clearDeviceCredentials((Context)PushySocketService.this);
                    PushySocketService.this.stopSelf();
                    Integer n = 0;
                    return n;
                }
                if (PushyNetworking.isNetworkAvailable(PushySocketService.this.mConnectivityManager)) {
                    PushySocketService.this.scheduleReconnect();
                }
            }
            finally {
                mSocket.setConnecting(false);
            }
            return 0;
        }
    }

    public class ConnectionLostRunnable
    implements Runnable {
        @Override
        public void run() {
            PushySocketService.this.reconnectAsync();
        }
    }
}

