/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.jackson.databind.ser.impl;

import java.io.IOException;
import java.lang.reflect.Type;
import me.pushy.sdk.lib.jackson.core.JsonGenerator;
import me.pushy.sdk.lib.jackson.databind.JavaType;
import me.pushy.sdk.lib.jackson.databind.JsonMappingException;
import me.pushy.sdk.lib.jackson.databind.JsonNode;
import me.pushy.sdk.lib.jackson.databind.SerializationFeature;
import me.pushy.sdk.lib.jackson.databind.SerializerProvider;
import me.pushy.sdk.lib.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import me.pushy.sdk.lib.jackson.databind.jsontype.TypeSerializer;
import me.pushy.sdk.lib.jackson.databind.ser.std.StdSerializer;

public class UnknownSerializer
extends StdSerializer<Object> {
    public UnknownSerializer() {
        super(Object.class);
    }

    public UnknownSerializer(Class<?> cls) {
        super(cls, false);
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        gen.writeStartObject();
        gen.writeEndObject();
    }

    @Override
    public final void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (provider.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            this.failForEmpty(provider, value);
        }
        typeSer.writeTypePrefixForObject(value, gen);
        typeSer.writeTypeSuffixForObject(value, gen);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Object value) {
        return true;
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return null;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        visitor.expectAnyFormat(typeHint);
    }

    protected void failForEmpty(SerializerProvider prov, Object value) throws JsonMappingException {
        prov.reportBadDefinition(this.handledType(), String.format("No serializer found for class %s and no properties discovered to create BeanSerializer (to avoid exception, disable SerializationFeature.FAIL_ON_EMPTY_BEANS)", value.getClass().getName()));
    }
}

