/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho.internal.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLSocketFactory;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.internal.SSLNetworkModule;
import me.pushy.sdk.lib.paho.internal.websocket.WebSocketFrame;
import me.pushy.sdk.lib.paho.internal.websocket.WebSocketHandshake;
import me.pushy.sdk.lib.paho.internal.websocket.WebSocketReceiver;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;

public class WebSocketSecureNetworkModule
extends SSLNetworkModule {
    private static final String CLASS_NAME = WebSocketSecureNetworkModule.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private PipedInputStream pipedInputStream;
    private WebSocketReceiver webSocketReceiver;
    private String uri;
    private String host;
    private int port;
    ByteBuffer recievedPayload;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            ByteBuffer byteBuffer;
            1 var2_1 = this;
            synchronized (var2_1) {
                byteBuffer = ByteBuffer.wrap(this.toByteArray());
                this.reset();
            }
            WebSocketFrame frame = new WebSocketFrame(2, true, byteBuffer.array());
            byte[] rawFrame = frame.encodeFrame();
            WebSocketSecureNetworkModule.this.getSocketOutputStream().write(rawFrame);
            WebSocketSecureNetworkModule.this.getSocketOutputStream().flush();
        }
    };

    public WebSocketSecureNetworkModule(SSLSocketFactory factory, String uri, String host, int port, String clientId) {
        super(factory, host, port, clientId);
        this.uri = uri;
        this.host = host;
        this.port = port;
        this.pipedInputStream = new PipedInputStream();
        log.setResourceName(clientId);
    }

    @Override
    public void start() throws IOException, MqttException {
        super.start();
        WebSocketHandshake handshake = new WebSocketHandshake(super.getInputStream(), super.getOutputStream(), this.uri, this.host, this.port);
        handshake.execute();
        this.webSocketReceiver = new WebSocketReceiver(this.getSocketInputStream(), this.pipedInputStream);
        this.webSocketReceiver.start("WssSocketReceiver");
    }

    private OutputStream getSocketOutputStream() throws IOException {
        return super.getOutputStream();
    }

    private InputStream getSocketInputStream() throws IOException {
        return super.getInputStream();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.pipedInputStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStream;
    }

    @Override
    public void stop() throws IOException {
        WebSocketFrame frame = new WebSocketFrame(8, true, "1000".getBytes());
        byte[] rawFrame = frame.encodeFrame();
        this.getSocketOutputStream().write(rawFrame);
        this.getSocketOutputStream().flush();
        if (this.webSocketReceiver != null) {
            this.webSocketReceiver.stop();
        }
        super.stop();
    }

    @Override
    public String getServerURI() {
        return "wss://" + this.host + ":" + this.port;
    }
}

