/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import me.pushy.sdk.config.PushyMQTT;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyMqttConnection;
import me.pushy.sdk.util.PushyNetworking;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.exceptions.PushyDateTime;
import me.pushy.sdk.util.exceptions.PushyFatalException;

@TargetApi(value=21)
public class PushyJobService
extends JobService {
    private static WifiManager mWifiManager;
    private static ConnectivityManager mConnectivityManager;
    private JobParameters mParams;
    private static PushyMqttConnection mSocket;
    private static long mLastKeepAlive;
    private static long mKeepAliveInterval;
    private static long mRetryInterval;

    public boolean onStartJob(JobParameters params) {
        String command;
        this.mParams = params;
        if (mWifiManager == null) {
            mWifiManager = (WifiManager)this.getApplicationContext().getSystemService("wifi");
        }
        if (mConnectivityManager == null) {
            mConnectivityManager = (ConnectivityManager)this.getApplicationContext().getSystemService("connectivity");
        }
        if (mSocket == null) {
            mSocket = new PushyMqttConnection((Context)this, mWifiManager, mConnectivityManager, new ConnectionLostRunnable());
        }
        if ((command = params.getExtras().getString("command")) != null && command.equals("stop")) {
            PushyLogger.d("Stop requested");
            mSocket.disconnectExistingClientAsync();
            this.endJob(true);
            return true;
        }
        if (!mSocket.isConnected() && !mSocket.isConnecting()) {
            this.connect();
        } else if (mSocket.isConnected() && PushyNetworking.getConnectedNetwork(mConnectivityManager) == 1 && mSocket.getNetwork() == 0) {
            new ReconnectAsync().execute(new Integer[0]);
        } else if (mLastKeepAlive + mKeepAliveInterval < PushyDateTime.getCurrentTimestamp() + (long)PushyMQTT.MQTT_JOB_TASK_INTERVAL_PADDING) {
            this.sendKeepAlive();
        } else {
            this.scheduleJobAgain(true, this.getJobServiceInterval());
            return true;
        }
        return true;
    }

    void endJob(boolean async) {
        if (async) {
            new EndJobAsync().execute(new Integer[0]);
        } else {
            this.jobFinished(this.mParams, false);
        }
    }

    private void connect() {
        if (!PushyNetworking.isNetworkAvailable(mConnectivityManager)) {
            this.scheduleReconnect();
            return;
        }
        if (mSocket.isConnecting() || mSocket.isConnected()) {
            this.scheduleJobAgain(true, this.getJobServiceInterval());
            return;
        }
        new ConnectAsync().execute(new Integer[0]);
    }

    public static boolean isConnected() {
        return mSocket != null && mSocket.isConnected();
    }

    private int getJobServiceInterval() {
        return PushyMQTT.MQTT_DEFAULT_JOB_SERVICE_INTERVAL * 1000;
    }

    private void sendKeepAlive() {
        mLastKeepAlive = PushyDateTime.getCurrentTimestamp();
        if (mSocket.isConnected()) {
            new SendKeepAliveAsync().execute(new Integer[0]);
        }
    }

    public void scheduleReconnect() {
        if (mRetryInterval < 60000L) {
            mRetryInterval = Math.min(mRetryInterval * 2L, 60000L);
        }
        PushyLogger.d("Reconnecting in " + mRetryInterval + "ms");
        this.scheduleJobAgain(true, mRetryInterval);
    }

    void scheduleJobAgain(boolean async, long interval) {
        if (async) {
            new ScheduleJobAgainAsync().execute(new Long[]{interval});
        } else {
            ComponentName serviceName = new ComponentName(this.getPackageName(), PushyJobService.class.getName());
            JobInfo jobInfo = new JobInfo.Builder(PushyMQTT.MQTT_JOB_ID, serviceName).setRequiredNetworkType(1).setMinimumLatency(interval).setOverrideDeadline(interval).build();
            JobScheduler jobScheduler = (JobScheduler)this.getSystemService("jobscheduler");
            try {
                jobScheduler.schedule(jobInfo);
                this.endJob(true);
            }
            catch (Exception exc) {
                PushyLogger.e("JobScheduler error: " + exc.getMessage(), exc);
                new ScheduleJobAgainAsync().execute(new Long[]{interval});
            }
        }
    }

    public boolean onStopJob(JobParameters params) {
        return false;
    }

    static {
        mRetryInterval = 500L;
    }

    public class ScheduleJobAgainAsync
    extends AsyncTask<Long, String, Integer> {
        protected Integer doInBackground(Long ... parameter) {
            PushyJobService.this.scheduleJobAgain(false, parameter[0]);
            return 0;
        }
    }

    public class ConnectionLostRunnable
    implements Runnable {
        @Override
        public void run() {
            PushyJobService.this.connect();
        }
    }

    public class ReconnectAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            PushyLogger.d("PushyJobService: Reconnecting due to connectivity change...");
            mSocket.disconnectExistingClientSync();
            PushyJobService.this.connect();
            return 0;
        }
    }

    public class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        public ConnectAsync() {
            mSocket.setConnecting(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(Integer ... parameter) {
            PushyLogger.d("PushyJobService: Connecting...");
            try {
                if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, (Context)PushyJobService.this)) {
                    throw new PushyFatalException("Notifications have been disabled by the app");
                }
                mSocket;
                mKeepAliveInterval = PushyMqttConnection.getKeepAliveInterval((Context)PushyJobService.this);
                mSocket.connect();
                mLastKeepAlive = PushyDateTime.getCurrentTimestamp();
                mRetryInterval = 500L;
                PushyLogger.d("Connected successfully (sending keep alive every " + PushyMqttConnection.getKeepAliveInterval((Context)PushyJobService.this) + " seconds)");
                PushyJobService.this.scheduleJobAgain(false, PushyJobService.this.getJobServiceInterval());
            }
            catch (Exception e) {
                PushyLogger.d("Connect exception: " + e.toString(), e);
                if (e.getClass() == PushyFatalException.class) {
                    PushyLogger.d("Fatal error encountered, stopping service");
                    PushyJobService.this.endJob(false);
                    Integer n = 0;
                    return n;
                }
                if (e.getClass() == MqttSecurityException.class && ((MqttSecurityException)e).getReasonCode() == 5) {
                    PushyLogger.d("MQTT connect returned error code 5, clearing the device credentials");
                    PushyAuthentication.clearDeviceCredentials((Context)PushyJobService.this);
                    PushyJobService.this.endJob(false);
                    Integer n = 0;
                    return n;
                }
                PushyJobService.this.scheduleReconnect();
            }
            finally {
                mSocket.setConnecting(false);
            }
            return 0;
        }
    }

    public class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            if (!mSocket.isConnected()) {
                PushyJobService.this.connect();
                return 0;
            }
            PushyLogger.d("PushyJobService: Sending keep alive");
            try {
                mSocket.sendKeepAlive();
                PushyJobService.this.scheduleJobAgain(false, PushyJobService.this.getJobServiceInterval());
            }
            catch (Exception e) {
                PushyLogger.d("Keep alive error: " + e.toString(), e);
                mSocket.disconnectExistingClientSync();
                PushyJobService.this.connect();
            }
            return 0;
        }
    }

    public class EndJobAsync
    extends AsyncTask<Integer, String, Integer> {
        protected Integer doInBackground(Integer ... parameter) {
            PushyJobService.this.endJob(false);
            return 0;
        }
    }
}

