/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import me.pushy.sdk.config.PushyPermissions;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyPermissionException;

public class PushyPermissionVerification {
    public static void verifyManifestPermissions(Context context) throws PushyException {
        boolean permissionEnforcement = PushyPreferences.getBoolean("pushyPermissionVerification", true, context);
        if (!permissionEnforcement) {
            PushyLogger.d("Warning: AndroidManifest permission verification disabled by developer");
        }
        for (String permission : PushyPermissions.REQUIRED_MANIFEST_PERMISSIONS) {
            if (context.checkCallingOrSelfPermission(permission) == 0) continue;
            String message = "Error: " + permission + " is missing from your AndroidManifest.xml.";
            if (permissionEnforcement) {
                throw new PushyPermissionException(message);
            }
            PushyLogger.e(message);
        }
    }
}

