/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.provider.Settings;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import me.pushy.sdk.config.PushyMQTT;
import me.pushy.sdk.lib.paho.IMqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttCallback;
import me.pushy.sdk.lib.paho.MqttClient;
import me.pushy.sdk.lib.paho.MqttConnectOptions;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.persist.MemoryPersistence;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyBroadcastManager;
import me.pushy.sdk.util.PushyCertificateManager;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyEnterprise;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyNetworking;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.exceptions.PushyFatalException;
import org.apache.http.conn.ssl.StrictHostnameVerifier;

public class PushyMqttConnection
implements MqttCallback {
    int mNetwork;
    boolean mIsConnecting;
    Context mContext;
    MqttClient mClient;
    WifiManager mWifiManager;
    Runnable mConnectionLostRunnable;
    WifiManager.WifiLock mWifiWakeLock;
    ConnectivityManager mConnectivityManager;

    public PushyMqttConnection(Context context, WifiManager wifiManager, ConnectivityManager connectivityManager, Runnable connectionLostRunnable) {
        this.mContext = context;
        this.mWifiManager = wifiManager;
        this.mConnectivityManager = connectivityManager;
        this.mConnectionLostRunnable = connectionLostRunnable;
    }

    public static int getKeepAliveInterval(Context context) {
        return PushyPreferences.getInt("pushyKeepAliveInterval", PushyMQTT.MQTT_DEFAULT_KEEP_ALIVE, context);
    }

    public void releaseWifiLock() {
        if (this.mWifiWakeLock == null) {
            return;
        }
        try {
            this.mWifiWakeLock.release();
        }
        catch (Exception exc) {
            PushyLogger.d("Wi-Fi lock release failed");
        }
        this.mWifiWakeLock = null;
        PushyLogger.d("Wi-Fi lock released");
    }

    public void acquireWifiLock() {
        if (this.mWifiWakeLock != null) {
            return;
        }
        if (PushyPreferences.getBoolean("pushyWifiPolicyCompliance", false, this.mContext) && Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"wifi_sleep_policy", (int)2) != 2) {
            PushyLogger.d("Complying with device Wi-Fi sleep policy");
            return;
        }
        this.mWifiWakeLock = this.mWifiManager.createWifiLock(1, "Pushy");
        this.mWifiWakeLock.acquire();
        PushyLogger.d("Wi-Fi lock acquired");
    }

    public void connect() throws Exception {
        this.disconnectExistingClientSync();
        String brokerEndpoint = PushyEndpoints.getMQTTEndpoint(this.mContext);
        PushyDeviceCredentials credentials = PushyAuthentication.getDeviceCredentials(this.mContext);
        if (credentials == null) {
            throw new PushyFatalException("The device is not registered.");
        }
        PushyLogger.d("Broker: " + brokerEndpoint);
        PushyLogger.d("Device Token: " + credentials.token);
        PushyLogger.d("Device Auth Key: " + credentials.authKey.substring(0, 45) + "... [truncated]");
        this.mClient = new MqttClient(brokerEndpoint, credentials.token, new MemoryPersistence());
        this.mClient.setCallback(this);
        this.mClient.setTimeToWait(PushyMQTT.MQTT_ACK_TIMEOUT);
        this.mNetwork = PushyNetworking.getConnectedNetwork(this.mConnectivityManager);
        MqttConnectOptions connectOptions = new MqttConnectOptions();
        connectOptions.setUserName(credentials.token);
        connectOptions.setPassword(credentials.authKey.toCharArray());
        connectOptions.setAutomaticReconnect(false);
        if (PushyEnterprise.isConfigured(this.mContext) && PushyCertificateManager.isConfigured(this.mContext)) {
            connectOptions.setSocketFactory(PushyCertificateManager.getEnterpriseSslSocketFactory(this.mContext));
        }
        connectOptions.setSSLHostnameVerifier((HostnameVerifier)new StrictHostnameVerifier());
        connectOptions.setCleanSession(false);
        connectOptions.setConnectionTimeout(PushyMQTT.MQTT_CONNECT_TIMEOUT);
        connectOptions.setKeepAliveInterval(PushyMqttConnection.getKeepAliveInterval(this.mContext));
        this.mClient.connect(connectOptions);
        this.subscribeToTopic(this.mClient.getClientId());
    }

    private void subscribeToTopic(String topic) throws Exception {
        this.mClient.subscribe(topic, PushyMQTT.MQTT_QUALITY_OF_SERVICE);
    }

    private void publish(String topic, String payload) throws Exception {
        if (this.mClient == null || !this.mClient.isConnected()) {
            throw new Exception("Publish failed: not connected");
        }
        this.mClient.publish(topic, payload.getBytes(), PushyMQTT.MQTT_QUALITY_OF_SERVICE, PushyMQTT.MQTT_RETAINED_PUBLISH);
    }

    public void sendKeepAlive() throws Exception {
        this.publish("keepalive", this.mClient.getClientId());
    }

    public void disconnectExistingClientAsync() {
        if (this.mClient == null || !this.mClient.isConnected()) {
            return;
        }
        AsyncTask.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PushyMqttConnection.this.disconnectExistingClientSync();
            }
        });
    }

    public void disconnectExistingClientSync() {
        if (this.mClient == null || !this.mClient.isConnected()) {
            return;
        }
        try {
            this.mClient.disconnectForcibly(2000L, 2000L);
            this.mClient.close();
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.mClient != null && this.mClient.isConnected();
    }

    @Override
    public void connectionLost(Throwable cause) {
        PushyLogger.d("Connection lost");
        if (this.mConnectionLostRunnable != null) {
            this.mConnectionLostRunnable.run();
        }
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) throws Exception {
        try {
            String json = new String(message.getPayload());
            Map payload = PushySingleton.getJackson().readValue(json, Map.class);
            PushyLogger.d("Received push for package " + this.mContext.getPackageName() + "\n" + payload);
            PushyBroadcastManager.publishNotification(this.mContext, payload, json);
        }
        catch (Exception exc) {
            PushyLogger.e("Publishing notification failed: " + exc.getMessage(), exc);
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {
    }

    public int getNetwork() {
        return this.mNetwork;
    }

    public boolean isConnecting() {
        return this.mIsConnecting;
    }

    public void setConnecting(boolean value) {
        this.mIsConnecting = value;
    }
}

