/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho;

import me.pushy.sdk.lib.paho.IMqttClient;
import me.pushy.sdk.lib.paho.IMqttDeliveryToken;
import me.pushy.sdk.lib.paho.IMqttMessageListener;
import me.pushy.sdk.lib.paho.IMqttToken;
import me.pushy.sdk.lib.paho.MqttAsyncClient;
import me.pushy.sdk.lib.paho.MqttCallback;
import me.pushy.sdk.lib.paho.MqttClientPersistence;
import me.pushy.sdk.lib.paho.MqttConnectOptions;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.MqttPersistenceException;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.lib.paho.MqttTopic;
import me.pushy.sdk.lib.paho.persist.MemoryPersistence;
import me.pushy.sdk.lib.paho.util.Debug;

public class MqttClient
implements IMqttClient {
    protected MqttAsyncClient aClient = null;
    protected long timeToWait = -1L;

    public MqttClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MemoryPersistence());
    }

    public MqttClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this.aClient = new MqttAsyncClient(serverURI, clientId, persistence);
    }

    @Override
    public void connect() throws MqttSecurityException, MqttException {
        this.connect(new MqttConnectOptions());
    }

    @Override
    public void connect(MqttConnectOptions options) throws MqttSecurityException, MqttException {
        this.aClient.connect(options, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public IMqttToken connectWithResult(MqttConnectOptions options) throws MqttSecurityException, MqttException {
        IMqttToken tok = this.aClient.connect(options, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        return tok;
    }

    @Override
    public void disconnect() throws MqttException {
        this.aClient.disconnect().waitForCompletion();
    }

    @Override
    public void disconnect(long quiesceTimeout) throws MqttException {
        this.aClient.disconnect(quiesceTimeout, null, null).waitForCompletion();
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.aClient.disconnectForcibly();
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.aClient.disconnectForcibly(disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.aClient.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    @Override
    public void subscribe(String topicFilter) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{1});
    }

    @Override
    public void subscribe(String[] topicFilters) throws MqttException {
        int[] qos = new int[topicFilters.length];
        for (int i = 0; i < qos.length; ++i) {
            qos[i] = 1;
        }
        this.subscribe(topicFilters, qos);
    }

    @Override
    public void subscribe(String topicFilter, int qos) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{qos});
    }

    @Override
    public void subscribe(String[] topicFilters, int[] qos) throws MqttException {
        IMqttToken tok = this.aClient.subscribe(topicFilters, qos, null, null);
        tok.waitForCompletion(this.getTimeToWait());
        int[] grantedQos = tok.getGrantedQos();
        for (int i = 0; i < grantedQos.length; ++i) {
            qos[i] = grantedQos[i];
        }
        if (grantedQos.length == 1 && qos[0] == 128) {
            throw new MqttException(128);
        }
    }

    @Override
    public void subscribe(String topicFilter, IMqttMessageListener messageListener) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{1}, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public void subscribe(String[] topicFilters, IMqttMessageListener[] messageListeners) throws MqttException {
        int[] qos = new int[topicFilters.length];
        for (int i = 0; i < qos.length; ++i) {
            qos[i] = 1;
        }
        this.subscribe(topicFilters, qos, messageListeners);
    }

    @Override
    public void subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        this.subscribe(new String[]{topicFilter}, new int[]{qos}, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public void subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        this.subscribe(topicFilters, qos);
        for (int i = 0; i < topicFilters.length; ++i) {
            this.aClient.comms.setMessageListener(topicFilters[i], messageListeners[i]);
        }
    }

    @Override
    public void unsubscribe(String topicFilter) throws MqttException {
        this.unsubscribe(new String[]{topicFilter});
    }

    @Override
    public void unsubscribe(String[] topicFilters) throws MqttException {
        this.aClient.unsubscribe(topicFilters, null, null).waitForCompletion(this.getTimeToWait());
    }

    @Override
    public void publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        this.publish(topic, message);
    }

    @Override
    public void publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        this.aClient.publish(topic, message, null, null).waitForCompletion(this.getTimeToWait());
    }

    public void setTimeToWait(long timeToWaitInMillis) throws IllegalArgumentException {
        if (timeToWaitInMillis < -1L) {
            throw new IllegalArgumentException();
        }
        this.timeToWait = timeToWaitInMillis;
    }

    public long getTimeToWait() {
        return this.timeToWait;
    }

    @Override
    public void close() throws MqttException {
        this.aClient.close();
    }

    @Override
    public String getClientId() {
        return this.aClient.getClientId();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.aClient.getPendingDeliveryTokens();
    }

    @Override
    public String getServerURI() {
        return this.aClient.getServerURI();
    }

    public String getCurrentServerURI() {
        return this.aClient.getCurrentServerURI();
    }

    @Override
    public MqttTopic getTopic(String topic) {
        return this.aClient.getTopic(topic);
    }

    @Override
    public boolean isConnected() {
        return this.aClient != null && this.aClient.isConnected();
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.aClient.setCallback(callback);
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        this.aClient.setManualAcks(manualAcks);
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.aClient.messageArrivedComplete(messageId, qos);
    }

    public static String generateClientId() {
        return MqttAsyncClient.generateClientId();
    }

    public void reconnect() throws MqttException {
        this.aClient.reconnect();
    }

    public Debug getDebug() {
        return this.aClient.getDebug();
    }
}

