/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.services;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.os.Build;
import me.pushy.sdk.config.PushyMQTT;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.receivers.PushyUpdateReceiver;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyMqttConnection;
import me.pushy.sdk.util.PushyNetworking;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.exceptions.PushyDateTime;
import me.pushy.sdk.util.exceptions.PushyFatalException;

@TargetApi(value=21)
public class PushyJobService
extends JobService {
    private static WifiManager mWifiManager;
    private static ConnectivityManager mConnectivityManager;
    private static JobParameters mParams;
    private static PushyMqttConnection mSocket;
    private static long mLastKeepAlive;
    private static long mKeepAliveInterval;
    private static long mRetryInterval;
    private static long mJobServiceInterval;

    public boolean onStartJob(JobParameters params) {
        mParams = params;
        return PushyJobService.main((Context)this);
    }

    public static boolean main(Context context) {
        if (mWifiManager == null) {
            mWifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        }
        if (mConnectivityManager == null) {
            mConnectivityManager = (ConnectivityManager)context.getApplicationContext().getSystemService("connectivity");
        }
        if (mSocket == null) {
            mSocket = new PushyMqttConnection(context.getApplicationContext(), mWifiManager, mConnectivityManager, new ConnectionLostRunnable(context.getApplicationContext()));
        }
        if (mParams != null && mParams.getExtras().getString("command") != null && mParams.getExtras().getString("command").equals("stop")) {
            PushyLogger.d("Stop requested");
            mSocket.disconnectExistingClientAsync();
            PushyJobService.endJob(context, true);
            return true;
        }
        if (!mSocket.isConnected() && !mSocket.isConnecting()) {
            PushyJobService.connect(context);
        } else if (mSocket.isConnected() && PushyNetworking.getConnectedNetwork(mConnectivityManager) == 1 && mSocket.getNetwork() == 0) {
            new ReconnectAsync(context).execute(new Integer[0]);
        } else if (mSocket.isConnected() && mLastKeepAlive + mKeepAliveInterval < PushyDateTime.getCurrentTimestamp() + (long)PushyMQTT.MQTT_JOB_TASK_INTERVAL_PADDING) {
            PushyJobService.sendKeepAlive(context);
        } else {
            PushyJobService.scheduleJobAgain(context, true, mJobServiceInterval);
            return true;
        }
        return true;
    }

    static void endJob(Context context, boolean async) {
        if (async) {
            new EndJobAsync(context).execute(new Integer[0]);
        } else if (context instanceof PushyJobService) {
            ((PushyJobService)context).jobFinished(mParams, false);
        }
    }

    private static void connect(Context context) {
        if (!PushyNetworking.isNetworkAvailable(mConnectivityManager)) {
            PushyJobService.scheduleReconnect(context);
            return;
        }
        if (mSocket.isConnecting() || mSocket.isConnected()) {
            PushyJobService.scheduleJobAgain(context, true, mJobServiceInterval);
            return;
        }
        new ConnectAsync(context).execute(new Integer[0]);
    }

    public static boolean isConnected() {
        return mSocket != null && mSocket.isConnected();
    }

    private static void sendKeepAlive(Context context) {
        mLastKeepAlive = PushyDateTime.getCurrentTimestamp();
        if (mSocket.isConnected()) {
            new SendKeepAliveAsync(context).execute(new Integer[0]);
        }
    }

    public static void scheduleReconnect(Context context) {
        if (mRetryInterval < 60000L) {
            mRetryInterval = Math.min(mRetryInterval * 2L, 60000L);
        }
        PushyLogger.d("Reconnecting in " + mRetryInterval + "ms, or during next Doze maintenance window");
        PushyJobService.scheduleJobAgain(context, true, mRetryInterval);
    }

    static void scheduleJobAgain(Context context, boolean async, long interval) {
        if (async) {
            new ScheduleJobAgainAsync(context).execute(new Long[]{interval});
        } else {
            ComponentName serviceName = new ComponentName(context.getPackageName(), PushyJobService.class.getName());
            JobInfo jobInfo = new JobInfo.Builder(PushyMQTT.MQTT_JOB_ID, serviceName).setRequiredNetworkType(1).setMinimumLatency(interval).setOverrideDeadline(interval).setPersisted(true).build();
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            try {
                jobScheduler.schedule(jobInfo);
                PushyJobService.scheduleAlarmAgain(context, interval);
                PushyJobService.endJob(context, true);
            }
            catch (Exception exc) {
                PushyLogger.e("JobScheduler error: " + exc.getMessage(), exc);
                new ScheduleJobAgainAsync(context).execute(new Long[]{interval});
            }
        }
    }

    static void scheduleAlarmAgain(Context context, long interval) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        long when = System.currentTimeMillis() + interval + 1000L;
        Intent alarmIntent = new Intent(context, PushyUpdateReceiver.class);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)alarmIntent, (int)0x14000000);
        try {
            alarmManager.setExactAndAllowWhileIdle(0, when, pendingIntent);
        }
        catch (Exception exc) {
            PushyLogger.e("Failed to schedule AlarmManager recurring alarm (requires the \"android.permission.SCHEDULE_EXACT_ALARM\" permission to be defined in your AndroidManifest.xml)");
        }
    }

    public boolean onStopJob(JobParameters params) {
        return false;
    }

    static {
        mRetryInterval = 500L;
        mJobServiceInterval = PushyMQTT.MQTT_DEFAULT_JOB_SERVICE_INTERVAL * 1000;
    }

    public static class ScheduleJobAgainAsync
    extends AsyncTask<Long, String, Integer> {
        private Context mContext;

        public ScheduleJobAgainAsync(Context context) {
            this.mContext = context;
        }

        protected Integer doInBackground(Long ... parameter) {
            PushyJobService.scheduleJobAgain(this.mContext, false, parameter[0]);
            return 0;
        }
    }

    public static class ConnectionLostRunnable
    implements Runnable {
        private Context mContext;

        public ConnectionLostRunnable(Context context) {
            this.mContext = context;
        }

        @Override
        public void run() {
            mSocket.releaseWifiLock();
            PushyJobService.scheduleReconnect(this.mContext);
        }
    }

    public static class ReconnectAsync
    extends AsyncTask<Integer, String, Integer> {
        private Context mContext;

        public ReconnectAsync(Context context) {
            this.mContext = context;
        }

        protected Integer doInBackground(Integer ... parameter) {
            PushyLogger.d("PushyJobService: Reconnecting due to connectivity switch to Wi-Fi from cellular");
            mSocket.disconnectExistingClientSync();
            PushyJobService.connect(this.mContext);
            return 0;
        }
    }

    public static class ConnectAsync
    extends AsyncTask<Integer, String, Integer> {
        private Context mContext;

        public ConnectAsync(Context context) {
            this.mContext = context;
            mSocket.setConnecting(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Integer doInBackground(Integer ... parameter) {
            if (mSocket.isConnected()) {
                PushyLogger.e("Trying to re-connect an already connected socket which would have caused an infinite loop");
                return 0;
            }
            try {
                if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, this.mContext)) {
                    throw new PushyFatalException("Notifications have been disabled by the app");
                }
                mSocket;
                mKeepAliveInterval = PushyMqttConnection.getKeepAliveInterval(this.mContext);
                mJobServiceInterval = PushyPreferences.getInt("pushyJobServiceInterval", PushyMQTT.MQTT_DEFAULT_JOB_SERVICE_INTERVAL, this.mContext) * 1000;
                PushyLogger.d("PushyJobService: Connecting...");
                mSocket.connect();
                mLastKeepAlive = PushyDateTime.getCurrentTimestamp();
                mRetryInterval = 500L;
                PushyLogger.d("Connected successfully (sending keep alive every " + PushyMqttConnection.getKeepAliveInterval(this.mContext) + " seconds)");
                PushyJobService.scheduleJobAgain(this.mContext, false, mJobServiceInterval);
                mSocket.acquireWifiLock();
            }
            catch (Exception e) {
                PushyLogger.d("Connect exception: " + e.toString(), e);
                if (e.getClass() == PushyFatalException.class) {
                    PushyLogger.d("Fatal error encountered, stopping service");
                    PushyJobService.endJob(this.mContext, false);
                    Integer n = 0;
                    return n;
                }
                if (e.getClass() == MqttSecurityException.class && ((MqttSecurityException)e).getReasonCode() == 5) {
                    PushyLogger.d("MQTT connect returned error code 5, clearing the device credentials");
                    PushyAuthentication.clearDeviceCredentials(this.mContext);
                    PushyJobService.endJob(this.mContext, false);
                    Integer n = 0;
                    return n;
                }
                PushyJobService.scheduleReconnect(this.mContext);
            }
            finally {
                mSocket.setConnecting(false);
            }
            return 0;
        }
    }

    public static class SendKeepAliveAsync
    extends AsyncTask<Integer, String, Integer> {
        private Context mContext;

        public SendKeepAliveAsync(Context context) {
            this.mContext = context;
        }

        protected Integer doInBackground(Integer ... parameter) {
            if (!mSocket.isConnected()) {
                PushyJobService.connect(this.mContext);
                return 0;
            }
            PushyLogger.d("PushyJobService: Sending keep alive");
            try {
                mSocket.sendKeepAlive();
                PushyJobService.scheduleJobAgain(this.mContext, false, mJobServiceInterval);
            }
            catch (Exception e) {
                PushyLogger.d("Keep alive error: " + e.toString(), e);
                mSocket.disconnectExistingClientSync();
                PushyJobService.connect(this.mContext);
            }
            return 0;
        }
    }

    public static class EndJobAsync
    extends AsyncTask<Integer, String, Integer> {
        private Context mContext;

        public EndJobAsync(Context context) {
            this.mContext = context;
        }

        protected Integer doInBackground(Integer ... parameter) {
            PushyJobService.endJob(this.mContext, false);
            return 0;
        }
    }
}

