/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import android.os.Build;
import me.pushy.sdk.config.PushyPermissions;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPreferences;

public class PushyPermissionVerification {
    public static void verifyManifestPermissions(Context context) {
        if (!PushyPreferences.getBoolean("pushyPermissionVerification", true, context)) {
            PushyLogger.d("Warning: AndroidManifest permission verification disabled by developer (call Pushy.togglePermissionVerification(true) to enable)");
            return;
        }
        for (String permission : PushyPermissions.REQUIRED_MANIFEST_PERMISSIONS) {
            if (context.checkCallingOrSelfPermission(permission) == 0 || permission.equals("android.permission.SCHEDULE_EXACT_ALARM") && (!permission.equals("android.permission.SCHEDULE_EXACT_ALARM") || context.getApplicationContext().getApplicationInfo().targetSdkVersion < 31 || Build.VERSION.SDK_INT < 31)) continue;
            PushyLogger.e("The Pushy Android SDK requires the \"" + permission + "\" permission to be defined in your AndroidManifest.xml.\nFor an updated list of required permissions, please visit https://bit.ly/3GfZoys. You may call Pushy.togglePermissionVerification(false) to disable this message.");
        }
    }
}

