/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.os.PersistableBundle;
import me.pushy.sdk.config.PushyMQTT;
import me.pushy.sdk.services.PushyJobService;
import me.pushy.sdk.services.PushySocketService;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.exceptions.PushyException;

public class PushyServiceManager {
    public static void start(final Context context) {
        if (PushyAuthentication.getDeviceCredentials(context) == null) {
            return;
        }
        if (!PushyPreferences.getBoolean("pushyNotificationsEnabled", true, context)) {
            PushyLogger.d("Notifications have been disabled by the app");
            return;
        }
        if (PushyServiceManager.usingJobService() && !PushySocketService.isForegroundServiceEnabled()) {
            PushyServiceManager.executeJobCommand("start", context);
        } else {
            PushyServiceManager.startSocketServiceWithAction(context, "Pushy.START");
        }
        if (!PushyPreferences.getBoolean("pushyAndroidIdPersisted", false, context) && PushyPersistence.getAndroidId(context) != null) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (PushyAuthentication.validateCredentials(PushyAuthentication.getDeviceCredentials(context), context)) {
                            PushyPreferences.saveBoolean("pushyAndroidIdPersisted", true, context);
                            PushyLogger.d("Android ID persisted successfully");
                        }
                    }
                    catch (PushyException e) {
                        PushyLogger.e("Failed to persist Android ID in background thread, will retry later", e);
                    }
                }
            });
        }
    }

    public static boolean usingJobService() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static void stop(Context context) {
        if (PushyServiceManager.usingJobService() && !PushySocketService.isForegroundServiceEnabled()) {
            PushyServiceManager.executeJobCommand("stop", context);
        } else {
            context.stopService(new Intent(context, PushySocketService.class));
        }
    }

    private static void startSocketServiceWithAction(Context context, String action) {
        Intent actionIntent = new Intent(context, PushySocketService.class);
        actionIntent.setAction(action);
        if (PushySocketService.isForegroundServiceEnabled() && Build.VERSION.SDK_INT >= 26) {
            context.startForegroundService(actionIntent);
        } else {
            context.startService(actionIntent);
        }
    }

    @TargetApi(value=21)
    private static void executeJobCommand(String command, Context context) {
        block4: {
            ComponentName serviceName = new ComponentName(context.getPackageName(), PushyJobService.class.getName());
            PersistableBundle extras = new PersistableBundle();
            extras.putString("command", command);
            JobInfo jobInfo = new JobInfo.Builder(PushyMQTT.MQTT_JOB_ID, serviceName).setExtras(extras).setRequiredNetworkType(1).setMinimumLatency(1L).setOverrideDeadline(1L).setPersisted(true).build();
            JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            try {
                jobScheduler.schedule(jobInfo);
            }
            catch (IllegalArgumentException exc) {
                String errorMessage = "Pushy SDK 1.0.35 and up requires 'PushyJobService' to be defined in the AndroidManifest.xml: https://bit.ly/2O3fHEX";
                PushyLogger.e(errorMessage);
                if (!(context instanceof Activity)) break block4;
                try {
                    new AlertDialog.Builder(context).setTitle((CharSequence)"Error").setMessage((CharSequence)errorMessage).create().show();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

