/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk;

import android.content.Context;
import me.pushy.sdk.model.PushyDeviceCredentials;
import me.pushy.sdk.model.api.PushyRegistrationRequest;
import me.pushy.sdk.model.api.PushyRegistrationResponse;
import me.pushy.sdk.services.PushyJobService;
import me.pushy.sdk.services.PushySocketService;
import me.pushy.sdk.util.PushyAuthentication;
import me.pushy.sdk.util.PushyEndpoints;
import me.pushy.sdk.util.PushyFirebase;
import me.pushy.sdk.util.PushyHTTP;
import me.pushy.sdk.util.PushyLogger;
import me.pushy.sdk.util.PushyNotifications;
import me.pushy.sdk.util.PushyPermissionVerification;
import me.pushy.sdk.util.PushyPersistence;
import me.pushy.sdk.util.PushyPreferences;
import me.pushy.sdk.util.PushyPubSub;
import me.pushy.sdk.util.PushyServiceManager;
import me.pushy.sdk.util.PushySingleton;
import me.pushy.sdk.util.PushyStringUtils;
import me.pushy.sdk.util.exceptions.PushyException;
import me.pushy.sdk.util.exceptions.PushyJsonParseException;
import me.pushy.sdk.util.exceptions.PushyRegistrationException;

public class Pushy {
    public static void listen(Context context) {
        PushyPermissionVerification.verifyManifestPermissions(context);
        PushyServiceManager.start(context);
    }

    public static void subscribe(String[] topics, Context context) throws PushyException {
        PushyPubSub.subscribe(topics, context);
    }

    public static void subscribe(String topic, Context context) throws PushyException {
        Pushy.subscribe(new String[]{topic}, context);
    }

    public static void unsubscribe(String[] topics, Context context) throws PushyException {
        PushyPubSub.unsubscribe(topics, context);
    }

    public static void unsubscribe(String topic, Context context) throws PushyException {
        Pushy.unsubscribe(new String[]{topic}, context);
    }

    public static void togglePermissionVerification(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyPermissionVerification", value, context);
    }

    public static void toggleFCM(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyFCMEnabled", value, context);
        if (value && Pushy.isRegistered(context) && PushyPreferences.getString("pushyFCMToken", null, context) == null) {
            PushyFirebase.register(context);
        }
    }

    public static void setEnterpriseCertificate(String value, Context context) {
        PushyPreferences.saveString("pushyEnterpriseCertificate", value, context);
    }

    public static void toggleDirectConnectivity(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyDirectConnectivity", value, context);
    }

    public static void setProxyEndpoint(String value, Context context) {
        PushyPreferences.saveString("pushyProxyEndpoint", value, context);
    }

    public static void toggleWifiPolicyCompliance(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyWifiPolicyCompliance", value, context);
    }

    public static void toggleNotifications(boolean value, Context context) {
        PushyPreferences.saveBoolean("pushyNotificationsEnabled", value, context);
        if (value) {
            PushyServiceManager.start(context);
        } else {
            PushyServiceManager.stop(context);
        }
    }

    public static void setHeartbeatInterval(int seconds, Context context) {
        if (seconds < 60) {
            seconds = 60;
            PushyLogger.e("The minimum heartbeat interval is 60 seconds.");
        }
        PushyPreferences.saveInt("pushyKeepAliveInterval", seconds, context);
    }

    public static void setJobServiceInterval(int seconds, Context context) {
        if (seconds < 5) {
            seconds = 5;
            PushyLogger.e("The minimum JobService interval is 5 seconds.");
        }
        PushyPreferences.saveInt("pushyJobServiceInterval", seconds, context);
    }

    public static void setEnterpriseConfig(String apiEndpoint, String mqttEndpoint, Context context) {
        if (apiEndpoint != null && apiEndpoint.endsWith("/")) {
            apiEndpoint = apiEndpoint.substring(0, apiEndpoint.length() - 1);
        }
        if (mqttEndpoint != null && mqttEndpoint.endsWith("/")) {
            mqttEndpoint = mqttEndpoint.substring(0, mqttEndpoint.length() - 1);
        }
        if (!PushyStringUtils.equals(PushyPreferences.getString("pushyEnterpriseMQTTEndpoint", null, context), mqttEndpoint)) {
            PushyLogger.d("New enterprise MQTT endpoint, stopping socket service");
            PushyServiceManager.stop(context);
        }
        PushyPreferences.saveString("pushyEnterpriseAPIEndpoint", apiEndpoint, context);
        PushyPreferences.saveString("pushyEnterpriseMQTTEndpoint", mqttEndpoint, context);
    }

    public static boolean isRegistered(Context context) {
        return PushyAuthentication.getDeviceCredentials(context) != null;
    }

    public static boolean isConnected() {
        return PushySocketService.isConnected() || PushyJobService.isConnected();
    }

    public static void unregister(Context context) {
        PushyAuthentication.clearDeviceCredentials(context);
        PushyServiceManager.stop(context);
    }

    public static void setAppId(String appId, Context context) {
        String previousId;
        if (appId != null && appId.equals("")) {
            appId = null;
        }
        if (((previousId = PushyPreferences.getString("pushyAppId", null, context)) == null || !previousId.equals(appId)) && Pushy.isRegistered(context)) {
            Pushy.unregister(context);
        }
        PushyPreferences.saveString("pushyAppId", appId, context);
    }

    public static String register(Context context) throws PushyException {
        PushyRegistrationResponse response;
        String json;
        Object register;
        PushyDeviceCredentials persistedCredentials = PushyAuthentication.getDeviceCredentials(context);
        if (persistedCredentials != null && PushyAuthentication.validateCredentials(persistedCredentials, context)) {
            if (PushyPreferences.getBoolean("pushyFCMEnabled", false, context)) {
                PushyFirebase.register(context);
            }
            Pushy.listen(context);
            return persistedCredentials.token;
        }
        String androidId = PushyPersistence.getAndroidId(context);
        try {
            register = new PushyRegistrationRequest();
            String appId = PushyPreferences.getString("pushyAppId", null, context);
            if (androidId != null) {
                ((PushyRegistrationRequest)register).androidId = androidId;
            }
            if (appId != null) {
                ((PushyRegistrationRequest)register).appId = appId;
            } else {
                ((PushyRegistrationRequest)register).app = context.getPackageName();
            }
            json = PushySingleton.getJackson().writeValueAsString(register);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        register = PushyHTTP.post(PushyEndpoints.getAPIEndpoint(context) + "/register", json, context);
        try {
            response = PushySingleton.getJackson().readValue((String)register, PushyRegistrationResponse.class);
        }
        catch (Exception exc) {
            throw new PushyJsonParseException(exc.getMessage());
        }
        if (!PushyStringUtils.stringIsNullOrEmpty(response.error)) {
            throw new PushyRegistrationException("Registration failed: " + response.error);
        }
        if (response.token == null || response.auth == null) {
            throw new PushyRegistrationException("Registration failed, please try again later.");
        }
        if (androidId != null) {
            PushyPreferences.saveBoolean("pushyAndroidIdPersisted", true, context);
        }
        PushyAuthentication.saveDeviceCredentials(new PushyDeviceCredentials(response.token, response.auth), context);
        PushyLogger.d("Pushy registration success: " + response.token);
        Pushy.listen(context);
        if (PushyPreferences.getBoolean("pushyFCMEnabled", false, context)) {
            PushyFirebase.register(context);
        }
        return response.token;
    }

    public static PushyDeviceCredentials getDeviceCredentials(Context context) {
        return PushyAuthentication.getDeviceCredentials(context);
    }

    public static void setDeviceCredentials(PushyDeviceCredentials credentials, Context context) throws PushyException {
        if (PushyStringUtils.stringIsNullOrEmpty(credentials.token) || PushyStringUtils.stringIsNullOrEmpty(credentials.authKey)) {
            throw new PushyException("Please provide both the device token and auth key.");
        }
        if (!PushyAuthentication.validateCredentials(credentials, context)) {
            throw new PushyException("Authentication failed, please double-check the provided credentials.");
        }
        PushyAuthentication.saveDeviceCredentials(credentials, context);
        Pushy.listen(context);
    }

    public static void setNotificationChannel(Object builder, Context context) {
        PushyNotifications.setNotificationChannel(builder, context);
    }
}

