/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.util;

import android.content.Context;
import me.pushy.sdk.util.PushyPreferences;

public class PushyEndpoints {
    public static String getAPIEndpoint(Context context) {
        String proxyEndpoint = PushyPreferences.getString("pushyProxyEndpoint", null, context);
        if (proxyEndpoint != null) {
            return "https://" + proxyEndpoint;
        }
        return PushyPreferences.getString("pushyEnterpriseAPIEndpoint", "https://api.pushy.me", context);
    }

    public static String getMQTTEndpoint(Context context) throws Exception {
        String enterpriseEndpoint = PushyPreferences.getString("pushyEnterpriseMQTTEndpoint", null, context);
        if (enterpriseEndpoint != null) {
            return enterpriseEndpoint;
        }
        String proxyEndpoint = PushyPreferences.getString("pushyProxyEndpoint", null, context);
        if (proxyEndpoint != null) {
            return "ssl://" + proxyEndpoint;
        }
        boolean directConnectivity = PushyPreferences.getBoolean("pushyDirectConnectivity", false, context);
        if (directConnectivity) {
            return "ssl://mqtt.pushy.io:443";
        }
        String brokerEndpoint = "ssl://mqtt-{ts}.pushy.io:443";
        if (brokerEndpoint.contains("{ts}")) {
            brokerEndpoint = brokerEndpoint.replace("{ts}", String.valueOf(System.currentTimeMillis() / 1000L));
        }
        return brokerEndpoint;
    }
}

