/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.model;

import android.util.Log;
import com.google.firebase.messaging.FirebaseMessagingService;
import com.google.firebase.messaging.RemoteMessage;
import java.lang.reflect.Method;

public class PushyCachedService {
    Method mOnNewTokenMethod;
    Method mOnMessageReceivedMethod;
    FirebaseMessagingService mService;

    public PushyCachedService(FirebaseMessagingService service, Method onNewTokenMethod, Method onMessageReceivedMethod) {
        this.mService = service;
        this.mOnNewTokenMethod = onNewTokenMethod;
        this.mOnMessageReceivedMethod = onMessageReceivedMethod;
    }

    public void onMessageReceived(RemoteMessage message) {
        if (this.mOnMessageReceivedMethod == null) {
            return;
        }
        Log.d((String)"Pushy", (String)("Invoking cached 3rd-party FCM service " + this.mService.getClass().getName() + ".onMessageReceived(RemoteMessage) via reflection"));
        try {
            this.mOnMessageReceivedMethod.invoke((Object)this.mService, message);
        }
        catch (Exception exc) {
            Log.e((String)"Pushy", (String)("Invoking cached 3rd-party FCM service " + this.mService.getClass().getName() + ".onMessageReceived(RemoteMessage) via reflection failed"), (Throwable)exc);
        }
    }

    public void onNewToken(String token) {
        if (this.mOnNewTokenMethod == null) {
            return;
        }
        Log.d((String)"Pushy", (String)("Invoking cached 3rd-party FCM service " + this.mService.getClass().getName() + ".onNewToken(String) via reflection"));
        try {
            this.mOnNewTokenMethod.invoke((Object)this.mService, token);
        }
        catch (Exception exc) {
            Log.e((String)"Pushy", (String)("Invoking cached 3rd-party FCM service " + this.mService.getClass().getName() + ".onNewToken(String) via reflection failed"), (Throwable)exc);
        }
    }
}

