/*
 * Decompiled with CFR 0.152.
 */
package me.pushy.sdk.lib.paho;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import me.pushy.sdk.lib.paho.DisconnectedBufferOptions;
import me.pushy.sdk.lib.paho.IMqttActionListener;
import me.pushy.sdk.lib.paho.IMqttAsyncClient;
import me.pushy.sdk.lib.paho.IMqttDeliveryToken;
import me.pushy.sdk.lib.paho.IMqttMessageListener;
import me.pushy.sdk.lib.paho.IMqttToken;
import me.pushy.sdk.lib.paho.MqttCallback;
import me.pushy.sdk.lib.paho.MqttCallbackExtended;
import me.pushy.sdk.lib.paho.MqttClientPersistence;
import me.pushy.sdk.lib.paho.MqttConnectOptions;
import me.pushy.sdk.lib.paho.MqttDeliveryToken;
import me.pushy.sdk.lib.paho.MqttException;
import me.pushy.sdk.lib.paho.MqttMessage;
import me.pushy.sdk.lib.paho.MqttPersistenceException;
import me.pushy.sdk.lib.paho.MqttPingSender;
import me.pushy.sdk.lib.paho.MqttSecurityException;
import me.pushy.sdk.lib.paho.MqttToken;
import me.pushy.sdk.lib.paho.MqttTopic;
import me.pushy.sdk.lib.paho.TimerPingSender;
import me.pushy.sdk.lib.paho.internal.ClientComms;
import me.pushy.sdk.lib.paho.internal.ConnectActionListener;
import me.pushy.sdk.lib.paho.internal.DisconnectedMessageBuffer;
import me.pushy.sdk.lib.paho.internal.ExceptionHelper;
import me.pushy.sdk.lib.paho.internal.LocalNetworkModule;
import me.pushy.sdk.lib.paho.internal.NetworkModule;
import me.pushy.sdk.lib.paho.internal.SSLNetworkModule;
import me.pushy.sdk.lib.paho.internal.TCPNetworkModule;
import me.pushy.sdk.lib.paho.internal.security.SSLSocketFactoryFactory;
import me.pushy.sdk.lib.paho.internal.websocket.WebSocketNetworkModule;
import me.pushy.sdk.lib.paho.internal.websocket.WebSocketSecureNetworkModule;
import me.pushy.sdk.lib.paho.internal.wire.MqttDisconnect;
import me.pushy.sdk.lib.paho.internal.wire.MqttPublish;
import me.pushy.sdk.lib.paho.internal.wire.MqttSubscribe;
import me.pushy.sdk.lib.paho.internal.wire.MqttUnsubscribe;
import me.pushy.sdk.lib.paho.logging.Logger;
import me.pushy.sdk.lib.paho.logging.LoggerFactory;
import me.pushy.sdk.lib.paho.persist.MemoryPersistence;
import me.pushy.sdk.lib.paho.persist.MqttDefaultFilePersistence;
import me.pushy.sdk.lib.paho.util.Debug;

public class MqttAsyncClient
implements IMqttAsyncClient {
    private static final String CLASS_NAME = MqttAsyncClient.class.getName();
    private static final Logger log = LoggerFactory.getLogger("me.pushy.sdk.lib.paho.internal.nls.logcat", CLASS_NAME);
    private static final String CLIENT_ID_PREFIX = "paho";
    private static final long QUIESCE_TIMEOUT = 30000L;
    private static final long DISCONNECT_TIMEOUT = 10000L;
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private String clientId;
    private String serverURI;
    protected ClientComms comms;
    private Hashtable topics;
    private MqttClientPersistence persistence;
    private MqttCallback mqttCallback;
    private MqttConnectOptions connOpts;
    private Object userContext;
    private Timer reconnectTimer;
    private static int reconnectDelay = 1000;
    private boolean reconnecting = false;

    public MqttAsyncClient(String serverURI, String clientId) throws MqttException {
        this(serverURI, clientId, new MqttDefaultFilePersistence());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence) throws MqttException {
        this(serverURI, clientId, persistence, new TimerPingSender());
    }

    public MqttAsyncClient(String serverURI, String clientId, MqttClientPersistence persistence, MqttPingSender pingSender) throws MqttException {
        String methodName = "MqttAsyncClient";
        log.setResourceName(clientId);
        if (clientId == null) {
            throw new IllegalArgumentException("Null clientId");
        }
        int clientIdLength = 0;
        for (int i = 0; i < clientId.length() - 1; ++i) {
            if (MqttAsyncClient.Character_isHighSurrogate(clientId.charAt(i))) {
                ++i;
            }
            ++clientIdLength;
        }
        if (clientIdLength > 65535) {
            throw new IllegalArgumentException("ClientId longer than 65535 characters");
        }
        MqttConnectOptions.validateURI(serverURI);
        this.serverURI = serverURI;
        this.clientId = clientId;
        this.persistence = persistence;
        if (this.persistence == null) {
            this.persistence = new MemoryPersistence();
        }
        log.fine(CLASS_NAME, "MqttAsyncClient", "101", new Object[]{clientId, serverURI, persistence});
        this.persistence.open(clientId, serverURI);
        this.comms = new ClientComms(this, this.persistence, pingSender);
        this.persistence.close();
        this.topics = new Hashtable();
    }

    protected static boolean Character_isHighSurrogate(char ch) {
        return ch >= '\ud800' && ch <= '\udbff';
    }

    protected NetworkModule[] createNetworkModules(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        String methodName = "createNetworkModules";
        log.fine(CLASS_NAME, "createNetworkModules", "116", new Object[]{address});
        NetworkModule[] networkModules = null;
        String[] serverURIs = options.getServerURIs();
        String[] array = null;
        array = serverURIs == null ? new String[]{address} : (serverURIs.length == 0 ? new String[]{address} : serverURIs);
        networkModules = new NetworkModule[array.length];
        for (int i = 0; i < array.length; ++i) {
            networkModules[i] = this.createNetworkModule(array[i], options);
        }
        log.fine(CLASS_NAME, "createNetworkModules", "108");
        return networkModules;
    }

    private NetworkModule createNetworkModule(String address, MqttConnectOptions options) throws MqttException, MqttSecurityException {
        NetworkModule netModule;
        String methodName = "createNetworkModule";
        log.fine(CLASS_NAME, "createNetworkModule", "115", new Object[]{address});
        SocketFactory factory = options.getSocketFactory();
        int serverURIType = MqttConnectOptions.validateURI(address);
        switch (serverURIType) {
            case 0: {
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 1883);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new TCPNetworkModule(factory, host, port, this.clientId);
                ((TCPNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 1: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 8883);
                SSLSocketFactoryFactory factoryFactory = null;
                if (factory == null) {
                    factoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        factoryFactory.initialize(sslClientProps, null);
                    }
                    factory = factoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new SSLNetworkModule((SSLSocketFactory)factory, host, port, this.clientId);
                ((SSLNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                ((SSLNetworkModule)netModule).setSSLHostnameVerifier(options.getSSLHostnameVerifier());
                if (factoryFactory == null || (enabledCiphers = factoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 3: {
                String shortAddress = address.substring(5);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 80);
                if (factory == null) {
                    factory = SocketFactory.getDefault();
                } else if (factory instanceof SSLSocketFactory) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketNetworkModule(factory, address, host, port, this.clientId);
                ((WebSocketNetworkModule)netModule).setConnectTimeout(options.getConnectionTimeout());
                break;
            }
            case 4: {
                String[] enabledCiphers;
                String shortAddress = address.substring(6);
                String host = this.getHostName(shortAddress);
                int port = this.getPort(shortAddress, 443);
                SSLSocketFactoryFactory wSSFactoryFactory = null;
                if (factory == null) {
                    wSSFactoryFactory = new SSLSocketFactoryFactory();
                    Properties sslClientProps = options.getSSLProperties();
                    if (null != sslClientProps) {
                        wSSFactoryFactory.initialize(sslClientProps, null);
                    }
                    factory = wSSFactoryFactory.createSocketFactory(null);
                } else if (!(factory instanceof SSLSocketFactory)) {
                    throw ExceptionHelper.createMqttException(32105);
                }
                netModule = new WebSocketSecureNetworkModule((SSLSocketFactory)factory, address, host, port, this.clientId);
                ((WebSocketSecureNetworkModule)netModule).setSSLhandshakeTimeout(options.getConnectionTimeout());
                if (wSSFactoryFactory == null || (enabledCiphers = wSSFactoryFactory.getEnabledCipherSuites(null)) == null) break;
                ((SSLNetworkModule)netModule).setEnabledCiphers(enabledCiphers);
                break;
            }
            case 2: {
                netModule = new LocalNetworkModule(address.substring(8));
                break;
            }
            default: {
                netModule = null;
            }
        }
        return netModule;
    }

    private int getPort(String uri, int defaultPort) {
        int port;
        int portIndex = uri.lastIndexOf(58);
        if (portIndex == -1) {
            port = defaultPort;
        } else {
            int slashIndex = uri.indexOf(47);
            if (slashIndex == -1) {
                slashIndex = uri.length();
            }
            port = Integer.parseInt(uri.substring(portIndex + 1, slashIndex));
        }
        return port;
    }

    private String getHostName(String uri) {
        int portIndex = uri.indexOf(58);
        if (portIndex == -1) {
            portIndex = uri.indexOf(47);
        }
        if (portIndex == -1) {
            portIndex = uri.length();
        }
        return uri.substring(0, portIndex);
    }

    @Override
    public IMqttToken connect(Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        return this.connect(new MqttConnectOptions(), userContext, callback);
    }

    @Override
    public IMqttToken connect() throws MqttException, MqttSecurityException {
        return this.connect(null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options) throws MqttException, MqttSecurityException {
        return this.connect(options, null, null);
    }

    @Override
    public IMqttToken connect(MqttConnectOptions options, Object userContext, IMqttActionListener callback) throws MqttException, MqttSecurityException {
        String methodName = "connect";
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.connOpts = options;
        this.userContext = userContext;
        final boolean automaticReconnect = options.isAutomaticReconnect();
        log.fine(CLASS_NAME, "connect", "103", new Object[]{options.isCleanSession(), new Integer(options.getConnectionTimeout()), new Integer(options.getKeepAliveInterval()), options.getUserName(), null == options.getPassword() ? "[null]" : "[notnull]", null == options.getWillMessage() ? "[null]" : "[notnull]", userContext, callback});
        this.comms.setNetworkModules(this.createNetworkModules(this.serverURI, options));
        this.comms.setReconnectCallback(new MqttCallbackExtended(){

            @Override
            public void messageArrived(String topic, MqttMessage message) throws Exception {
            }

            @Override
            public void deliveryComplete(IMqttDeliveryToken token) {
            }

            @Override
            public void connectComplete(boolean reconnect, String serverURI) {
            }

            @Override
            public void connectionLost(Throwable cause) {
                if (automaticReconnect) {
                    MqttAsyncClient.this.comms.setRestingState(true);
                    MqttAsyncClient.this.reconnecting = true;
                    MqttAsyncClient.this.startReconnectCycle();
                }
            }
        });
        MqttToken userToken = new MqttToken(this.getClientId());
        ConnectActionListener connectActionListener = new ConnectActionListener(this, this.persistence, this.comms, options, userToken, userContext, callback, this.reconnecting);
        userToken.setActionCallback(connectActionListener);
        userToken.setUserContext(this);
        if (this.mqttCallback instanceof MqttCallbackExtended) {
            connectActionListener.setMqttCallbackExtended((MqttCallbackExtended)this.mqttCallback);
        }
        this.comms.setNetworkModuleIndex(0);
        connectActionListener.connect();
        return userToken;
    }

    @Override
    public IMqttToken disconnect(Object userContext, IMqttActionListener callback) throws MqttException {
        return this.disconnect(30000L, userContext, callback);
    }

    @Override
    public IMqttToken disconnect() throws MqttException {
        return this.disconnect(null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout) throws MqttException {
        return this.disconnect(quiesceTimeout, null, null);
    }

    @Override
    public IMqttToken disconnect(long quiesceTimeout, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "disconnect";
        log.fine(CLASS_NAME, "disconnect", "104", new Object[]{new Long(quiesceTimeout), userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        MqttDisconnect disconnect = new MqttDisconnect();
        try {
            this.comms.disconnect(disconnect, quiesceTimeout, token);
        }
        catch (MqttException ex) {
            log.fine(CLASS_NAME, "disconnect", "105", null, ex);
            throw ex;
        }
        log.fine(CLASS_NAME, "disconnect", "108");
        return token;
    }

    @Override
    public void disconnectForcibly() throws MqttException {
        this.disconnectForcibly(30000L, 10000L);
    }

    @Override
    public void disconnectForcibly(long disconnectTimeout) throws MqttException {
        this.disconnectForcibly(30000L, disconnectTimeout);
    }

    @Override
    public void disconnectForcibly(long quiesceTimeout, long disconnectTimeout) throws MqttException {
        this.comms.disconnectForcibly(quiesceTimeout, disconnectTimeout);
    }

    @Override
    public boolean isConnected() {
        return this.comms.isConnected();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getServerURI() {
        return this.serverURI;
    }

    public String getCurrentServerURI() {
        return this.comms.getNetworkModules()[this.comms.getNetworkModuleIndex()].getServerURI();
    }

    protected MqttTopic getTopic(String topic) {
        MqttTopic.validate(topic, false);
        MqttTopic result = (MqttTopic)this.topics.get(topic);
        if (result == null) {
            result = new MqttTopic(topic, this.comms);
            this.topics.put(topic, result);
        }
        return result;
    }

    public IMqttToken checkPing(Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "ping";
        log.fine(CLASS_NAME, "ping", "117");
        MqttToken token = this.comms.checkForActivity();
        log.fine(CLASS_NAME, "ping", "118");
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback);
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback) throws MqttException {
        String methodName = "subscribe";
        if (topicFilters.length != qos.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < topicFilters.length; ++i) {
            this.comms.removeMessageListener(topicFilters[i]);
        }
        String subs = "";
        for (int i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + "topic=" + topicFilters[i] + " qos=" + qos[i];
            MqttTopic.validate(topicFilters[i], true);
        }
        log.fine(CLASS_NAME, "subscribe", "106", new Object[]{subs, userContext, callback});
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttSubscribe register = new MqttSubscribe(topicFilters, qos);
        this.comms.sendNoWait(register, token);
        log.fine(CLASS_NAME, "subscribe", "109");
        return token;
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, Object userContext, IMqttActionListener callback, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, userContext, callback, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String topicFilter, int qos, IMqttMessageListener messageListener) throws MqttException {
        return this.subscribe(new String[]{topicFilter}, new int[]{qos}, null, null, new IMqttMessageListener[]{messageListener});
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, IMqttMessageListener[] messageListeners) throws MqttException {
        return this.subscribe(topicFilters, qos, null, null, messageListeners);
    }

    @Override
    public IMqttToken subscribe(String[] topicFilters, int[] qos, Object userContext, IMqttActionListener callback, IMqttMessageListener[] messageListeners) throws MqttException {
        if (messageListeners.length != qos.length || qos.length != topicFilters.length) {
            throw new IllegalArgumentException();
        }
        IMqttToken token = this.subscribe(topicFilters, qos, userContext, callback);
        for (int i = 0; i < topicFilters.length; ++i) {
            this.comms.setMessageListener(topicFilters[i], messageListeners[i]);
        }
        return token;
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter, Object userContext, IMqttActionListener callback) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, userContext, callback);
    }

    @Override
    public IMqttToken unsubscribe(String topicFilter) throws MqttException {
        return this.unsubscribe(new String[]{topicFilter}, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters) throws MqttException {
        return this.unsubscribe(topicFilters, null, null);
    }

    @Override
    public IMqttToken unsubscribe(String[] topicFilters, Object userContext, IMqttActionListener callback) throws MqttException {
        int i;
        String methodName = "unsubscribe";
        String subs = "";
        for (i = 0; i < topicFilters.length; ++i) {
            if (i > 0) {
                subs = subs + ", ";
            }
            subs = subs + topicFilters[i];
            MqttTopic.validate(topicFilters[i], true);
        }
        log.fine(CLASS_NAME, "unsubscribe", "107", new Object[]{subs, userContext, callback});
        for (i = 0; i < topicFilters.length; ++i) {
            this.comms.removeMessageListener(topicFilters[i]);
        }
        MqttToken token = new MqttToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.internalTok.setTopics(topicFilters);
        MqttUnsubscribe unregister = new MqttUnsubscribe(topicFilters);
        this.comms.sendNoWait(unregister, token);
        log.fine(CLASS_NAME, "unsubscribe", "110");
        return token;
    }

    @Override
    public void setCallback(MqttCallback callback) {
        this.mqttCallback = callback;
        this.comms.setCallback(callback);
    }

    @Override
    public void setManualAcks(boolean manualAcks) {
        this.comms.setManualAcks(manualAcks);
    }

    @Override
    public void messageArrivedComplete(int messageId, int qos) throws MqttException {
        this.comms.messageArrivedComplete(messageId, qos);
    }

    public static String generateClientId() {
        return CLIENT_ID_PREFIX + System.nanoTime();
    }

    @Override
    public IMqttDeliveryToken[] getPendingDeliveryTokens() {
        return this.comms.getPendingDeliveryTokens();
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        MqttMessage message = new MqttMessage(payload);
        message.setQos(qos);
        message.setRetained(retained);
        return this.publish(topic, message, userContext, callback);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, byte[] payload, int qos, boolean retained) throws MqttException, MqttPersistenceException {
        return this.publish(topic, payload, qos, retained, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message) throws MqttException, MqttPersistenceException {
        return this.publish(topic, message, null, null);
    }

    @Override
    public IMqttDeliveryToken publish(String topic, MqttMessage message, Object userContext, IMqttActionListener callback) throws MqttException, MqttPersistenceException {
        String methodName = "publish";
        log.fine(CLASS_NAME, "publish", "111", new Object[]{topic, userContext, callback});
        MqttTopic.validate(topic, false);
        MqttDeliveryToken token = new MqttDeliveryToken(this.getClientId());
        token.setActionCallback(callback);
        token.setUserContext(userContext);
        token.setMessage(message);
        token.internalTok.setTopics(new String[]{topic});
        MqttPublish pubMsg = new MqttPublish(topic, message);
        this.comms.sendNoWait(pubMsg, token);
        log.fine(CLASS_NAME, "publish", "112");
        return token;
    }

    public void reconnect() throws MqttException {
        String methodName = "reconnect";
        log.fine(CLASS_NAME, "reconnect", "500", new Object[]{this.clientId});
        if (this.comms.isConnected()) {
            throw ExceptionHelper.createMqttException(32100);
        }
        if (this.comms.isConnecting()) {
            throw new MqttException(32110);
        }
        if (this.comms.isDisconnecting()) {
            throw new MqttException(32102);
        }
        if (this.comms.isClosed()) {
            throw new MqttException(32111);
        }
        this.stopReconnectCycle();
        this.attemptReconnect();
    }

    private void attemptReconnect() {
        String methodName = "attemptReconnect";
        log.fine(CLASS_NAME, "attemptReconnect", "500", new Object[]{this.clientId});
        try {
            this.connect(this.connOpts, this.userContext, new IMqttActionListener(){

                @Override
                public void onSuccess(IMqttToken asyncActionToken) {
                    log.fine(CLASS_NAME, "attemptReconnect", "501", new Object[]{asyncActionToken.getClient().getClientId()});
                    MqttAsyncClient.this.comms.setRestingState(false);
                    MqttAsyncClient.this.stopReconnectCycle();
                }

                @Override
                public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                    log.fine(CLASS_NAME, "attemptReconnect", "502", new Object[]{asyncActionToken.getClient().getClientId()});
                    if (reconnectDelay < 128000) {
                        reconnectDelay = reconnectDelay * 2;
                    }
                    MqttAsyncClient.this.rescheduleReconnectCycle(reconnectDelay);
                }
            });
        }
        catch (MqttSecurityException ex) {
            log.fine(CLASS_NAME, "attemptReconnect", "804", null, ex);
        }
        catch (MqttException ex) {
            log.fine(CLASS_NAME, "attemptReconnect", "804", null, ex);
        }
    }

    private void startReconnectCycle() {
        String methodName = "startReconnectCycle";
        log.fine(CLASS_NAME, methodName, "503", new Object[]{this.clientId, new Long(reconnectDelay)});
        this.reconnectTimer = new Timer("MQTT Reconnect: " + this.clientId);
        this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), reconnectDelay);
    }

    private void stopReconnectCycle() {
        String methodName = "stopReconnectCycle";
        log.fine(CLASS_NAME, methodName, "504", new Object[]{this.clientId});
        this.reconnectTimer.cancel();
        reconnectDelay = 1000;
    }

    private void rescheduleReconnectCycle(int delay) {
        String methodName = "rescheduleReconnectCycle";
        log.fine(CLASS_NAME, methodName, "505", new Object[]{this.clientId, new Long(reconnectDelay)});
        this.reconnectTimer.schedule((TimerTask)new ReconnectTask(), reconnectDelay);
    }

    public void setBufferOpts(DisconnectedBufferOptions bufferOpts) {
        this.comms.setDisconnectedMessageBuffer(new DisconnectedMessageBuffer(bufferOpts));
    }

    public int getBufferedMessageCount() {
        return this.comms.getBufferedMessageCount();
    }

    public MqttMessage getBufferedMessage(int bufferIndex) {
        return this.comms.getBufferedMessage(bufferIndex);
    }

    public void deleteBufferedMessage(int bufferIndex) {
        this.comms.deleteBufferedMessage(bufferIndex);
    }

    @Override
    public void close() throws MqttException {
        String methodName = "close";
        log.fine(CLASS_NAME, "close", "113");
        this.comms.close();
        log.fine(CLASS_NAME, "close", "114");
    }

    public Debug getDebug() {
        return new Debug(this.clientId, this.comms);
    }

    private class ReconnectTask
    extends TimerTask {
        private static final String methodName = "ReconnectTask.run";

        private ReconnectTask() {
        }

        @Override
        public void run() {
            log.fine(CLASS_NAME, methodName, "506");
            MqttAsyncClient.this.attemptReconnect();
        }
    }
}

