/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import me.qoomon.UncheckedExceptions;
import me.qoomon.gitversioning.GitConstants;
import me.qoomon.gitversioning.GitRepoSituation;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public final class GitUtil {
    public static Status status(Repository repository) {
        return (Status)UncheckedExceptions.unchecked(() -> Git.wrap((Repository)repository).status().call());
    }

    public static String branch(Repository repository) {
        ObjectId head = (ObjectId)UncheckedExceptions.unchecked(() -> repository.resolve("HEAD"));
        if (head == null) {
            return "master";
        }
        String branch = (String)UncheckedExceptions.unchecked(() -> ((Repository)repository).getBranch());
        if (ObjectId.isId((String)branch)) {
            return null;
        }
        return branch;
    }

    public static List<String> tag_pointsAt(Repository repository, String revstr) {
        ObjectId rev = (ObjectId)UncheckedExceptions.unchecked(() -> repository.resolve(revstr));
        return ((List)UncheckedExceptions.unchecked(() -> repository.getRefDatabase().getRefsByPrefix("refs/tags/"))).stream().map(ref -> (Ref)UncheckedExceptions.unchecked(() -> repository.getRefDatabase().peel(ref))).filter(ref -> (ref.isPeeled() && ref.getPeeledObjectId() != null ? ref.getPeeledObjectId() : ref.getObjectId()).equals((AnyObjectId)rev)).map(ref -> ref.getName().replaceFirst("^refs/tags/", "")).collect(Collectors.toList());
    }

    public static String revParse(Repository repository, String revstr) {
        ObjectId rev = (ObjectId)UncheckedExceptions.unchecked(() -> repository.resolve(revstr));
        if (rev == null) {
            return GitConstants.NO_COMMIT;
        }
        return rev.getName();
    }

    public static long revTimestamp(Repository repository, String revstr) {
        ObjectId rev = (ObjectId)UncheckedExceptions.unchecked(() -> repository.resolve(revstr));
        if (rev == null) {
            return 0L;
        }
        return ((Integer)UncheckedExceptions.unchecked(() -> repository.parseCommit((AnyObjectId)rev).getCommitTime())).intValue();
    }

    public static GitRepoSituation situation(File directory) {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(directory);
        if (repositoryBuilder.getGitDir() == null) {
            throw new IllegalArgumentException(directory + " directory is not a git repository (or any of the parent directories)");
        }
        try (Repository repository = (Repository)UncheckedExceptions.unchecked(() -> ((FileRepositoryBuilder)repositoryBuilder).build());){
            boolean headClean = GitUtil.status(repository).isClean();
            String headCommit = GitUtil.revParse(repository, "HEAD");
            long headCommitTimestamp = GitUtil.revTimestamp(repository, "HEAD");
            String headBranch = GitUtil.branch(repository);
            List<String> headTags = GitUtil.tag_pointsAt(repository, "HEAD");
            GitRepoSituation gitRepoSituation = new GitRepoSituation(headClean, headCommit, headCommitTimestamp, headTags, headBranch);
            return gitRepoSituation;
        }
    }
}

