/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;

public class GAV {
    private String groupId;
    private String artifactId;
    private String version;

    GAV(String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProjectId() {
        return this.getGroupId() + ":" + this.getArtifactId();
    }

    public static GAV of(Model model) {
        String groupId = model.getGroupId();
        String artifactId = model.getArtifactId();
        String version = model.getVersion();
        Parent parent = model.getParent();
        if (parent != null) {
            if (groupId == null) {
                groupId = parent.getGroupId();
            }
            if (version == null) {
                version = parent.getVersion();
            }
        }
        return new GAV(groupId, artifactId, version);
    }

    public static GAV of(Parent parent) {
        String groupId = parent.getGroupId();
        String artifactId = parent.getArtifactId();
        String version = parent.getVersion();
        return new GAV(groupId, artifactId, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GAV gav = (GAV)o;
        if (!this.groupId.equals(gav.groupId)) {
            return false;
        }
        if (!this.artifactId.equals(gav.artifactId)) {
            return false;
        }
        return this.version.equals(gav.version);
    }

    public int hashCode() {
        int result = this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s:%s:%s", this.groupId, this.artifactId, this.version);
    }
}

