/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.XMLParser;
import de.pdark.decentxml.XMLSource;
import de.pdark.decentxml.XMLStringSource;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import me.qoomon.maven.gitversioning.BuildProperties;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="git-versioning", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class VersioningMojo
extends AbstractMojo {
    static final String GOAL = "git-versioning";
    static final String GIT_VERSIONING_POM_NAME = ".git-versioned-pom.xml";
    static final String propertyKeyPrefix = VersioningMojo.class.getName() + ".";
    static final String propertyKeyUpdatePom = "updatePom";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public synchronized void execute() throws MojoExecutionException {
        try {
            Element parentElement;
            Element propertiesElement;
            boolean configUpdatePom = Boolean.parseBoolean(this.project.getProperties().getProperty(propertyKeyPrefix + propertyKeyUpdatePom));
            this.getLog().debug((CharSequence)(this.project.getModel().getArtifactId() + "remove this plugin and plugin properties from model"));
            Model originalModel = this.project.getOriginalModel();
            originalModel.getBuild().removePlugin(VersioningMojo.asPlugin());
            originalModel.getProperties().entrySet().removeIf(property -> ((String)property.getKey()).startsWith(propertyKeyPrefix));
            this.getLog().info((CharSequence)"Generating git versioned POM");
            File pomFile = this.project.getFile();
            Document gitVersionedPomDocument = VersioningMojo.readXml(pomFile);
            Element projectElement = gitVersionedPomDocument.getChild("project");
            Element versionElement = projectElement.getChild("version");
            if (versionElement != null) {
                versionElement.setText(this.project.getVersion());
            }
            if ((propertiesElement = projectElement.getChild("properties")) != null) {
                for (Element propertyElement : propertiesElement.getChildren()) {
                    propertyElement.setText(this.project.getOriginalModel().getProperties().getProperty(propertyElement.getName()));
                }
            }
            if ((parentElement = projectElement.getChild("parent")) != null) {
                Element parentVersionElement = parentElement.getChild("version");
                parentVersionElement.setText(this.project.getParent().getVersion());
            }
            File gitVersionedPomFile = new File(this.project.getBuild().getDirectory(), GIT_VERSIONING_POM_NAME);
            Files.createDirectories(gitVersionedPomFile.getParentFile().toPath(), new FileAttribute[0]);
            VersioningMojo.writeXml(gitVersionedPomFile, gitVersionedPomDocument);
            this.project.setPomFile(gitVersionedPomFile);
            if (configUpdatePom) {
                this.getLog().info((CharSequence)"Updating original POM");
                Files.copy(gitVersionedPomFile.toPath(), pomFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Git Versioning Pom Replacement Mojo", e);
        }
    }

    private static File writeXml(File file, Document gitVersionedPom) throws IOException {
        Files.write(file.toPath(), gitVersionedPom.toXML().getBytes(), new OpenOption[0]);
        return file;
    }

    private static Document readXml(File file) throws IOException {
        String pomXml = new String(Files.readAllBytes(file.toPath()));
        XMLParser parser = new XMLParser();
        return parser.parse((XMLSource)new XMLStringSource(pomXml));
    }

    static Plugin asPlugin() {
        Plugin plugin = new Plugin();
        plugin.setGroupId(BuildProperties.projectGroupId());
        plugin.setArtifactId(BuildProperties.projectArtifactId());
        plugin.setVersion(BuildProperties.projectVersion());
        return plugin;
    }
}

