/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.building;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import me.qoomon.maven.gitversioning.GitVersioningModelProcessor;
import org.apache.maven.model.Model;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.locator.DefaultModelLocator;
import org.eclipse.sisu.Typed;

@Named
@Singleton
@Typed(value={ModelProcessor.class})
public class DefaultModelProcessor
implements ModelProcessor {
    @Inject
    private DefaultModelLocator locator;
    @Inject
    private DefaultModelReader reader;
    @Inject
    private GitVersioningModelProcessor modelProcessor;

    public File locatePom(File projectDirectory) {
        return this.locator.locatePom(projectDirectory);
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        Model projectModel = this.reader.read(input, options);
        return this.modelProcessor.processModel(projectModel, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model projectModel = this.reader.read(input, options);
        return this.modelProcessor.processModel(projectModel, options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model projectModel = this.reader.read(input, options);
        return this.modelProcessor.processModel(projectModel, options);
    }
}

