/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.common.collect.Maps;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import me.qoomon.UncheckedExceptions;
import me.qoomon.gitversioning.GitRepoSituation;
import me.qoomon.gitversioning.GitUtil;
import me.qoomon.gitversioning.GitVersionDetails;
import me.qoomon.gitversioning.GitVersioning;
import me.qoomon.gitversioning.PropertyDescription;
import me.qoomon.gitversioning.PropertyValueDescription;
import me.qoomon.gitversioning.VersionDescription;
import me.qoomon.maven.gitversioning.BuildProperties;
import me.qoomon.maven.gitversioning.Configuration;
import me.qoomon.maven.gitversioning.GAV;
import me.qoomon.maven.gitversioning.MavenUtil;
import me.qoomon.maven.gitversioning.VersioningMojo;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

@Named(value="core-default")
@Singleton
@Typed(value={ModelProcessor.class})
public class GitVersioningModelProcessor
extends DefaultModelProcessor {
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_UPDATE_POM = "versioning.updatePom";
    private static final String OPTION_PREFER_TAGS = "versioning.preferTags";
    @Inject
    private Logger logger;
    @Inject
    private SessionScope sessionScope;
    private boolean initialized = false;
    private boolean disabled = false;
    private MavenSession mavenSession;
    private File mvnDirectory;
    private File gitDirectory;
    private Configuration config;
    private GitVersionDetails gitVersionDetails;
    private final Set<String> sessionProjectDirectories = new HashSet<String>();
    private final Map<String, Model> virtualProjectModelCache = new HashMap<String, Model>();

    public Model read(File input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model processModel(Model projectModel, Map<String, ?> options) throws IOException {
        if (this.disabled) {
            return projectModel;
        }
        Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
        if (pomSource != null) {
            projectModel.setPomFile(new File(pomSource.getLocation()));
        }
        try {
            if (!this.initialized) {
                this.logger.info("");
                String extensionId = BuildProperties.projectArtifactId() + ":" + BuildProperties.projectVersion();
                this.logger.info(this.extensionLogFormat(extensionId));
                try {
                    this.mavenSession = (MavenSession)this.sessionScope.scope(Key.get(MavenSession.class), null).get();
                }
                catch (OutOfScopeException ex) {
                    this.logger.warn("skip - no maven session present");
                    this.disabled = true;
                    return projectModel;
                }
                if (Boolean.parseBoolean(this.getCommandOption(OPTION_NAME_DISABLE))) {
                    this.logger.info("skip - versioning is disabled");
                    this.disabled = true;
                    return projectModel;
                }
                File executionRootDirectory = new File(this.mavenSession.getRequest().getBaseDirectory());
                this.logger.debug("executionRootDirectory: " + executionRootDirectory.toString());
                this.mvnDirectory = GitVersioningModelProcessor.findMvnDirectory(executionRootDirectory);
                this.logger.debug("mvnDirectory: " + this.mvnDirectory.toString());
                String configFileName = BuildProperties.projectArtifactId() + ".xml";
                File configFile = new File(this.mvnDirectory, configFileName);
                this.logger.debug("configFile: " + configFile.toString());
                this.config = this.loadConfig(configFile);
                this.gitDirectory = GitVersioningModelProcessor.findGitDir(executionRootDirectory);
                if (this.gitDirectory == null || !this.gitDirectory.exists()) {
                    this.logger.warn("skip - project is not part of a git repository");
                    this.disabled = true;
                    return projectModel;
                }
                this.logger.debug("gitDirectory: " + this.gitDirectory.toString());
                this.gitVersionDetails = this.getGitVersionDetails(this.config, executionRootDirectory);
                this.logger.info("Adjusting project models...");
                this.logger.info("");
                this.initialized = true;
            }
            return this.processModel(projectModel);
        }
        catch (Exception e) {
            throw new IOException("Git Versioning Model Processor", e);
        }
    }

    private Model processModel(Model projectModel) throws IOException {
        String projectId;
        Model virtualProjectModel;
        if (!this.isRelatedPom(projectModel.getPomFile())) {
            this.logger.debug("skip - unrelated pom location - " + projectModel.getPomFile());
            return projectModel;
        }
        if (projectModel.getPomFile().getName().equals(".git-versioned-pom.xml")) {
            this.logger.debug("skip - git versioned pom - " + projectModel.getPomFile());
            return projectModel;
        }
        GAV projectGav = GAV.of(projectModel);
        if (projectGav.getVersion() == null) {
            this.logger.debug("skip - invalid model - 'version' is missing - " + projectModel.getPomFile());
            return projectModel;
        }
        if (this.sessionProjectDirectories.isEmpty()) {
            this.sessionProjectDirectories.add(projectModel.getProjectDirectory().getCanonicalPath());
        }
        if ((virtualProjectModel = this.virtualProjectModelCache.get(projectId = projectGav.getProjectId())) == null) {
            Map gitProperties;
            this.logger.info(MessageUtils.buffer().strong((Object)"--- ") + MessageUtils.buffer().project((Object)projectId).toString() + " @ " + this.gitVersionDetails.getCommitRefType() + " " + MessageUtils.buffer().strong((Object)this.gitVersionDetails.getCommitRefName()) + MessageUtils.buffer().strong((Object)" ---"));
            virtualProjectModel = projectModel.clone();
            Parent parent = projectModel.getParent();
            if (parent != null) {
                if (parent.getVersion() == null) {
                    this.logger.warn("skip - invalid model - parent 'version' is missing - " + projectModel.getPomFile());
                    return projectModel;
                }
                Model parentModel = this.getParentModel(projectModel);
                if (parentModel != null && this.isRelatedPom(parentModel.getPomFile())) {
                    if (virtualProjectModel.getVersion() != null) {
                        virtualProjectModel.setVersion(null);
                        this.logger.warn("Do not set version tag in a multi module project module: " + projectModel.getPomFile());
                        if (!projectModel.getVersion().equals(parent.getVersion())) {
                            throw new IllegalStateException("'version' has to be equal to parent 'version'");
                        }
                    }
                    String parentVersion = virtualProjectModel.getParent().getVersion();
                    String string = this.gitVersionDetails.getVersionTransformer().apply(parentVersion);
                    this.logger.info("parent version: " + string);
                    virtualProjectModel.getParent().setVersion(string);
                }
            }
            if (virtualProjectModel.getVersion() != null) {
                String projectVersion = virtualProjectModel.getVersion();
                String gitProjectVersion = this.gitVersionDetails.getVersionTransformer().apply(projectVersion);
                this.logger.info("project version: " + MessageUtils.buffer().strong((Object)gitProjectVersion));
                virtualProjectModel.setVersion(gitProjectVersion);
            }
            if (!(gitProperties = this.gitVersionDetails.getPropertiesTransformer().apply((Map)Maps.fromProperties((Properties)virtualProjectModel.getProperties()), projectGav.getVersion())).isEmpty()) {
                this.logger.info("properties:");
                for (Map.Entry entry : gitProperties.entrySet()) {
                    if (((String)entry.getValue()).equals(virtualProjectModel.getProperties().getProperty((String)entry.getKey()))) continue;
                    this.logger.info("  " + (String)entry.getKey() + ": " + (String)entry.getValue());
                    virtualProjectModel.getProperties().setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            this.logger.info("");
            virtualProjectModel.addProperty("git.commit", this.gitVersionDetails.getCommit());
            virtualProjectModel.addProperty("git.commit.timestamp", Long.toString(this.gitVersionDetails.getCommitTimestamp()));
            virtualProjectModel.addProperty("git.commit.timestamp.datetime", GitVersioningModelProcessor.toTimestampDateTime(this.gitVersionDetails.getCommitTimestamp()));
            virtualProjectModel.addProperty("git.ref", this.gitVersionDetails.getCommitRefName());
            virtualProjectModel.addProperty("git.ref.slug", this.gitVersionDetails.getCommitRefName().toLowerCase().replaceAll("/", "-"));
            virtualProjectModel.addProperty("git." + this.gitVersionDetails.getCommitRefType(), this.gitVersionDetails.getCommitRefName());
            virtualProjectModel.addProperty("git.dirty", Boolean.toString(!this.gitVersionDetails.isClean()));
            boolean isProjectPom = this.sessionProjectDirectories.contains(virtualProjectModel.getProjectDirectory().getCanonicalPath());
            if (isProjectPom) {
                boolean bl = this.getUpdatePomOption(this.config, this.gitVersionDetails);
                this.addBuildPlugin(virtualProjectModel, bl);
                for (String module : projectModel.getModules()) {
                    this.sessionProjectDirectories.add(new File(projectModel.getProjectDirectory(), module).getCanonicalPath());
                }
                for (Profile profile : projectModel.getProfiles()) {
                    for (String module : profile.getModules()) {
                        this.sessionProjectDirectories.add(new File(projectModel.getProjectDirectory(), module).getCanonicalPath());
                    }
                }
            }
            this.virtualProjectModelCache.put(projectId, virtualProjectModel);
        }
        return virtualProjectModel;
    }

    private GitVersionDetails getGitVersionDetails(Configuration config, File repositoryDirectory) {
        String providedBranch;
        GitRepoSituation repoSituation = GitUtil.situation((File)repositoryDirectory);
        String providedTag = this.getCommandOption(OPTION_NAME_GIT_TAG);
        if (providedTag != null) {
            repoSituation.setHeadBranch(null);
            repoSituation.setHeadTags(providedTag.isEmpty() ? Collections.emptyList() : Collections.singletonList(providedTag));
        }
        if ((providedBranch = this.getCommandOption(OPTION_NAME_GIT_BRANCH)) != null) {
            repoSituation.setHeadBranch(providedBranch.isEmpty() ? null : providedBranch);
        }
        boolean preferTagsOption = this.getPreferTagsOption(config);
        return GitVersioning.determineVersion((GitRepoSituation)repoSituation, (VersionDescription)Optional.ofNullable(config.commit).map(it -> new VersionDescription(null, it.versionFormat, this.convertPropertyDescription(it.property))).orElse(new VersionDescription()), config.branch.stream().map(it -> new VersionDescription(it.pattern, it.versionFormat, this.convertPropertyDescription(it.property))).collect(Collectors.toList()), config.tag.stream().map(it -> new VersionDescription(it.pattern, it.versionFormat, this.convertPropertyDescription(it.property))).collect(Collectors.toList()), (boolean)preferTagsOption);
    }

    private List<PropertyDescription> convertPropertyDescription(List<Configuration.PropertyDescription> confPropertyDescription) {
        return confPropertyDescription.stream().map(prop -> new PropertyDescription(prop.pattern, new PropertyValueDescription(prop.valuePattern, prop.valueFormat))).collect(Collectors.toList());
    }

    private Model getParentModel(Model projectModel) {
        GAV parentGav;
        if (projectModel.getParent() == null) {
            return null;
        }
        File parentPomPath = new File(projectModel.getProjectDirectory(), projectModel.getParent().getRelativePath());
        File parentPom = parentPomPath.isDirectory() ? new File(parentPomPath, "pom.xml") : parentPomPath;
        if (!parentPom.exists()) {
            return null;
        }
        Model parentModel = (Model)UncheckedExceptions.unchecked(() -> MavenUtil.readModel(parentPom));
        GAV parentModelGav = GAV.of(parentModel);
        if (!parentModelGav.equals(parentGav = GAV.of(projectModel.getParent()))) {
            return null;
        }
        return parentModel;
    }

    private static File findMvnDirectory(File baseDirectory) throws IOException {
        for (File searchDirectory = baseDirectory; searchDirectory != null; searchDirectory = searchDirectory.getParentFile()) {
            File mvnDir = new File(searchDirectory, ".mvn");
            if (!mvnDir.exists()) continue;
            return mvnDir;
        }
        throw new FileNotFoundException("Can not find .mvn directory in hierarchy of " + baseDirectory);
    }

    private void addBuildPlugin(Model model, boolean updatePomOption) {
        this.logger.debug(model.getArtifactId() + " temporary add build plugin");
        Plugin plugin = VersioningMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("git-versioning");
        execution.getGoals().add("git-versioning");
        plugin.getExecutions().add(execution);
        if (model.getBuild() == null) {
            model.setBuild(new Build());
        }
        model.getBuild().getPlugins().add(plugin);
        model.getProperties().setProperty(VersioningMojo.propertyKeyPrefix + "updatePom", Boolean.toString(updatePomOption));
    }

    private boolean isRelatedPom(File pomFile) throws IOException {
        return pomFile != null && pomFile.exists() && pomFile.isFile() && pomFile.getName().endsWith(".xml") && pomFile.getCanonicalPath().startsWith(this.mvnDirectory.getParentFile().getCanonicalPath() + File.separator) && pomFile.getCanonicalPath().startsWith(this.gitDirectory.getParentFile().getCanonicalPath() + File.separator);
    }

    private static File findGitDir(File baseDirectory) {
        return ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(baseDirectory)).getGitDir();
    }

    private String getCommandOption(String name) {
        String value = this.mavenSession.getUserProperties().getProperty(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    private Configuration loadConfig(File configFile) throws IOException {
        this.logger.debug("load config from " + configFile);
        return (Configuration)UncheckedExceptions.unchecked(() -> (Configuration)new XmlMapper().readValue(configFile, Configuration.class));
    }

    private boolean getPreferTagsOption(Configuration config) {
        String preferTagsCommandOption = this.getCommandOption(OPTION_PREFER_TAGS);
        boolean preferTagsOption = preferTagsCommandOption != null ? Boolean.parseBoolean(preferTagsCommandOption) : (config.preferTags != null ? config.preferTags : false);
        return preferTagsOption;
    }

    private boolean getUpdatePomOption(Configuration config, GitVersionDetails gitVersionDetails) {
        boolean updatePomOption;
        String updatePomCommandOption = this.getCommandOption(OPTION_UPDATE_POM);
        if (updatePomCommandOption != null) {
            return Boolean.parseBoolean(updatePomCommandOption);
        }
        boolean bl = updatePomOption = config.updatePom != null && config.updatePom != false;
        if (gitVersionDetails.getCommitRefType().equals("tag")) {
            updatePomOption = config.tag.stream().filter(it -> Pattern.matches(it.pattern, gitVersionDetails.getCommitRefName())).findFirst().map(it -> it.updatePom).orElse(updatePomOption);
        } else if (gitVersionDetails.getCommitRefType().equals("branch")) {
            updatePomOption = config.branch.stream().filter(it -> Pattern.matches(it.pattern, gitVersionDetails.getCommitRefName())).findFirst().map(it -> it.updatePom).orElse(updatePomOption);
        } else if (config.commit != null) {
            updatePomOption = Optional.ofNullable(config.commit.updatePom).orElse(updatePomOption);
        }
        return updatePomOption;
    }

    private String extensionLogFormat(String extensionId) {
        int extensionIdPadding = 70 - extensionId.length();
        int extensionIdPaddingLeft = (int)Math.ceil((double)extensionIdPadding / 2.0);
        int extensionIdPaddingRight = (int)Math.floor((double)extensionIdPadding / 2.0);
        return MessageUtils.buffer().strong((Object)StringUtils.repeat((String)"-", (int)extensionIdPaddingLeft)) + " " + MessageUtils.buffer().mojo((Object)extensionId) + " " + MessageUtils.buffer().strong((Object)StringUtils.repeat((String)"-", (int)extensionIdPaddingRight));
    }

    private static String toTimestampDateTime(long timestamp) {
        if (timestamp == 0L) {
            return "0000-00-00T00:00:00Z";
        }
        return DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneOffset.UTC).format(Instant.ofEpochSecond(timestamp));
    }
}

