/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GitSituation {
    public static String NO_COMMIT = "0000000000000000000000000000000000000000";
    private final File rootDirectory;
    private final String headCommit;
    private final long headCommitTimestamp;
    private final String headBranch;
    private final List<String> headTags;
    private final boolean clean;

    public GitSituation(File rootDirectory, String headCommit, long headCommitTimestamp, String headBranch, List<String> headTags, boolean clean) {
        this.rootDirectory = Objects.requireNonNull(rootDirectory);
        this.headCommit = Objects.requireNonNull(headCommit);
        this.headCommitTimestamp = headCommitTimestamp;
        this.headBranch = headBranch;
        this.headTags = Objects.requireNonNull(headTags);
        this.clean = clean;
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public String getHeadCommit() {
        return this.headCommit;
    }

    public long getHeadCommitTimestamp() {
        return this.headCommitTimestamp;
    }

    public ZonedDateTime getHeadCommitDateTime() {
        Instant headCommitTimestamp = Instant.ofEpochSecond(this.getHeadCommitTimestamp());
        return ZonedDateTime.ofInstant(headCommitTimestamp, ZoneOffset.UTC);
    }

    public String getHeadBranch() {
        return this.headBranch;
    }

    public List<String> getHeadTags() {
        return this.headTags;
    }

    public boolean isClean() {
        return this.clean;
    }

    public boolean isDetached() {
        return this.headBranch == null;
    }

    public static class Builder {
        private File rootDirectory;
        private String headCommit = NO_COMMIT;
        private long headCommitTimestamp = 0L;
        private String headBranch = null;
        private List<String> headTags = Collections.emptyList();
        private boolean clean = true;

        public Builder setRootDirectory(File rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        public Builder setHeadCommit(String headCommit) {
            this.headCommit = headCommit;
            return this;
        }

        public Builder setHeadCommitTimestamp(long headCommitTimestamp) {
            this.headCommitTimestamp = headCommitTimestamp;
            return this;
        }

        public Builder setHeadBranch(String headBranch) {
            this.headBranch = headBranch;
            return this;
        }

        public Builder setHeadTags(List<String> headTags) {
            this.headTags = headTags;
            return this;
        }

        public Builder setClean(boolean clean) {
            this.clean = clean;
            return this;
        }

        public GitSituation build() {
            return new GitSituation(this.rootDirectory, this.headCommit, this.headCommitTimestamp, this.headBranch, this.headTags, this.clean);
        }

        public static Builder of(GitSituation gitSituation) {
            return new Builder().setRootDirectory(gitSituation.rootDirectory).setClean(gitSituation.clean).setHeadCommit(gitSituation.headCommit).setHeadCommitTimestamp(gitSituation.headCommitTimestamp).setHeadBranch(gitSituation.headBranch).setHeadTags(gitSituation.headTags);
        }
    }
}

