/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import me.qoomon.gitversioning.commons.GitRefType;
import me.qoomon.gitversioning.commons.GitSituation;
import me.qoomon.gitversioning.commons.GitUtil;
import me.qoomon.gitversioning.commons.StringUtil;
import me.qoomon.maven.gitversioning.BuildProperties;
import me.qoomon.maven.gitversioning.Configuration;
import me.qoomon.maven.gitversioning.GAV;
import me.qoomon.maven.gitversioning.GitVersionDetails;
import me.qoomon.maven.gitversioning.GitVersioningMojo;
import me.qoomon.maven.gitversioning.MavenUtil;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="core-default")
@Singleton
@Typed(value={ModelProcessor.class})
public class GitVersioningModelProcessor
extends DefaultModelProcessor {
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_UPDATE_POM = "versioning.updatePom";
    private static final String OPTION_PREFER_TAGS = "versioning.preferTags";
    private static final String DEFAULT_BRANCH_VERSION_FORMAT = "${branch}-SNAPSHOT";
    private static final String DEFAULT_TAG_VERSION_FORMAT = "${tag}";
    private static final String DEFAULT_COMMIT_VERSION_FORMAT = "${commit}";
    static final String GIT_VERSIONING_POM_NAME = ".git-versioned-pom.xml";
    private final Logger logger = LoggerFactory.getLogger(GitVersioningModelProcessor.class);
    @Inject
    private SessionScope sessionScope;
    private boolean initialized = false;
    private MavenSession mavenSession;
    private File mvnDirectory;
    private GitSituation gitSituation;
    private boolean disabled = false;
    private boolean updatePomOption = false;
    private GitVersionDetails gitVersionDetails;
    private Map<String, Configuration.PropertyDescription> gitVersioningPropertyDescriptionMap;
    private Map<String, String> globalFormatPlaceholderMap;
    private Map<String, String> gitProjectProperties;
    private Set<GAV> relatedProjects;
    private final Set<File> projectModules = new HashSet<File>();
    private final Map<File, Model> sessionModelCache = new HashMap<File, Model>();

    public Model read(File input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    private void init(Model projectModel) throws IOException {
        this.logger.info("");
        this.logger.info(GitVersioningModelProcessor.extensionLogHeader(BuildProperties.projectGAV()));
        try {
            this.mavenSession = (MavenSession)this.sessionScope.scope(Key.get(MavenSession.class), null).get();
        }
        catch (OutOfScopeException ex) {
            this.logger.warn("skip - no maven session present");
            this.disabled = true;
            return;
        }
        File executionRootDirectory = new File(this.mavenSession.getRequest().getBaseDirectory());
        this.logger.debug("execution root directory: " + executionRootDirectory);
        this.mvnDirectory = GitVersioningModelProcessor.findMvnDirectory(executionRootDirectory);
        this.logger.debug(".mvn directory: " + this.mvnDirectory);
        File configFile = new File(this.mvnDirectory, BuildProperties.projectArtifactId() + ".xml");
        this.logger.debug("read config from " + configFile);
        Configuration config = GitVersioningModelProcessor.readConfig(configFile);
        String commandOptionDisable = this.getCommandOption(OPTION_NAME_DISABLE);
        if (commandOptionDisable != null) {
            this.disabled = Boolean.parseBoolean(commandOptionDisable);
            if (this.disabled) {
                this.logger.info("skip - versioning is disabled by command option");
                return;
            }
        } else {
            boolean bl = this.disabled = config.disable != null && config.disable != false;
            if (this.disabled) {
                this.logger.info("skip - versioning is disabled by config option");
                return;
            }
        }
        this.gitSituation = this.getGitSituation(executionRootDirectory);
        if (this.gitSituation == null) {
            this.logger.warn("skip - project is not part of a git repository");
            this.disabled = true;
            return;
        }
        this.logger.debug(MessageUtils.buffer().strong((Object)"git situation:").toString());
        this.logger.debug("  root directory: " + this.gitSituation.getRootDirectory());
        this.logger.debug("  head commit: " + this.gitSituation.getHeadCommit());
        this.logger.debug("  head commit timestamp: " + this.gitSituation.getHeadCommitTimestamp());
        this.logger.debug("  head branch: " + this.gitSituation.getHeadBranch());
        this.logger.debug("  head tags: " + this.gitSituation.getHeadTags());
        boolean preferTagsOption = this.getPreferTagsOption(config);
        this.logger.debug(MessageUtils.buffer().strong((Object)"option:").toString() + " prefer tags: " + preferTagsOption);
        this.gitVersionDetails = GitVersioningModelProcessor.getGitVersionDetails(this.gitSituation, config, preferTagsOption);
        this.logger.info("git ref: " + MessageUtils.buffer().strong((Object)this.gitVersionDetails.getRefName()) + " (" + this.gitVersionDetails.getRefType().name().toLowerCase() + ")");
        this.gitVersioningPropertyDescriptionMap = this.gitVersionDetails.getConfig().property.stream().collect(Collectors.toMap(property -> property.name, property -> property));
        this.updatePomOption = this.getUpdatePomOption(config, this.gitVersionDetails.getConfig());
        this.logger.debug(MessageUtils.buffer().strong((Object)"option:").toString() + " update pom: " + this.updatePomOption);
        this.relatedProjects = this.determineRelatedProjects(projectModel);
        this.logger.debug(MessageUtils.buffer().strong((Object)"related projects:").toString());
        this.relatedProjects.forEach(gav -> this.logger.debug("  " + gav));
        this.projectModules.add(projectModel.getPomFile());
        this.globalFormatPlaceholderMap = GitVersioningModelProcessor.generateGlobalFormatPlaceholderMap(this.gitSituation, this.gitVersionDetails, this.mavenSession);
        this.gitProjectProperties = GitVersioningModelProcessor.generateGitProjectProperties(this.gitSituation, this.gitVersionDetails);
        this.logger.info("");
    }

    public Model processModel(Model projectModel, Map<String, ?> options) throws IOException {
        Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
        if (pomSource == null) {
            this.logger.debug("skip model - no project model pom file");
            return projectModel;
        }
        projectModel.setPomFile(new File(pomSource.getLocation()));
        if (!this.initialized) {
            this.init(projectModel);
            this.initialized = true;
        }
        if (this.disabled) {
            return projectModel;
        }
        File canonicalProjectPomFile = projectModel.getPomFile().getCanonicalFile();
        if (!this.projectModules.contains(canonicalProjectPomFile)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("skip model - non project module - " + projectModel.getPomFile());
            }
            return projectModel;
        }
        GAV projectGAV = GAV.of(projectModel);
        if (projectGAV.getVersion() == null) {
            this.logger.debug("skip model - can not determine project version - " + projectModel.getPomFile());
            return projectModel;
        }
        Model cachedProjectModel = this.sessionModelCache.get(canonicalProjectPomFile);
        if (cachedProjectModel != null) {
            return cachedProjectModel;
        }
        this.sessionModelCache.put(canonicalProjectPomFile, projectModel);
        this.logger.info(GitVersioningModelProcessor.projectLogHeader(projectGAV));
        this.updateModel(projectModel);
        this.addGitProperties(projectModel);
        File gitVersionedPomFile = this.writePomFile(projectModel);
        if (this.updatePomOption) {
            this.logger.debug("updating original POM file");
            Files.copy(gitVersionedPomFile.toPath(), projectModel.getPomFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.addBuildPlugin(projectModel);
        for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(projectModel)) {
            this.projectModules.add(modulePomFile.getCanonicalFile());
        }
        this.logger.info("");
        return projectModel;
    }

    private void updateModel(Model projectModel) {
        GAV originalProjectGAV = GAV.of(projectModel);
        this.updateVersion(projectModel.getParent());
        this.updateVersion(projectModel);
        this.logger.info("project version: " + GAV.of(projectModel).getVersion());
        this.updatePropertyValues((ModelBase)projectModel, originalProjectGAV);
        this.updateDependencyVersions((ModelBase)projectModel);
        this.updatePluginVersions((ModelBase)projectModel);
        this.updateProfiles(projectModel.getProfiles(), originalProjectGAV);
    }

    private void updateProfiles(List<Profile> profiles, GAV originalProjectGAV) {
        if (!profiles.isEmpty()) {
            for (Profile profile : profiles) {
                this.updatePropertyValues((ModelBase)profile, originalProjectGAV);
                this.updateDependencyVersions((ModelBase)profile);
                this.updatePluginVersions((ModelBase)profile);
            }
        }
    }

    private void updateVersion(Parent parent) {
        GAV parentGAV;
        if (parent != null && this.relatedProjects.contains(parentGAV = GAV.of(parent))) {
            String gitVersion = this.getGitVersion(parentGAV);
            this.logger.debug("set parent version to " + gitVersion + " (" + parentGAV + ")");
            parent.setVersion(this.getGitVersion(parentGAV));
        }
    }

    private void updateVersion(Model projectModel) {
        if (projectModel.getVersion() != null) {
            GAV projectGAV = GAV.of(projectModel);
            String gitVersion = this.getGitVersion(projectGAV);
            this.logger.debug("set version to " + gitVersion);
            projectModel.setVersion(gitVersion);
        }
    }

    private void updatePropertyValues(ModelBase model, GAV originalProjectGAV) {
        boolean logHeader = true;
        for (Map.Entry<Object, Object> entry : model.getProperties().entrySet()) {
            String gitPropertyValue = this.getGitProjectPropertyValue(originalProjectGAV, (String)entry.getKey(), (String)entry.getValue());
            if (gitPropertyValue.equals(entry.getValue())) continue;
            if (logHeader) {
                this.logger.info(GitVersioningModelProcessor.sectionLogHeader("properties", model));
                logHeader = false;
            }
            this.logger.info(entry.getKey() + ": " + gitPropertyValue);
            model.addProperty((String)entry.getKey(), gitPropertyValue);
        }
    }

    private void updatePluginVersions(ModelBase model) {
        List<ReportPlugin> list;
        Reporting reporting;
        List<Plugin> relatedPlugins2;
        PluginManagement pluginManagement;
        BuildBase build = MavenUtil.getBuild(model);
        if (build == null) {
            return;
        }
        List<Plugin> relatedPlugins3 = this.filterRelatedPlugins(build.getPlugins());
        if (!relatedPlugins3.isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("plugins", model));
            for (Plugin plugin : relatedPlugins3) {
                this.updateVersion(plugin);
            }
        }
        if ((pluginManagement = build.getPluginManagement()) != null && !(relatedPlugins2 = this.filterRelatedPlugins(pluginManagement.getPlugins())).isEmpty()) {
            this.logger.debug(MessageUtils.buffer().strong((Object)"plugin management:").toString());
            for (Plugin plugin : relatedPlugins2) {
                this.updateVersion(plugin);
            }
        }
        if ((reporting = model.getReporting()) != null && !(list = this.filterRelatedReportPlugins(reporting.getPlugins())).isEmpty()) {
            this.logger.debug(MessageUtils.buffer().strong((Object)"reporting plugins:").toString());
            for (ReportPlugin plugin : list) {
                this.updateVersion(plugin);
            }
        }
    }

    private void updateVersion(Plugin plugin) {
        if (plugin.getVersion() != null) {
            GAV pluginGAV = GAV.of(plugin);
            String gitVersion = this.getGitVersion(pluginGAV);
            this.logger.debug(pluginGAV.getProjectId() + ": set version to " + gitVersion);
            plugin.setVersion(gitVersion);
        }
    }

    private void updateVersion(ReportPlugin plugin) {
        if (plugin.getVersion() != null) {
            GAV pluginGAV = GAV.of(plugin);
            String gitVersion = this.getGitVersion(pluginGAV);
            this.logger.debug(pluginGAV.getProjectId() + ": set version to " + gitVersion);
            plugin.setVersion(gitVersion);
        }
    }

    private List<Plugin> filterRelatedPlugins(List<Plugin> plugins) {
        return plugins.stream().filter(it -> this.relatedProjects.contains(GAV.of(it))).collect(Collectors.toList());
    }

    private List<ReportPlugin> filterRelatedReportPlugins(List<ReportPlugin> plugins) {
        return plugins.stream().filter(it -> this.relatedProjects.contains(GAV.of(it))).collect(Collectors.toList());
    }

    private void updateDependencyVersions(ModelBase model) {
        List<Dependency> relatedDependencies;
        DependencyManagement dependencyManagement;
        List<Dependency> relatedDependencies2 = this.filterRelatedDependencies(model.getDependencies());
        if (!relatedDependencies2.isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("dependencies", model));
            for (Dependency dependency : relatedDependencies2) {
                this.updateVersion(dependency);
            }
        }
        if ((dependencyManagement = model.getDependencyManagement()) != null && !(relatedDependencies = this.filterRelatedDependencies(dependencyManagement.getDependencies())).isEmpty()) {
            this.logger.debug(MessageUtils.buffer().strong((Object)"dependency management:").toString());
            for (Dependency dependency : relatedDependencies) {
                this.updateVersion(dependency);
            }
        }
    }

    private void updateVersion(Dependency dependency) {
        if (dependency.getVersion() != null) {
            GAV dependencyGAV = GAV.of(dependency);
            String gitVersion = this.getGitVersion(dependencyGAV);
            this.logger.debug(dependencyGAV.getProjectId() + ": set version to " + gitVersion);
            dependency.setVersion(gitVersion);
        }
    }

    public List<Dependency> filterRelatedDependencies(List<Dependency> dependencies) {
        return dependencies.stream().filter(it -> this.relatedProjects.contains(GAV.of(it))).collect(Collectors.toList());
    }

    private void addGitProperties(Model projectModel) {
        this.gitProjectProperties.forEach((arg_0, arg_1) -> ((Model)projectModel).addProperty(arg_0, arg_1));
    }

    private void addBuildPlugin(Model projectModel) {
        this.logger.debug("add version build plugin");
        Plugin plugin = GitVersioningMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("git-versioning");
        execution.getGoals().add("git-versioning");
        plugin.getExecutions().add(execution);
        if (projectModel.getBuild() == null) {
            projectModel.setBuild(new Build());
        }
        projectModel.getBuild().getPlugins().add(plugin);
    }

    private GitSituation getGitSituation(File executionRootDirectory) throws IOException {
        String providedBranch;
        GitSituation gitSituation = GitUtil.situation(executionRootDirectory);
        if (gitSituation == null) {
            return null;
        }
        String providedTag = this.getCommandOption(OPTION_NAME_GIT_TAG);
        if (providedTag != null) {
            this.logger.debug("set git head tag by command option: " + providedTag);
            gitSituation = GitSituation.Builder.of(gitSituation).setHeadBranch(null).setHeadTags(providedTag.isEmpty() ? Collections.emptyList() : Collections.singletonList(providedTag)).build();
        }
        if ((providedBranch = this.getCommandOption(OPTION_NAME_GIT_BRANCH)) != null) {
            this.logger.debug("set git head branch by command option: " + providedBranch);
            gitSituation = GitSituation.Builder.of(gitSituation).setHeadBranch(providedBranch).build();
        }
        return gitSituation;
    }

    private static GitVersionDetails getGitVersionDetails(GitSituation gitSituation, Configuration config, boolean preferTags) {
        String headCommit = gitSituation.getHeadCommit();
        if (!gitSituation.getHeadTags().isEmpty() && (gitSituation.isDetached() || preferTags)) {
            List sortedHeadTags = gitSituation.getHeadTags().stream().sorted(Comparator.comparing(DefaultArtifactVersion::new)).collect(Collectors.toList());
            for (Configuration.VersionDescription tagConfig : config.tag) {
                for (String headTag : sortedHeadTags) {
                    if (tagConfig.pattern != null && !headTag.matches(tagConfig.pattern)) continue;
                    return new GitVersionDetails(headCommit, GitRefType.TAG, headTag, tagConfig);
                }
            }
        }
        if (gitSituation.isDetached()) {
            if (config.commit != null && (config.commit.pattern == null || headCommit.matches(config.commit.pattern))) {
                return new GitVersionDetails(headCommit, GitRefType.COMMIT, headCommit, config.commit);
            }
            return new GitVersionDetails(headCommit, GitRefType.COMMIT, headCommit, new Configuration.VersionDescription(){
                {
                    this.versionFormat = GitVersioningModelProcessor.DEFAULT_COMMIT_VERSION_FORMAT;
                }
            });
        }
        String headBranch = gitSituation.getHeadBranch();
        for (Configuration.VersionDescription branchConfig : config.branch) {
            if (branchConfig.pattern != null && !headBranch.matches(branchConfig.pattern)) continue;
            return new GitVersionDetails(headCommit, GitRefType.BRANCH, headBranch, branchConfig);
        }
        return new GitVersionDetails(headCommit, GitRefType.BRANCH, headBranch, new Configuration.VersionDescription(){
            {
                this.versionFormat = GitVersioningModelProcessor.DEFAULT_BRANCH_VERSION_FORMAT;
            }
        });
    }

    private String getGitVersion(GAV originalProjectGAV) {
        Map<String, String> placeholderMap = this.generateFormatPlaceholderMap(originalProjectGAV);
        return StringUtil.substituteText(this.gitVersionDetails.getConfig().versionFormat, placeholderMap).replace("/", "-");
    }

    private String getGitProjectPropertyValue(GAV originalProjectGAV, String key, String originalValue) {
        Configuration.PropertyDescription propertyConfig = this.gitVersioningPropertyDescriptionMap.get(key);
        if (propertyConfig == null) {
            return originalValue;
        }
        Map<String, String> placeholderMap = this.generateFormatPlaceholderMap(originalProjectGAV);
        placeholderMap.put("value", originalValue);
        return StringUtil.substituteText(propertyConfig.valueFormat, placeholderMap);
    }

    private Map<String, String> generateFormatPlaceholderMap(GAV originalProjectGAV) {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        placeholderMap.putAll(this.globalFormatPlaceholderMap);
        placeholderMap.putAll(GitVersioningModelProcessor.generateFormatPlaceholderMapFromVersion(originalProjectGAV));
        return placeholderMap;
    }

    private static Map<String, String> generateGlobalFormatPlaceholderMap(GitSituation gitSituation, GitVersionDetails gitVersionDetails, MavenSession mavenSession) {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        String headCommit = gitSituation.getHeadCommit();
        placeholderMap.put("commit", headCommit);
        placeholderMap.put("commit.short", headCommit.substring(0, 7));
        ZonedDateTime headCommitDateTime = gitSituation.getHeadCommitDateTime();
        placeholderMap.put("commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        placeholderMap.put("commit.timestamp.year", String.valueOf(headCommitDateTime.getYear()));
        placeholderMap.put("commit.timestamp.month", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getMonthValue()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.day", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getDayOfMonth()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.hour", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getHour()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.minute", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getMinute()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.second", StringUtils.leftPad((String)String.valueOf(headCommitDateTime.getSecond()), (int)2, (String)"0"));
        placeholderMap.put("commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000000.000000");
        String refTypeName = gitVersionDetails.getRefType().name().toLowerCase();
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningModelProcessor.slugify(refName);
        placeholderMap.put("ref", refName);
        placeholderMap.put("ref.slug", refNameSlug);
        placeholderMap.put(refTypeName, refName);
        placeholderMap.put(refTypeName + ".slug", refNameSlug);
        String refPattern = gitVersionDetails.getConfig().pattern;
        if (refPattern != null) {
            Map<String, String> refNameValueGroupMap = StringUtil.valueGroupMap(refName, refPattern);
            placeholderMap.putAll(refNameValueGroupMap);
            placeholderMap.putAll(refNameValueGroupMap.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey() + ".slug", entry -> GitVersioningModelProcessor.slugify((String)entry.getValue()))));
        }
        placeholderMap.put("dirty", !gitSituation.isClean() ? "-DIRTY" : "");
        placeholderMap.put("dirty.snapshot", !gitSituation.isClean() ? "-SNAPSHOT" : "");
        mavenSession.getUserProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> placeholderMap.put((String)key, (String)value)));
        System.getenv().forEach((key, value) -> placeholderMap.put("env." + key, (String)value));
        return placeholderMap;
    }

    private static Map<String, String> generateFormatPlaceholderMapFromVersion(GAV originalProjectGAV) {
        HashMap<String, String> placeholderMap = new HashMap<String, String>();
        String originalProjectVersion = originalProjectGAV.getVersion();
        placeholderMap.put("version", originalProjectVersion);
        placeholderMap.put("version.release", originalProjectVersion.replaceFirst("-SNAPSHOT$", ""));
        return placeholderMap;
    }

    private static Map<String, String> generateGitProjectProperties(GitSituation gitSituation, GitVersionDetails gitVersionDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("git.commit", gitVersionDetails.getCommit());
        ZonedDateTime headCommitDateTime = gitSituation.getHeadCommitDateTime();
        properties.put("git.commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        properties.put("git.commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ISO_INSTANT) : "0000-00-00T00:00:00Z");
        String refTypeName = gitVersionDetails.getRefType().name().toLowerCase();
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningModelProcessor.slugify(refName);
        properties.put("git.ref", refName);
        properties.put("git.ref.slug", refNameSlug);
        properties.put("git." + refTypeName, refName);
        properties.put("git." + refTypeName + ".slug", refNameSlug);
        properties.put("git.dirty", Boolean.toString(!gitSituation.isClean()));
        return properties;
    }

    private static File findMvnDirectory(File baseDirectory) throws IOException {
        for (File searchDirectory = baseDirectory; searchDirectory != null; searchDirectory = searchDirectory.getParentFile()) {
            File mvnDir = new File(searchDirectory, ".mvn");
            if (!mvnDir.exists()) continue;
            return mvnDir;
        }
        throw new FileNotFoundException("Can not find .mvn directory in hierarchy of " + baseDirectory);
    }

    private static Configuration readConfig(File configFile) throws IOException {
        Configuration config = (Configuration)new XmlMapper().readValue(configFile, Configuration.class);
        for (Configuration.VersionDescription versionDescription : config.branch) {
            if (versionDescription.versionFormat != null) continue;
            versionDescription.versionFormat = DEFAULT_BRANCH_VERSION_FORMAT;
        }
        for (Configuration.VersionDescription versionDescription : config.tag) {
            if (versionDescription.versionFormat != null) continue;
            versionDescription.versionFormat = DEFAULT_TAG_VERSION_FORMAT;
        }
        if (config.commit != null && config.commit.versionFormat == null) {
            config.commit.versionFormat = DEFAULT_COMMIT_VERSION_FORMAT;
        }
        return config;
    }

    private String getCommandOption(String name) {
        String value = this.mavenSession.getUserProperties().getProperty(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    private boolean getPreferTagsOption(Configuration config) {
        String preferTagsCommandOption = this.getCommandOption(OPTION_PREFER_TAGS);
        if (preferTagsCommandOption != null) {
            return Boolean.parseBoolean(preferTagsCommandOption);
        }
        if (config.preferTags != null) {
            return config.preferTags;
        }
        return false;
    }

    private boolean getUpdatePomOption(Configuration config, Configuration.VersionDescription gitRefConfig) {
        String updatePomCommandOption = this.getCommandOption(OPTION_UPDATE_POM);
        if (updatePomCommandOption != null) {
            return Boolean.parseBoolean(updatePomCommandOption);
        }
        if (gitRefConfig.updatePom != null) {
            return gitRefConfig.updatePom;
        }
        if (config.updatePom != null) {
            return config.updatePom;
        }
        return false;
    }

    private Set<GAV> determineRelatedProjects(Model projectModel) throws IOException {
        HashSet<GAV> relatedProjects = new HashSet<GAV>();
        this.determineRelatedProjects(projectModel, relatedProjects);
        return relatedProjects;
    }

    private void determineRelatedProjects(Model projectModel, Set<GAV> relatedProjects) throws IOException {
        Model parentProjectModel;
        GAV projectGAV = GAV.of(projectModel);
        if (relatedProjects.contains(projectGAV)) {
            return;
        }
        relatedProjects.add(projectGAV);
        if (projectModel.getParent() != null) {
            Model parentProjectModel2;
            GAV parentProjectGAV;
            GAV parentGAV = GAV.of(projectModel.getParent());
            File parentProjectPomFile = GitVersioningModelProcessor.getParentProjectPomFile(projectModel);
            if (this.isRelatedPom(parentProjectPomFile) && (parentProjectGAV = GAV.of(parentProjectModel2 = MavenUtil.readModel(parentProjectPomFile))).equals(parentGAV)) {
                this.determineRelatedProjects(parentProjectModel2, relatedProjects);
            }
        }
        if ((parentProjectModel = this.searchParentProjectInParentDirectory(projectModel)) != null) {
            this.determineRelatedProjects(parentProjectModel, relatedProjects);
        }
        for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(projectModel)) {
            Model moduleProjectModel = MavenUtil.readModel(modulePomFile);
            this.determineRelatedProjects(moduleProjectModel, relatedProjects);
        }
    }

    private boolean isRelatedPom(File pomFile) throws IOException {
        return pomFile != null && pomFile.exists() && pomFile.isFile() && pomFile.getName().endsWith(".xml") && pomFile.getCanonicalPath().startsWith(this.mvnDirectory.getParentFile().getCanonicalPath() + File.separator) && pomFile.getCanonicalPath().startsWith(this.gitSituation.getRootDirectory().getCanonicalPath() + File.separator);
    }

    private Model searchParentProjectInParentDirectory(Model projectModel) throws IOException {
        File parentDirectoryPomFile = MavenUtil.pomFile(projectModel.getProjectDirectory().getParentFile(), "pom.xml");
        if (parentDirectoryPomFile.exists() && this.isRelatedPom(parentDirectoryPomFile)) {
            Model parentDirectoryProjectModel = MavenUtil.readModel(parentDirectoryPomFile);
            for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(parentDirectoryProjectModel)) {
                if (!modulePomFile.getCanonicalFile().equals(projectModel.getPomFile().getCanonicalFile())) continue;
                return parentDirectoryProjectModel;
            }
        }
        return null;
    }

    private static File getParentProjectPomFile(Model projectModel) {
        if (projectModel.getParent() == null) {
            return null;
        }
        File parentProjectPomFile = MavenUtil.pomFile(projectModel.getProjectDirectory(), projectModel.getParent().getRelativePath());
        if (parentProjectPomFile.exists()) {
            return parentProjectPomFile;
        }
        return null;
    }

    private static Set<File> getProjectModules(Model projectModel) {
        HashSet<File> modules = new HashSet<File>();
        for (String module : projectModel.getModules()) {
            modules.add(MavenUtil.pomFile(projectModel.getProjectDirectory(), module));
        }
        for (Profile profile : projectModel.getProfiles()) {
            for (String module : profile.getModules()) {
                modules.add(MavenUtil.pomFile(projectModel.getProjectDirectory(), module));
            }
        }
        return modules.stream().filter(File::exists).collect(Collectors.toSet());
    }

    private File writePomFile(Model projectModel) throws IOException {
        File gitVersionedPomFile = new File(projectModel.getProjectDirectory(), GIT_VERSIONING_POM_NAME);
        this.logger.debug("generate " + gitVersionedPomFile);
        Document gitVersionedPomDocument = MavenUtil.readXml(projectModel.getPomFile());
        Element projectElement = gitVersionedPomDocument.getChild("project");
        GitVersioningModelProcessor.updateParentVersion(projectElement, projectModel.getParent());
        GitVersioningModelProcessor.updateVersion(projectElement, projectModel);
        this.updatePropertyValues(projectElement, (ModelBase)projectModel);
        GitVersioningModelProcessor.updateDependencyVersions(projectElement, (ModelBase)projectModel);
        GitVersioningModelProcessor.updatePluginVersions(projectElement, (BuildBase)projectModel.getBuild(), projectModel.getReporting());
        this.updateProfiles(projectElement, projectModel.getProfiles());
        MavenUtil.writeXml(gitVersionedPomFile, gitVersionedPomDocument);
        return gitVersionedPomFile;
    }

    private static void updateParentVersion(Element projectElement, Parent parent) {
        Element parentElement = projectElement.getChild("parent");
        if (parentElement != null) {
            Element parentVersionElement = parentElement.getChild("version");
            parentVersionElement.setText(parent.getVersion());
        }
    }

    private static void updateVersion(Element projectElement, Model projectModel) {
        Element versionElement = projectElement.getChild("version");
        if (versionElement != null) {
            versionElement.setText(projectModel.getVersion());
        }
    }

    private void updatePropertyValues(Element element, ModelBase model) {
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null) {
            Properties modelProperties = model.getProperties();
            this.gitVersionDetails.getConfig().property.forEach(property -> {
                String propertyName = property.name;
                Element propertyElement = propertiesElement.getChild(propertyName);
                if (propertyElement != null) {
                    String pomPropertyValue = propertyElement.getText();
                    String modelPropertyValue = (String)modelProperties.get(propertyName);
                    if (!Objects.equals(modelPropertyValue, pomPropertyValue)) {
                        propertyElement.setText(modelPropertyValue);
                    }
                }
            });
        }
    }

    private static void updateDependencyVersions(Element element, ModelBase model) {
        Element dependenciesElement;
        Element dependencyManagementElement;
        Element dependenciesElement2 = element.getChild("dependencies");
        if (dependenciesElement2 != null) {
            GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement2, model.getDependencies());
        }
        if ((dependencyManagementElement = element.getChild("dependencyManagement")) != null && (dependenciesElement = dependencyManagementElement.getChild("dependencies")) != null) {
            GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement, model.getDependencyManagement().getDependencies());
        }
    }

    private static void updateDependencyVersions(Element dependenciesElement, List<Dependency> dependencies) {
        GitVersioningModelProcessor.forEachPair(dependenciesElement.getChildren(), dependencies, (dependencyElement, dependency) -> {
            if (!Objects.equals(dependency.getManagementKey(), GitVersioningModelProcessor.getDependencyManagementKey(dependencyElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model dependencies order");
            }
            Element dependencyVersionElement = dependencyElement.getChild("version");
            if (dependencyVersionElement != null) {
                dependencyVersionElement.setText(dependency.getVersion());
            }
        });
    }

    private static String getDependencyManagementKey(Element element) {
        Element groupId = element.getChild("groupId");
        Element artifactId = element.getChild("artifactId");
        Element type = element.getChild("type");
        Element classifier = element.getChild("classifier");
        return (groupId != null ? groupId.getText().trim() : "") + ":" + (artifactId != null ? artifactId.getText().trim() : "") + ":" + (type != null ? type.getText().trim() : "jar") + (classifier != null ? ":" + classifier.getText().trim() : "");
    }

    private static void updatePluginVersions(Element projectElement, BuildBase build, Reporting reporting) {
        Element reportingElement;
        Element pluginsElement;
        Element buildElement = projectElement.getChild("build");
        if (buildElement != null) {
            Element pluginsManagementElement;
            Element pluginsElement2 = buildElement.getChild("plugins");
            if (pluginsElement2 != null) {
                GitVersioningModelProcessor.updatePluginVersions(pluginsElement2, build.getPlugins());
            }
            if ((pluginsManagementElement = buildElement.getChild("pluginsManagement")) != null && (pluginsElement = pluginsManagementElement.getChild("plugins")) != null) {
                GitVersioningModelProcessor.updatePluginVersions(pluginsElement, build.getPluginManagement().getPlugins());
            }
        }
        if ((reportingElement = projectElement.getChild("reporting")) != null && (pluginsElement = reportingElement.getChild("plugins")) != null) {
            GitVersioningModelProcessor.updateReportPluginVersions(pluginsElement, reporting.getPlugins());
        }
    }

    private static void updatePluginVersions(Element pluginsElement, List<Plugin> plugins) {
        GitVersioningModelProcessor.forEachPair(pluginsElement.getChildren(), plugins, (pluginElement, plugin) -> {
            if (!Objects.equals(plugin.getKey(), GitVersioningModelProcessor.getPluginKey(pluginElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model plugin order");
            }
            Element pluginVersionElement = pluginElement.getChild("version");
            if (pluginVersionElement != null) {
                pluginVersionElement.setText(plugin.getVersion());
            }
        });
    }

    private static void updateReportPluginVersions(Element pluginsElement, List<ReportPlugin> plugins) {
        GitVersioningModelProcessor.forEachPair(pluginsElement.getChildren(), plugins, (pluginElement, plugin) -> {
            if (!Objects.equals(plugin.getKey(), GitVersioningModelProcessor.getPluginKey(pluginElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model plugin order");
            }
            Element pluginVersionElement = pluginElement.getChild("version");
            if (pluginVersionElement != null) {
                pluginVersionElement.setText(plugin.getVersion());
            }
        });
    }

    private static String getPluginKey(Element element) {
        Element groupId = element.getChild("groupId");
        Element artifactId = element.getChild("artifactId");
        return (groupId != null ? groupId.getText().trim() : "org.apache.maven.plugins") + ":" + (artifactId != null ? artifactId.getText().trim() : "");
    }

    private void updateProfiles(Element projectElement, List<Profile> profiles) {
        Element profilesElement = projectElement.getChild("profiles");
        if (profilesElement != null) {
            Map<String, Profile> profileMap = profiles.stream().collect(Collectors.toMap(Profile::getId, it -> it));
            for (Element profileElement : profilesElement.getChildren("profile")) {
                Profile profile = profileMap.get(profileElement.getChild("id").getText());
                this.updatePropertyValues(profileElement, (ModelBase)profile);
                GitVersioningModelProcessor.updateDependencyVersions(profileElement, (ModelBase)profile);
                GitVersioningModelProcessor.updatePluginVersions(profileElement, profile.getBuild(), profile.getReporting());
            }
        }
    }

    private static String extensionLogHeader(GAV extensionGAV) {
        String extension = extensionGAV.toString();
        String metaInfo = "[core extension]";
        String plainLog = extension + " " + metaInfo;
        String formattedLog = MessageUtils.buffer().a((CharSequence)" ").mojo((Object)extension).a((CharSequence)" ").strong((Object)metaInfo).a((CharSequence)" ").toString();
        return GitVersioningModelProcessor.padLogHeaderPadding(plainLog, formattedLog);
    }

    private static String padLogHeaderPadding(String plainLog, String formattedLog) {
        String pad = "-";
        int padding = Math.max(6, 70 - plainLog.length());
        int paddingLeft = (int)Math.floor((double)padding / 2.0);
        int paddingRight = (int)Math.ceil((double)padding / 2.0);
        return MessageUtils.buffer().strong((Object)StringUtils.repeat((String)pad, (int)paddingLeft)).a((CharSequence)formattedLog).strong((Object)StringUtils.repeat((String)pad, (int)paddingRight)).toString();
    }

    private static String projectLogHeader(GAV projectGAV) {
        String project = projectGAV.getProjectId();
        return MessageUtils.buffer().project((Object)project).toString();
    }

    private static String sectionLogHeader(String title, ModelBase model) {
        String header = title + ":";
        if (model instanceof Profile) {
            header = MessageUtils.buffer().strong((Object)("profile " + ((Profile)model).getId() + " ")) + header;
        }
        return header;
    }

    private static String slugify(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("/", "-").toLowerCase();
    }

    public static <T1, T2> void forEachPair(Collection<T1> collection1, Collection<T2> collection2, BiConsumer<T1, T2> consumer) {
        if (collection1.size() != collection2.size()) {
            throw new IllegalArgumentException("Collections sizes are not equals");
        }
        Iterator<T1> iter1 = collection1.iterator();
        Iterator<T2> iter2 = collection2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            consumer.accept(iter1.next(), iter2.next());
        }
    }
}

