/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.RefNameComparator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public final class GitUtil {
    public static String NO_COMMIT = "0000000000000000000000000000000000000000";

    public static Status status(Repository repository) {
        try {
            return Git.wrap((Repository)repository).status().call();
        }
        catch (GitAPIException e) {
            throw new RuntimeException(e);
        }
    }

    public static String branch(Repository repository) throws IOException {
        String branch = repository.getBranch();
        if (ObjectId.isId((String)branch)) {
            return null;
        }
        return branch;
    }

    public static List<String> tagsPointAt(Repository repository, ObjectId revObjectId) throws IOException {
        return GitUtil.tagsPointAt(repository, revObjectId, GitUtil.reverseTagRefMap(repository));
    }

    public static List<String> tagsPointAt(Repository repository, ObjectId revObjectId, Map<ObjectId, List<Ref>> reverseTagRefMap) {
        return reverseTagRefMap.getOrDefault(revObjectId, Collections.emptyList()).stream().sorted(new RefNameComparator(repository)).map(ref -> Repository.shortenRefName((String)ref.getName())).collect(Collectors.toList());
    }

    public static GitDescription describe(Repository repository, ObjectId revObjectId, Pattern tagPattern) throws IOException {
        return GitUtil.describe(repository, revObjectId, tagPattern, GitUtil.reverseTagRefMap(repository));
    }

    public static GitDescription describe(Repository repository, ObjectId revObjectId, Pattern tagPattern, Map<ObjectId, List<Ref>> reverseTagRefMap) throws IOException {
        if (revObjectId == null) {
            return new GitDescription(NO_COMMIT, "root", 0);
        }
        try (RevWalk walk = new RevWalk(repository);){
            walk.setRetainBody(false);
            walk.setFirstParent(true);
            walk.markStart(walk.parseCommit((AnyObjectId)revObjectId));
            Iterator walkIterator = walk.iterator();
            int depth = -1;
            while (walkIterator.hasNext()) {
                RevCommit rev = (RevCommit)walkIterator.next();
                ++depth;
                Optional<Ref> matchingTag = reverseTagRefMap.getOrDefault(rev, Collections.emptyList()).stream().sorted(new RefNameComparator(repository)).filter(tag -> tagPattern.matcher(Repository.shortenRefName((String)tag.getName())).matches()).findFirst();
                if (!matchingTag.isPresent()) continue;
                GitDescription gitDescription = new GitDescription(revObjectId.getName(), Repository.shortenRefName((String)matchingTag.get().getName()), depth);
                return gitDescription;
            }
            if (GitUtil.isShallowRepository(repository)) {
                throw new IllegalStateException("couldn't find matching tag in shallow git repository");
            }
            GitDescription gitDescription = new GitDescription(revObjectId.getName(), "root", depth);
            return gitDescription;
        }
    }

    public static boolean isShallowRepository(Repository repository) {
        return new File(repository.getDirectory(), "shallow").isFile();
    }

    public static List<Ref> tags(Repository repository) throws IOException {
        return GitUtil.tags(repository.getRefDatabase());
    }

    public static List<Ref> tags(RefDatabase refDatabase) throws IOException {
        return refDatabase.getRefsByPrefix("refs/tags/");
    }

    public static Map<ObjectId, List<Ref>> reverseTagRefMap(Repository repository) throws IOException {
        RefDatabase refDatabase = repository.getRefDatabase();
        return GitUtil.tags(refDatabase).stream().collect(Collectors.groupingBy(ref -> {
            try {
                ObjectId peeledObjectId = refDatabase.peel(ref).getPeeledObjectId();
                return peeledObjectId != null ? peeledObjectId : ref.getObjectId();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    public static ZonedDateTime revTimestamp(Repository repository, ObjectId rev) throws IOException {
        Instant commitTime = Instant.ofEpochSecond(repository.parseCommit((AnyObjectId)rev).getCommitTime());
        return ZonedDateTime.ofInstant(commitTime, ZoneOffset.UTC);
    }
}

