/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.qoomon.gitversioning.commons.GitRefType;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JacksonXmlRootElement(localName="configuration")
public class Configuration {
    private static final Pattern MATCH_ALL = Pattern.compile(".*");
    public Boolean disable = false;
    public Pattern describeTagPattern = MATCH_ALL;
    public Boolean updatePom = false;
    public RefPatchDescriptionList refs = new RefPatchDescriptionList();
    public PatchDescription rev;

    public static class RefPatchDescriptionList {
        @JacksonXmlProperty(isAttribute=true)
        public Boolean considerTagsOnBranches = false;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JacksonXmlElementWrapper(useWrapping=false)
        @JacksonXmlProperty(localName="ref")
        public List<RefPatchDescription> list = new ArrayList<RefPatchDescription>();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class RefPatchDescription
    extends PatchDescription {
        @JacksonXmlProperty(isAttribute=true)
        public GitRefType type = GitRefType.COMMIT;
        public Pattern pattern;

        public RefPatchDescription() {
        }

        public RefPatchDescription(GitRefType type, Pattern pattern, PatchDescription description) {
            this.type = type;
            this.pattern = pattern;
            this.describeTagPattern = description.describeTagPattern;
            this.updatePom = description.updatePom;
            this.version = description.version;
            this.properties = new HashMap<String, String>(description.properties);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class PatchDescription {
        public Pattern describeTagPattern;
        public String version;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @JacksonXmlElementWrapper(useWrapping=false)
        public Map<String, String> properties = new HashMap<String, String>();
        public Boolean updatePom;
    }
}

