/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.GitRefType;
import me.qoomon.gitversioning.commons.GitSituation;
import me.qoomon.gitversioning.commons.Lazy;
import me.qoomon.gitversioning.commons.StringUtil;
import me.qoomon.maven.gitversioning.BuildProperties;
import me.qoomon.maven.gitversioning.Configuration;
import me.qoomon.maven.gitversioning.GAV;
import me.qoomon.maven.gitversioning.GitVersionDetails;
import me.qoomon.maven.gitversioning.GitVersioningMojo;
import me.qoomon.maven.gitversioning.MavenUtil;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.DefaultModelProcessor;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="core-default")
@Singleton
@Typed(value={ModelProcessor.class})
public class GitVersioningModelProcessor
extends DefaultModelProcessor {
    private static final String OPTION_NAME_GIT_REF = "git.ref";
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_UPDATE_POM = "versioning.updatePom";
    static final String GIT_VERSIONING_POM_NAME = ".git-versioned-pom.xml";
    private final Logger logger = LoggerFactory.getLogger(GitVersioningModelProcessor.class);
    @Inject
    private SessionScope sessionScope;
    private boolean initialized = false;
    private MavenSession mavenSession;
    private File mvnDirectory;
    private GitSituation gitSituation;
    private boolean disabled = false;
    private GitVersionDetails gitVersionDetails;
    boolean updatePom = false;
    private Map<String, Supplier<String>> globalFormatPlaceholderMap;
    private Map<String, String> gitProjectProperties;
    private Set<GAV> relatedProjects;
    private final Map<File, Model> sessionModelCache = new HashMap<File, Model>();

    public Model read(File input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        Model projectModel = super.read(input, options);
        return this.processModel(projectModel, options);
    }

    private void init(Model projectModel) throws IOException {
        this.logger.info("");
        this.logger.info(GitVersioningModelProcessor.extensionLogHeader(BuildProperties.projectGAV()));
        try {
            this.mavenSession = (MavenSession)this.sessionScope.scope(Key.get(MavenSession.class), null).get();
        }
        catch (OutOfScopeException ex) {
            this.logger.warn("skip - no maven session present");
            this.disabled = true;
            return;
        }
        File executionRootDirectory = new File(this.mavenSession.getRequest().getBaseDirectory());
        this.logger.debug("execution root directory: " + executionRootDirectory);
        this.mvnDirectory = GitVersioningModelProcessor.findMvnDirectory(executionRootDirectory);
        this.logger.debug(".mvn directory: " + this.mvnDirectory);
        File configFile = new File(this.mvnDirectory, BuildProperties.projectArtifactId() + ".xml");
        this.logger.debug("read config from " + configFile);
        Configuration config = GitVersioningModelProcessor.readConfig(configFile);
        String commandOptionDisable = this.getCommandOption(OPTION_NAME_DISABLE);
        if (commandOptionDisable != null) {
            this.disabled = Boolean.parseBoolean(commandOptionDisable);
            if (this.disabled) {
                this.logger.info("skip - versioning is disabled by command option");
                return;
            }
        } else {
            boolean bl = this.disabled = config.disable != null && config.disable != false;
            if (this.disabled) {
                this.logger.info("skip - versioning is disabled by config option");
                return;
            }
        }
        this.gitSituation = this.getGitSituation(executionRootDirectory);
        if (this.gitSituation == null) {
            this.logger.warn("skip - project is not part of a git repository");
            this.disabled = true;
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("git situation:");
            this.logger.debug("  root directory: " + this.gitSituation.getRootDirectory());
            this.logger.debug("  head commit: " + this.gitSituation.getRev());
            this.logger.debug("  head commit timestamp: " + this.gitSituation.getTimestamp());
            this.logger.debug("  head branch: " + this.gitSituation.getBranch());
            this.logger.debug("  head tags: " + this.gitSituation.getTags());
            this.logger.debug("  head description: " + this.gitSituation.getDescription());
        }
        this.gitVersionDetails = GitVersioningModelProcessor.getGitVersionDetails(this.gitSituation, config);
        if (this.gitVersionDetails == null) {
            this.logger.warn("skip - no matching <ref> configuration and no <rev> configuration defined");
            this.logger.warn("git refs:");
            this.logger.warn("  branch: " + this.gitSituation.getBranch());
            this.logger.warn("  tags: " + this.gitSituation.getTags());
            this.logger.warn("defined ref configurations:");
            config.refs.list.forEach(ref -> this.logger.warn("  " + StringUtils.rightPad((String)ref.type.name(), (int)6) + " - pattern: " + ref.pattern));
            this.disabled = true;
            return;
        }
        this.logger.info("matching ref: " + this.gitVersionDetails.getRefType().name() + " - " + this.gitVersionDetails.getRefName());
        Configuration.RefPatchDescription patchDescription = this.gitVersionDetails.getPatchDescription();
        this.logger.info("ref configuration: " + this.gitVersionDetails.getRefType().name() + " - pattern: " + patchDescription.pattern);
        if (patchDescription.describeTagPattern != null) {
            this.logger.info("  describeTagPattern: " + patchDescription.describeTagPattern);
            this.gitSituation.setDescribeTagPattern(patchDescription.describeTagPattern);
        }
        if (patchDescription.version != null) {
            this.logger.info("  version: " + patchDescription.version);
        }
        if (!patchDescription.properties.isEmpty()) {
            this.logger.info("  properties: " + patchDescription.version);
            patchDescription.properties.forEach((key, value) -> this.logger.info("    " + key + " - " + value));
        }
        this.updatePom = this.getUpdatePomOption(patchDescription);
        if (this.updatePom) {
            this.logger.info("  updatePom: " + this.updatePom);
        }
        this.globalFormatPlaceholderMap = this.generateGlobalFormatPlaceholderMap(this.gitSituation, this.gitVersionDetails, this.mavenSession);
        this.gitProjectProperties = GitVersioningModelProcessor.generateGitProjectProperties(this.gitSituation, this.gitVersionDetails);
        this.relatedProjects = this.determineRelatedProjects(projectModel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageUtils.buffer().strong((Object)"related projects:").toString());
            this.relatedProjects.forEach(gav -> this.logger.debug("  " + gav));
        }
        this.logger.info("");
    }

    public Model processModel(Model projectModel, Map<String, ?> options) throws IOException {
        Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
        if (pomSource == null) {
            this.logger.debug("skip model - no project model pom file");
            return projectModel;
        }
        projectModel.setPomFile(new File(pomSource.getLocation()));
        if (!this.initialized) {
            this.init(projectModel);
            this.initialized = true;
        }
        if (this.disabled) {
            return projectModel;
        }
        GAV projectGAV = GAV.of(projectModel);
        if (projectGAV.getVersion() == null) {
            this.logger.debug("skip model - can not determine project version - " + projectModel.getPomFile());
            return projectModel;
        }
        if (!this.relatedProjects.contains(projectGAV)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("skip model - unrelated project - " + projectModel.getPomFile());
            }
            return projectModel;
        }
        File canonicalProjectPomFile = projectModel.getPomFile().getCanonicalFile();
        Model cachedProjectModel = this.sessionModelCache.get(canonicalProjectPomFile);
        if (cachedProjectModel != null) {
            return cachedProjectModel;
        }
        this.sessionModelCache.put(canonicalProjectPomFile, projectModel);
        this.logger.info(GitVersioningModelProcessor.projectLogHeader(projectGAV));
        this.updateModel(projectModel, this.gitVersionDetails.getPatchDescription());
        File gitVersionedPomFile = this.writePomFile(projectModel);
        if (this.updatePom) {
            this.logger.debug("updating original POM file");
            Files.copy(gitVersionedPomFile.toPath(), projectModel.getPomFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.addBuildPlugin(projectModel);
        this.logger.info("");
        return projectModel;
    }

    private void updateModel(Model projectModel, Configuration.RefPatchDescription patchDescription) {
        Map propertyFormats;
        GAV originalProjectGAV = GAV.of(projectModel);
        String versionFormat = patchDescription.version;
        if (versionFormat != null) {
            this.updateParentVersion(projectModel, versionFormat);
            this.updateVersion(projectModel, versionFormat);
            this.logger.info("project version: " + GAV.of(projectModel).getVersion());
            this.updateDependencyVersions((ModelBase)projectModel, versionFormat);
            this.updatePluginVersions((ModelBase)projectModel, versionFormat);
        }
        if ((propertyFormats = patchDescription.properties) != null && !propertyFormats.isEmpty()) {
            this.updatePropertyValues((ModelBase)projectModel, propertyFormats, originalProjectGAV);
        }
        this.updateProfiles(projectModel, patchDescription, originalProjectGAV);
        this.addGitProperties(projectModel);
    }

    private void updateProfiles(Model model, Configuration.RefPatchDescription patchDescription, GAV originalProjectGAV) {
        List profiles = model.getProfiles();
        if (!profiles.isEmpty()) {
            for (Profile profile : profiles) {
                Map propertyFormats;
                String version = patchDescription.version;
                if (version != null) {
                    this.updateDependencyVersions((ModelBase)profile, version);
                    this.updatePluginVersions((ModelBase)profile, version);
                }
                if ((propertyFormats = patchDescription.properties) == null || propertyFormats.isEmpty()) continue;
                this.updatePropertyValues((ModelBase)profile, propertyFormats, originalProjectGAV);
            }
        }
    }

    private void updateParentVersion(Model projectModel, String versionFormat) {
        GAV parentGAV;
        Parent parent = projectModel.getParent();
        if (parent != null && this.relatedProjects.contains(parentGAV = GAV.of(parent))) {
            String gitVersion = this.getGitVersion(versionFormat, parentGAV);
            this.logger.debug("set parent version to " + gitVersion + " (" + parentGAV + ")");
            parent.setVersion(gitVersion);
        }
    }

    private void updateVersion(Model projectModel, String versionFormat) {
        if (projectModel.getVersion() != null) {
            GAV projectGAV = GAV.of(projectModel);
            String gitVersion = this.getGitVersion(versionFormat, projectGAV);
            this.logger.debug("set version to " + gitVersion);
            projectModel.setVersion(gitVersion);
        }
    }

    private void updatePropertyValues(ModelBase model, Map<String, String> propertyFormats, GAV originalProjectGAV) {
        boolean logHeader = true;
        for (Map.Entry<Object, Object> modelProperty : model.getProperties().entrySet()) {
            String gitPropertyValue;
            String modelPropertyName = (String)modelProperty.getKey();
            String modelPropertyValue = (String)modelProperty.getValue();
            String propertyFormat = propertyFormats.get(modelPropertyName);
            if (propertyFormat == null || (gitPropertyValue = this.getGitPropertyValue(propertyFormat, modelPropertyValue, originalProjectGAV)).equals(modelPropertyValue)) continue;
            if (logHeader) {
                this.logger.info(GitVersioningModelProcessor.sectionLogHeader("properties", model));
                logHeader = false;
            }
            this.logger.info("set property " + modelPropertyName + " to " + gitPropertyValue);
            model.addProperty(modelPropertyName, gitPropertyValue);
        }
    }

    private void updatePluginVersions(ModelBase model, String versionFormat) {
        List<ReportPlugin> list;
        Reporting reporting;
        List<Plugin> relatedPlugins2;
        PluginManagement pluginManagement;
        BuildBase build = MavenUtil.getBuild(model);
        if (build == null) {
            return;
        }
        List<Plugin> relatedPlugins3 = this.filterRelatedPlugins(build.getPlugins());
        if (!relatedPlugins3.isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("plugins", model));
            for (Plugin plugin : relatedPlugins3) {
                this.updateVersion(plugin, versionFormat);
            }
        }
        if ((pluginManagement = build.getPluginManagement()) != null && !(relatedPlugins2 = this.filterRelatedPlugins(pluginManagement.getPlugins())).isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("plugin management", model));
            for (Plugin plugin : relatedPlugins2) {
                this.updateVersion(plugin, versionFormat);
            }
        }
        if ((reporting = model.getReporting()) != null && !(list = this.filterRelatedReportPlugins(reporting.getPlugins())).isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("reporting plugins", model));
            for (ReportPlugin plugin : list) {
                this.updateVersion(plugin, versionFormat);
            }
        }
    }

    private void updateVersion(Plugin plugin, String versionFormat) {
        if (plugin.getVersion() != null) {
            GAV pluginGAV = GAV.of(plugin);
            String gitVersion = this.getGitVersion(versionFormat, pluginGAV);
            this.logger.debug(pluginGAV.getProjectId() + ": set version to " + gitVersion);
            plugin.setVersion(gitVersion);
        }
    }

    private void updateVersion(ReportPlugin plugin, String versionFormat) {
        if (plugin.getVersion() != null) {
            GAV pluginGAV = GAV.of(plugin);
            String gitVersion = this.getGitVersion(versionFormat, pluginGAV);
            this.logger.debug(pluginGAV.getProjectId() + ": set version to " + gitVersion);
            plugin.setVersion(gitVersion);
        }
    }

    private List<Plugin> filterRelatedPlugins(List<Plugin> plugins) {
        return plugins.stream().filter(it -> this.relatedProjects.contains(GAV.of(it))).collect(Collectors.toList());
    }

    private List<ReportPlugin> filterRelatedReportPlugins(List<ReportPlugin> plugins) {
        return plugins.stream().filter(it -> this.relatedProjects.contains(GAV.of(it))).collect(Collectors.toList());
    }

    private void updateDependencyVersions(ModelBase model, String versionFormat) {
        List<Dependency> relatedDependencies;
        DependencyManagement dependencyManagement;
        List<Dependency> relatedDependencies2 = this.filterRelatedDependencies(model.getDependencies());
        if (!relatedDependencies2.isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("dependencies", model));
            for (Dependency dependency : relatedDependencies2) {
                this.updateVersion(dependency, versionFormat);
            }
        }
        if ((dependencyManagement = model.getDependencyManagement()) != null && !(relatedDependencies = this.filterRelatedDependencies(dependencyManagement.getDependencies())).isEmpty()) {
            this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("dependency management", model));
            for (Dependency dependency : relatedDependencies) {
                this.updateVersion(dependency, versionFormat);
            }
        }
    }

    private void updateVersion(Dependency dependency, String versionFormat) {
        if (dependency.getVersion() != null) {
            GAV dependencyGAV = GAV.of(dependency);
            String gitVersion = this.getGitVersion(versionFormat, dependencyGAV);
            this.logger.debug(dependencyGAV.getProjectId() + ": set version to " + gitVersion);
            dependency.setVersion(gitVersion);
        }
    }

    public List<Dependency> filterRelatedDependencies(List<Dependency> dependencies) {
        return dependencies.stream().filter(it -> this.relatedProjects.contains(GAV.of(it))).collect(Collectors.toList());
    }

    private void addGitProperties(Model projectModel) {
        this.gitProjectProperties.forEach((arg_0, arg_1) -> ((Model)projectModel).addProperty(arg_0, arg_1));
    }

    private void addBuildPlugin(Model projectModel) {
        this.logger.debug("add version build plugin");
        Plugin plugin = GitVersioningMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("git-versioning");
        execution.getGoals().add("git-versioning");
        plugin.getExecutions().add(execution);
        if (projectModel.getBuild() == null) {
            projectModel.setBuild(new Build());
        }
        projectModel.getBuild().getPlugins().add(plugin);
    }

    private GitSituation getGitSituation(File executionRootDirectory) throws IOException {
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(executionRootDirectory);
        if (repositoryBuilder.getGitDir() == null) {
            return null;
        }
        Repository repository = repositoryBuilder.build();
        return new GitSituation(repository){
            {
                String jenkinsEnv;
                String circleciEnv;
                String commitTag;
                String commitBranch;
                String gitlabEnv;
                String githubEnv;
                String providedRef;
                super(repository);
                String overrideBranch = GitVersioningModelProcessor.this.getCommandOption(GitVersioningModelProcessor.OPTION_NAME_GIT_BRANCH);
                String overrideTag = GitVersioningModelProcessor.this.getCommandOption(GitVersioningModelProcessor.OPTION_NAME_GIT_TAG);
                if (overrideBranch == null && overrideTag == null && (providedRef = GitVersioningModelProcessor.this.getCommandOption(GitVersioningModelProcessor.OPTION_NAME_GIT_REF)) != null) {
                    if (!providedRef.startsWith("refs/")) {
                        throw new IllegalArgumentException("invalid provided ref " + providedRef + " -  needs to start with refs/");
                    }
                    if (providedRef.startsWith("refs/tags/")) {
                        overrideTag = providedRef;
                    } else {
                        overrideBranch = providedRef;
                    }
                }
                if (overrideBranch == null && overrideTag == null && (githubEnv = System.getenv("GITHUB_ACTIONS")) != null && githubEnv.equals("true")) {
                    GitVersioningModelProcessor.this.logger.info("gather git situation from GitHub Actions environment variable: GITHUB_REF");
                    String githubRef = System.getenv("GITHUB_REF");
                    GitVersioningModelProcessor.this.logger.debug("  GITHUB_REF: " + githubRef);
                    if (githubRef != null && githubRef.startsWith("refs/")) {
                        if (githubRef.startsWith("refs/tags/")) {
                            overrideTag = githubRef;
                        } else {
                            overrideBranch = githubRef;
                        }
                    }
                }
                if (overrideBranch == null && overrideTag == null && (gitlabEnv = System.getenv("GITLAB_CI")) != null && gitlabEnv.equals("true")) {
                    GitVersioningModelProcessor.this.logger.info("gather git situation from GitLab CI environment variables: CI_COMMIT_BRANCH and CI_COMMIT_TAG");
                    commitBranch = System.getenv("CI_COMMIT_BRANCH");
                    commitTag = System.getenv("CI_COMMIT_TAG");
                    GitVersioningModelProcessor.this.logger.debug("  CI_COMMIT_BRANCH: " + commitBranch);
                    GitVersioningModelProcessor.this.logger.debug("  CI_COMMIT_TAG: " + commitTag);
                    overrideBranch = commitBranch;
                    overrideTag = commitTag;
                }
                if (overrideBranch == null && overrideTag == null && (circleciEnv = System.getenv("CIRCLECI")) != null && circleciEnv.equals("true")) {
                    GitVersioningModelProcessor.this.logger.info("gather git situation from Circle CI environment variables: CIRCLE_BRANCH and CIRCLE_TAG");
                    commitBranch = System.getenv("CIRCLE_BRANCH");
                    commitTag = System.getenv("CIRCLE_TAG");
                    GitVersioningModelProcessor.this.logger.debug("  CIRCLE_BRANCH: " + commitBranch);
                    GitVersioningModelProcessor.this.logger.debug("  CIRCLE_TAG: " + commitTag);
                    overrideBranch = System.getenv("CIRCLE_BRANCH");
                    overrideTag = System.getenv("CIRCLE_TAG");
                }
                if (overrideBranch == null && overrideTag == null && (jenkinsEnv = System.getenv("JENKINS_HOME")) != null && !jenkinsEnv.trim().isEmpty()) {
                    GitVersioningModelProcessor.this.logger.info("gather git situation from jenkins environment variables: BRANCH_NAME and TAG_NAME");
                    String branchName = System.getenv("BRANCH_NAME");
                    String tagName = System.getenv("TAG_NAME");
                    GitVersioningModelProcessor.this.logger.debug("  BRANCH_NAME: " + branchName);
                    GitVersioningModelProcessor.this.logger.debug("  TAG_NAME: " + tagName);
                    if (branchName != null && branchName.equals(tagName)) {
                        overrideTag = tagName;
                    } else {
                        overrideBranch = branchName;
                        overrideTag = tagName;
                    }
                }
                if (overrideBranch != null || overrideTag != null) {
                    this.overrideBranch(overrideBranch);
                    this.overrideTags(overrideTag);
                }
            }

            void overrideBranch(String branch) {
                if (branch != null && branch.trim().isEmpty()) {
                    branch = null;
                }
                if (branch != null) {
                    if (branch.startsWith("refs/tags/")) {
                        throw new IllegalArgumentException("invalid branch ref" + branch);
                    }
                    branch = branch.replaceFirst("^refs/", "").replaceFirst("^heads/", "");
                }
                GitVersioningModelProcessor.this.logger.debug("override git branch with: " + branch);
                this.setBranch(branch);
            }

            void overrideTags(String tag) {
                if (tag != null && tag.trim().isEmpty()) {
                    tag = null;
                }
                if (tag != null) {
                    if (tag.startsWith("refs/") && !tag.startsWith("refs/tags/")) {
                        throw new IllegalArgumentException("invalid tag ref" + tag);
                    }
                    tag = tag.replaceFirst("^refs/tags/", "");
                }
                GitVersioningModelProcessor.this.logger.debug("override git tags with: " + tag);
                this.setTags(tag == null ? Collections.emptyList() : Collections.singletonList(tag));
            }
        };
    }

    private static GitVersionDetails getGitVersionDetails(GitSituation gitSituation, Configuration config) {
        Lazy<List> sortedTags = Lazy.by(() -> gitSituation.getTags().stream().sorted(Comparator.comparing(DefaultArtifactVersion::new)).collect(Collectors.toList()));
        block4: for (Configuration.RefPatchDescription refConfig : config.refs.list) {
            switch (refConfig.type) {
                case TAG: {
                    if (!gitSituation.isDetached() && !config.refs.considerTagsOnBranches.booleanValue()) continue block4;
                    for (String tag : sortedTags.get()) {
                        if (refConfig.pattern != null && !refConfig.pattern.matcher(tag).matches()) continue;
                        return new GitVersionDetails(gitSituation.getRev(), GitRefType.TAG, tag, refConfig);
                    }
                    continue block4;
                }
                case BRANCH: {
                    if (gitSituation.isDetached()) continue block4;
                    String branch = gitSituation.getBranch();
                    if (refConfig.pattern != null && !refConfig.pattern.matcher(branch).matches()) continue block4;
                    return new GitVersionDetails(gitSituation.getRev(), GitRefType.BRANCH, branch, refConfig);
                }
                default: {
                    throw new IllegalArgumentException("Unexpected ref type: " + (Object)((Object)refConfig.type));
                }
            }
        }
        if (config.rev != null) {
            return new GitVersionDetails(gitSituation.getRev(), GitRefType.COMMIT, gitSituation.getRev(), new Configuration.RefPatchDescription(GitRefType.COMMIT, null, config.rev));
        }
        return null;
    }

    private String getGitVersion(String versionFormat, GAV originalProjectGAV) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(originalProjectGAV);
        return GitVersioningModelProcessor.slugify(StringUtil.substituteText(versionFormat, placeholderMap));
    }

    private String getGitPropertyValue(String propertyFormat, String originalValue, GAV originalProjectGAV) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(originalProjectGAV);
        placeholderMap.put("value", () -> originalValue);
        return StringUtil.substituteText(propertyFormat, placeholderMap);
    }

    private Map<String, Supplier<String>> generateFormatPlaceholderMap(GAV originalProjectGAV) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>(this.globalFormatPlaceholderMap);
        Supplier<String> originalProjectVersion = originalProjectGAV::getVersion;
        placeholderMap.put("version", originalProjectVersion);
        placeholderMap.put("version.release", Lazy.by(() -> ((String)originalProjectVersion.get()).replaceFirst("-SNAPSHOT$", "")));
        return placeholderMap;
    }

    private Map<String, Supplier<String>> generateGlobalFormatPlaceholderMap(GitSituation gitSituation, GitVersionDetails gitVersionDetails, MavenSession mavenSession) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>();
        Lazy<String> hash = Lazy.by(gitSituation::getRev);
        placeholderMap.put("commit", hash);
        placeholderMap.put("commit.short", Lazy.by(() -> ((String)hash.get()).substring(0, 7)));
        Lazy<ZonedDateTime> headCommitDateTime = Lazy.by(gitSituation::getTimestamp);
        placeholderMap.put("commit.timestamp", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).toEpochSecond())));
        placeholderMap.put("commit.timestamp.year", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear())));
        placeholderMap.put("commit.timestamp.year.2digit", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear() % 100)));
        placeholderMap.put("commit.timestamp.month", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMonthValue()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.day", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getDayOfMonth()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.hour", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getHour()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.minute", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMinute()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.second", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getSecond()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.datetime", Lazy.by(() -> ((ZonedDateTime)headCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)headCommitDateTime.get()).format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000000.000000"));
        String refName = gitVersionDetails.getRefName();
        Lazy<String> refNameSlug = Lazy.by(() -> GitVersioningModelProcessor.slugify(refName));
        placeholderMap.put("ref", () -> refName);
        placeholderMap.put("ref.slug", refNameSlug);
        Pattern refPattern = gitVersionDetails.getPatchDescription().pattern;
        if (refPattern != null) {
            for (Map.Entry<String, String> patternGroup : StringUtil.patternGroupValues(refPattern, refName).entrySet()) {
                String groupName = patternGroup.getKey();
                String value2 = patternGroup.getValue() != null ? patternGroup.getValue() : "";
                placeholderMap.put("ref." + groupName, () -> value2);
                placeholderMap.put("ref." + groupName + ".slug", Lazy.by(() -> GitVersioningModelProcessor.slugify(value2)));
            }
        }
        Lazy<Boolean> dirty = Lazy.by(() -> !gitSituation.isClean());
        placeholderMap.put("dirty", Lazy.by(() -> (Boolean)dirty.get() != false ? "-DIRTY" : ""));
        placeholderMap.put("dirty.snapshot", Lazy.by(() -> (Boolean)dirty.get() != false ? "-SNAPSHOT" : ""));
        Lazy<GitDescription> description = Lazy.by(gitSituation::getDescription);
        placeholderMap.put("describe", Lazy.by(() -> ((GitDescription)description.get()).toString()));
        Lazy<String> descriptionTag = Lazy.by(() -> ((GitDescription)description.get()).getTag());
        placeholderMap.put("describe.tag", descriptionTag);
        placeholderMap.put("describe.distance", Lazy.by(() -> String.valueOf(((GitDescription)description.get()).getDistance())));
        Lazy<Map> describeTagPatternValues = Lazy.by(() -> StringUtil.patternGroupValues(gitSituation.getDescribeTagPattern(), (String)descriptionTag.get()));
        for (String string : StringUtil.patternGroups(gitSituation.getDescribeTagPattern())) {
            Lazy<String> value3 = Lazy.by(() -> (String)((Map)describeTagPatternValues.get()).get(groupName));
            placeholderMap.put("describe.tag." + string, value3);
            placeholderMap.put("describe.tag." + string + ".slug", Lazy.by(() -> GitVersioningModelProcessor.slugify((String)value3.get())));
        }
        for (Map.Entry entry : mavenSession.getUserProperties().entrySet()) {
            if (entry.getValue() == null) continue;
            placeholderMap.put("property." + entry.getKey(), () -> property.getValue().toString());
        }
        System.getenv().forEach((key, value) -> placeholderMap.put("env." + key, () -> value));
        return placeholderMap;
    }

    private static Map<String, String> generateGitProjectProperties(GitSituation gitSituation, GitVersionDetails gitVersionDetails) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("git.commit", gitVersionDetails.getCommit());
        properties.put("git.commit.short", gitVersionDetails.getCommit().substring(0, 7));
        ZonedDateTime headCommitDateTime = gitSituation.getTimestamp();
        properties.put("git.commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        properties.put("git.commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ISO_INSTANT) : "0000-00-00T00:00:00Z");
        String refName = gitVersionDetails.getRefName();
        String refNameSlug = GitVersioningModelProcessor.slugify(refName);
        properties.put(OPTION_NAME_GIT_REF, refName);
        properties.put("git.ref.slug", refNameSlug);
        return properties;
    }

    private static File findMvnDirectory(File baseDirectory) throws IOException {
        for (File searchDirectory = baseDirectory; searchDirectory != null; searchDirectory = searchDirectory.getParentFile()) {
            File mvnDir = new File(searchDirectory, ".mvn");
            if (!mvnDir.exists()) continue;
            return mvnDir;
        }
        throw new FileNotFoundException("Can not find .mvn directory in hierarchy of " + baseDirectory);
    }

    private static Configuration readConfig(File configFile) throws IOException {
        XmlMapper xmlMapper = new XmlMapper();
        xmlMapper.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        Configuration config = (Configuration)xmlMapper.readValue(configFile, Configuration.class);
        ArrayList<Configuration.RefPatchDescription> patchDescriptions = new ArrayList<Configuration.RefPatchDescription>(config.refs.list);
        if (config.rev != null) {
            patchDescriptions.add((Configuration.RefPatchDescription)config.rev);
        }
        for (Configuration.PatchDescription patchDescription : patchDescriptions) {
            if (patchDescription.describeTagPattern == null) {
                patchDescription.describeTagPattern = config.describeTagPattern;
            }
            if (patchDescription.updatePom != null) continue;
            patchDescription.updatePom = config.updatePom;
        }
        return config;
    }

    private String getCommandOption(String name) {
        String value = this.mavenSession.getUserProperties().getProperty(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    private boolean getUpdatePomOption(Configuration.PatchDescription gitRefConfig) {
        String updatePomCommandOption = this.getCommandOption(OPTION_UPDATE_POM);
        if (updatePomCommandOption != null) {
            return Boolean.parseBoolean(updatePomCommandOption);
        }
        if (gitRefConfig.updatePom != null) {
            return gitRefConfig.updatePom;
        }
        return false;
    }

    private Set<GAV> determineRelatedProjects(Model projectModel) throws IOException {
        HashSet<GAV> relatedProjects = new HashSet<GAV>();
        this.determineRelatedProjects(projectModel, relatedProjects);
        return relatedProjects;
    }

    private void determineRelatedProjects(Model projectModel, Set<GAV> relatedProjects) throws IOException {
        Model parentProjectModel;
        GAV projectGAV = GAV.of(projectModel);
        if (relatedProjects.contains(projectGAV)) {
            return;
        }
        relatedProjects.add(projectGAV);
        if (projectModel.getParent() != null) {
            Model parentProjectModel2;
            GAV parentProjectGAV;
            GAV parentGAV = GAV.of(projectModel.getParent());
            File parentProjectPomFile = GitVersioningModelProcessor.getParentProjectPomFile(projectModel);
            if (this.isRelatedPom(parentProjectPomFile) && (parentProjectGAV = GAV.of(parentProjectModel2 = MavenUtil.readModel(parentProjectPomFile))).equals(parentGAV)) {
                this.determineRelatedProjects(parentProjectModel2, relatedProjects);
            }
        }
        if ((parentProjectModel = this.searchParentProjectInParentDirectory(projectModel)) != null) {
            this.determineRelatedProjects(parentProjectModel, relatedProjects);
        }
        for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(projectModel)) {
            Model moduleProjectModel = MavenUtil.readModel(modulePomFile);
            this.determineRelatedProjects(moduleProjectModel, relatedProjects);
        }
    }

    private boolean isRelatedPom(File pomFile) throws IOException {
        return pomFile != null && pomFile.exists() && pomFile.isFile() && pomFile.getName().endsWith(".xml") && pomFile.getCanonicalPath().startsWith(this.mvnDirectory.getParentFile().getCanonicalPath() + File.separator) && pomFile.getCanonicalPath().startsWith(this.gitSituation.getRootDirectory().getCanonicalPath() + File.separator);
    }

    private Model searchParentProjectInParentDirectory(Model projectModel) throws IOException {
        File parentDirectoryPomFile = MavenUtil.pomFile(projectModel.getProjectDirectory().getParentFile(), "pom.xml");
        if (parentDirectoryPomFile.exists() && this.isRelatedPom(parentDirectoryPomFile)) {
            Model parentDirectoryProjectModel = MavenUtil.readModel(parentDirectoryPomFile);
            for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(parentDirectoryProjectModel)) {
                if (!modulePomFile.getCanonicalFile().equals(projectModel.getPomFile().getCanonicalFile())) continue;
                return parentDirectoryProjectModel;
            }
        }
        return null;
    }

    private static File getParentProjectPomFile(Model projectModel) {
        if (projectModel.getParent() == null) {
            return null;
        }
        File parentProjectPomFile = MavenUtil.pomFile(projectModel.getProjectDirectory(), projectModel.getParent().getRelativePath());
        if (parentProjectPomFile.exists()) {
            return parentProjectPomFile;
        }
        return null;
    }

    private static Set<File> getProjectModules(Model projectModel) {
        HashSet<File> modules = new HashSet<File>();
        for (String module : projectModel.getModules()) {
            modules.add(MavenUtil.pomFile(projectModel.getProjectDirectory(), module));
        }
        for (Profile profile : projectModel.getProfiles()) {
            for (String module : profile.getModules()) {
                modules.add(MavenUtil.pomFile(projectModel.getProjectDirectory(), module));
            }
        }
        return modules.stream().filter(File::exists).collect(Collectors.toSet());
    }

    private File writePomFile(Model projectModel) throws IOException {
        File gitVersionedPomFile = new File(projectModel.getProjectDirectory(), GIT_VERSIONING_POM_NAME);
        this.logger.debug("generate " + gitVersionedPomFile);
        Document gitVersionedPomDocument = MavenUtil.readXml(projectModel.getPomFile());
        Element projectElement = gitVersionedPomDocument.getChild("project");
        GitVersioningModelProcessor.updateParentVersion(projectElement, projectModel.getParent());
        GitVersioningModelProcessor.updateVersion(projectElement, projectModel);
        this.updatePropertyValues(projectElement, (ModelBase)projectModel);
        GitVersioningModelProcessor.updateDependencyVersions(projectElement, (ModelBase)projectModel);
        GitVersioningModelProcessor.updatePluginVersions(projectElement, (BuildBase)projectModel.getBuild(), projectModel.getReporting());
        this.updateProfiles(projectElement, projectModel.getProfiles());
        MavenUtil.writeXml(gitVersionedPomFile, gitVersionedPomDocument);
        return gitVersionedPomFile;
    }

    private static void updateParentVersion(Element projectElement, Parent parent) {
        Element parentElement = projectElement.getChild("parent");
        if (parentElement != null) {
            Element parentVersionElement = parentElement.getChild("version");
            parentVersionElement.setText(parent.getVersion());
        }
    }

    private static void updateVersion(Element projectElement, Model projectModel) {
        Element versionElement = projectElement.getChild("version");
        if (versionElement != null) {
            versionElement.setText(projectModel.getVersion());
        }
    }

    private void updatePropertyValues(Element element, ModelBase model) {
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null) {
            Properties modelProperties = model.getProperties();
            this.gitVersionDetails.getPatchDescription().properties.keySet().forEach(propertyName -> {
                Element propertyElement = propertiesElement.getChild(propertyName);
                if (propertyElement != null) {
                    String pomPropertyValue = propertyElement.getText();
                    String modelPropertyValue = (String)modelProperties.get(propertyName);
                    if (!Objects.equals(modelPropertyValue, pomPropertyValue)) {
                        propertyElement.setText(modelPropertyValue);
                    }
                }
            });
        }
    }

    private static void updateDependencyVersions(Element element, ModelBase model) {
        Element dependenciesElement;
        Element dependencyManagementElement;
        Element dependenciesElement2 = element.getChild("dependencies");
        if (dependenciesElement2 != null) {
            GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement2, model.getDependencies());
        }
        if ((dependencyManagementElement = element.getChild("dependencyManagement")) != null && (dependenciesElement = dependencyManagementElement.getChild("dependencies")) != null) {
            GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement, model.getDependencyManagement().getDependencies());
        }
    }

    private static void updateDependencyVersions(Element dependenciesElement, List<Dependency> dependencies) {
        GitVersioningModelProcessor.forEachPair(dependenciesElement.getChildren(), dependencies, (dependencyElement, dependency) -> {
            if (!Objects.equals(dependency.getManagementKey(), GitVersioningModelProcessor.getDependencyManagementKey(dependencyElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model dependencies order");
            }
            Element dependencyVersionElement = dependencyElement.getChild("version");
            if (dependencyVersionElement != null) {
                dependencyVersionElement.setText(dependency.getVersion());
            }
        });
    }

    private static String getDependencyManagementKey(Element element) {
        Element groupId = element.getChild("groupId");
        Element artifactId = element.getChild("artifactId");
        Element type = element.getChild("type");
        Element classifier = element.getChild("classifier");
        return (groupId != null ? groupId.getText().trim() : "") + ":" + (artifactId != null ? artifactId.getText().trim() : "") + ":" + (type != null ? type.getText().trim() : "jar") + (classifier != null ? ":" + classifier.getText().trim() : "");
    }

    private static void updatePluginVersions(Element projectElement, BuildBase build, Reporting reporting) {
        Element reportingElement;
        Element pluginsElement;
        Element buildElement = projectElement.getChild("build");
        if (buildElement != null) {
            Element pluginsManagementElement;
            Element pluginsElement2 = buildElement.getChild("plugins");
            if (pluginsElement2 != null) {
                GitVersioningModelProcessor.updatePluginVersions(pluginsElement2, build.getPlugins());
            }
            if ((pluginsManagementElement = buildElement.getChild("pluginsManagement")) != null && (pluginsElement = pluginsManagementElement.getChild("plugins")) != null) {
                GitVersioningModelProcessor.updatePluginVersions(pluginsElement, build.getPluginManagement().getPlugins());
            }
        }
        if ((reportingElement = projectElement.getChild("reporting")) != null && (pluginsElement = reportingElement.getChild("plugins")) != null) {
            GitVersioningModelProcessor.updateReportPluginVersions(pluginsElement, reporting.getPlugins());
        }
    }

    private static void updatePluginVersions(Element pluginsElement, List<Plugin> plugins) {
        GitVersioningModelProcessor.forEachPair(pluginsElement.getChildren(), plugins, (pluginElement, plugin) -> {
            if (!Objects.equals(plugin.getKey(), GitVersioningModelProcessor.getPluginKey(pluginElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model plugin order");
            }
            Element pluginVersionElement = pluginElement.getChild("version");
            if (pluginVersionElement != null) {
                pluginVersionElement.setText(plugin.getVersion());
            }
        });
    }

    private static void updateReportPluginVersions(Element pluginsElement, List<ReportPlugin> plugins) {
        GitVersioningModelProcessor.forEachPair(pluginsElement.getChildren(), plugins, (pluginElement, plugin) -> {
            if (!Objects.equals(plugin.getKey(), GitVersioningModelProcessor.getPluginKey(pluginElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model plugin order");
            }
            Element pluginVersionElement = pluginElement.getChild("version");
            if (pluginVersionElement != null) {
                pluginVersionElement.setText(plugin.getVersion());
            }
        });
    }

    private static String getPluginKey(Element element) {
        Element groupId = element.getChild("groupId");
        Element artifactId = element.getChild("artifactId");
        return (groupId != null ? groupId.getText().trim() : "org.apache.maven.plugins") + ":" + (artifactId != null ? artifactId.getText().trim() : "");
    }

    private void updateProfiles(Element projectElement, List<Profile> profiles) {
        Element profilesElement = projectElement.getChild("profiles");
        if (profilesElement != null) {
            Map<String, Profile> profileMap = profiles.stream().collect(Collectors.toMap(Profile::getId, it -> it));
            for (Element profileElement : profilesElement.getChildren("profile")) {
                Profile profile = profileMap.get(profileElement.getChild("id").getText());
                this.updatePropertyValues(profileElement, (ModelBase)profile);
                GitVersioningModelProcessor.updateDependencyVersions(profileElement, (ModelBase)profile);
                GitVersioningModelProcessor.updatePluginVersions(profileElement, profile.getBuild(), profile.getReporting());
            }
        }
    }

    private static String extensionLogHeader(GAV extensionGAV) {
        String extension = extensionGAV.toString();
        String metaInfo = "[core extension]";
        String plainLog = extension + " " + metaInfo;
        String formattedLog = MessageUtils.buffer().a((CharSequence)" ").mojo((Object)extension).a((CharSequence)" ").strong((Object)metaInfo).a((CharSequence)" ").toString();
        return GitVersioningModelProcessor.padLogHeaderPadding(plainLog, formattedLog);
    }

    private static String padLogHeaderPadding(String plainLog, String formattedLog) {
        String pad = "-";
        int padding = Math.max(6, 70 - plainLog.length());
        int paddingLeft = (int)Math.floor((double)padding / 2.0);
        int paddingRight = (int)Math.ceil((double)padding / 2.0);
        return MessageUtils.buffer().strong((Object)StringUtils.repeat((String)pad, (int)paddingLeft)).a((CharSequence)formattedLog).strong((Object)StringUtils.repeat((String)pad, (int)paddingRight)).toString();
    }

    private static String projectLogHeader(GAV projectGAV) {
        String project = projectGAV.getProjectId();
        return MessageUtils.buffer().project((Object)project).toString();
    }

    private static String sectionLogHeader(String title, ModelBase model) {
        String header = title + ":";
        if (model instanceof Profile) {
            header = MessageUtils.buffer().strong((Object)("profile " + ((Profile)model).getId() + " ")) + header;
        }
        return header;
    }

    private static String slugify(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("/", "-");
    }

    public static <T1, T2> void forEachPair(Collection<T1> collection1, Collection<T2> collection2, BiConsumer<T1, T2> consumer) {
        if (collection1.size() != collection2.size()) {
            throw new IllegalArgumentException("Collections sizes are not equals");
        }
        Iterator<T1> iter1 = collection1.iterator();
        Iterator<T2> iter2 = collection2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            consumer.accept(iter1.next(), iter2.next());
        }
    }
}

