/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.maven.gitversioning;

import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.inject.Key;
import com.google.inject.OutOfScopeException;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.GitRefType;
import me.qoomon.gitversioning.commons.GitSituation;
import me.qoomon.gitversioning.commons.Lazy;
import me.qoomon.gitversioning.commons.StringUtil;
import me.qoomon.maven.gitversioning.BuildProperties;
import me.qoomon.maven.gitversioning.Configuration;
import me.qoomon.maven.gitversioning.GAV;
import me.qoomon.maven.gitversioning.GitVersionDetails;
import me.qoomon.maven.gitversioning.GitVersioningMojo;
import me.qoomon.maven.gitversioning.MavenUtil;
import org.apache.maven.building.Source;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.BuildBase;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.ModelBase;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.model.Profile;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.session.scope.internal.SessionScope;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="core-default")
@Singleton
public class GitVersioningModelProcessor
implements ModelProcessor {
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*?(?<version>(?<core>(?<major>\\d+)(?:\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?)?)(?:-(?<label>.*))?)|");
    private static final String OPTION_NAME_GIT_REF = "git.ref";
    private static final String OPTION_NAME_GIT_TAG = "git.tag";
    private static final String OPTION_NAME_GIT_BRANCH = "git.branch";
    private static final String OPTION_NAME_DISABLE = "versioning.disable";
    private static final String OPTION_UPDATE_POM = "versioning.updatePom";
    static final String GIT_VERSIONING_POM_NAME = ".git-versioned-pom.xml";
    private final Logger logger = LoggerFactory.getLogger(GitVersioningModelProcessor.class);
    private ModelProcessor delegatedModelProcessor;
    @Inject
    private SessionScope sessionScope;
    private boolean initialized = false;
    private Configuration config;
    private MavenSession mavenSession;
    private File mvnDirectory;
    private GitSituation gitSituation;
    private boolean disabled = false;
    private GitVersionDetails gitVersionDetails;
    boolean updatePom = false;
    private Map<String, Supplier<String>> globalFormatPlaceholderMap;
    private Set<GAV> relatedProjects;
    private final Map<File, Model> sessionModelCache = new HashMap<File, Model>();

    @Inject
    void setDelegatedModelProcessor(List<ModelProcessor> modelProcessors) {
        this.delegatedModelProcessor = modelProcessors.stream().filter(modelProcessor -> !Objects.equals(modelProcessor, this)).findFirst().orElseThrow(() -> new NoSuchElementException("Unable to find default ModelProcessor"));
        this.logger.debug("Delegated ModelProcessor: {}", (Object)this.delegatedModelProcessor);
    }

    public File locatePom(File projectDirectory) {
        return this.delegatedModelProcessor.locatePom(projectDirectory);
    }

    public Model read(File input, Map<String, ?> options) throws IOException {
        return this.processModel(this.delegatedModelProcessor.read(input, options), options).clone();
    }

    public Model read(Reader input, Map<String, ?> options) throws IOException {
        return this.processModel(this.delegatedModelProcessor.read(input, options), options).clone();
    }

    public Model read(InputStream input, Map<String, ?> options) throws IOException {
        return this.processModel(this.delegatedModelProcessor.read(input, options), options).clone();
    }

    private void init(Model projectModel) throws IOException {
        File pomFile;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("");
            this.logger.info(GitVersioningModelProcessor.extensionLogHeader(BuildProperties.projectGAV()));
        }
        if ((pomFile = this.locatePom(projectModel.getProjectDirectory())) == null) {
            this.logger.debug("skip - project model does not belong to a local project");
            this.disabled = true;
            return;
        }
        if (!pomFile.isFile()) {
            this.logger.debug("skip - pom file does not exist {}", (Object)pomFile);
            this.disabled = true;
            return;
        }
        try {
            this.mavenSession = (MavenSession)this.sessionScope.scope(Key.get(MavenSession.class), null).get();
        }
        catch (OutOfScopeException ex) {
            this.logger.warn("skip - no maven session present");
            this.disabled = true;
            return;
        }
        this.logger.debug("pom file: {}", (Object)pomFile);
        this.mvnDirectory = GitVersioningModelProcessor.findMvnDirectory(pomFile);
        this.logger.debug(".mvn directory: {}", (Object)this.mvnDirectory);
        File configFile = new File(this.mvnDirectory, BuildProperties.projectArtifactId() + ".xml");
        this.logger.debug("read config from {}", (Object)configFile);
        this.config = GitVersioningModelProcessor.readConfig(configFile);
        String commandOptionDisable = this.getCommandOption(OPTION_NAME_DISABLE);
        if (commandOptionDisable != null) {
            this.disabled = Boolean.parseBoolean(commandOptionDisable);
            if (this.disabled) {
                this.logger.info("skip - versioning is disabled by command option");
                return;
            }
        } else {
            boolean bl = this.disabled = this.config.disable != null && this.config.disable != false;
            if (this.disabled) {
                this.logger.info("skip - versioning is disabled by config option");
                return;
            }
        }
        this.gitSituation = this.getGitSituation(pomFile);
        if (this.gitSituation == null) {
            this.logger.warn("skip - project is not part of a git repository");
            this.disabled = true;
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("git situation:");
            this.logger.debug("  root directory: {}", (Object)this.gitSituation.getRootDirectory());
            this.logger.debug("  head commit: {}", (Object)this.gitSituation.getRev());
            this.logger.debug("  head commit timestamp: {}", (Object)this.gitSituation.getTimestamp());
            this.logger.debug("  head branch: {}", (Object)this.gitSituation.getBranch());
            this.logger.debug("  head tags: {}", this.gitSituation.getTags());
            this.logger.debug("  head description: {}", (Object)this.gitSituation.getDescription());
        }
        this.gitVersionDetails = GitVersioningModelProcessor.getGitVersionDetails(this.gitSituation, this.config);
        if (this.gitVersionDetails == null) {
            this.logger.warn("skip - no matching <ref> configuration and no <rev> configuration defined");
            this.logger.warn("git refs:");
            this.logger.warn("  branch: {}", (Object)this.gitSituation.getBranch());
            this.logger.warn("  tags: {}", this.gitSituation.getTags());
            this.logger.warn("defined ref configurations:");
            this.config.refs.list.forEach(ref -> this.logger.warn("  {} - pattern: {}", (Object)StringUtils.rightPad((String)ref.type.name(), (int)6), (Object)ref.pattern));
            this.disabled = true;
            return;
        }
        this.logger.info("matching ref: {} - {}", (Object)this.gitVersionDetails.getRefType().name(), (Object)this.gitVersionDetails.getRefName());
        Configuration.RefPatchDescription patchDescription = this.gitVersionDetails.getPatchDescription();
        this.logger.info("ref configuration: {} - pattern: {}", (Object)this.gitVersionDetails.getRefType().name(), (Object)patchDescription.pattern);
        if (patchDescription.describeTagPattern != null && !patchDescription.describeTagPattern.equals(".*")) {
            this.logger.info("  describeTagPattern: {}", (Object)patchDescription.describeTagPattern);
            this.gitSituation.setDescribeTagPattern(patchDescription.describeTagPattern());
        }
        if (patchDescription.describeTagFirstParent != null) {
            this.logger.info("  describeTagFirstParent: {}", (Object)patchDescription.describeTagFirstParent);
            this.gitSituation.setFirstParent(patchDescription.describeTagFirstParent);
        }
        if (patchDescription.version != null) {
            this.logger.info("  version: {}", (Object)patchDescription.version);
        }
        if (!patchDescription.properties.isEmpty()) {
            this.logger.info("  properties: ");
            patchDescription.properties.forEach((key, value) -> this.logger.info("    {} - {}", key, value));
        }
        this.globalFormatPlaceholderMap = this.generateGlobalFormatPlaceholderMap(this.gitSituation, this.gitVersionDetails, this.mavenSession);
        if (!patchDescription.userProperties.isEmpty()) {
            this.logger.info("  userProperties: ");
            String projectVersion = GAV.of(projectModel).getVersion();
            patchDescription.userProperties.forEach((key, value) -> {
                this.logger.info("    {} - {}", key, value);
                this.mavenSession.getUserProperties().put(key, this.getGitPropertyValue((String)value, "", projectVersion));
            });
        }
        this.updatePom = this.getUpdatePomOption(patchDescription);
        if (this.updatePom) {
            this.logger.info("  updatePom: {}", (Object)this.updatePom);
        }
        this.relatedProjects = this.determineRelatedProjects(projectModel);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(MessageUtils.buffer().strong((Object)"related projects:").toString());
            this.relatedProjects.forEach(gav -> this.logger.debug("  {}", gav));
        }
        this.logger.info("");
    }

    public Model processModel(Model projectModel, Map<String, ?> options) throws IOException {
        Source pomSource = (Source)options.get("org.apache.maven.model.building.source");
        if (pomSource == null) {
            this.logger.debug("skip model - no project model pom file");
            return projectModel;
        }
        projectModel.setPomFile(new File(pomSource.getLocation()));
        if (!this.initialized) {
            this.init(projectModel);
            this.initialized = true;
        }
        if (this.disabled) {
            return projectModel;
        }
        GAV projectGAV = GAV.of(projectModel);
        if (projectGAV.getVersion() == null) {
            this.logger.debug("skip model - can not determine project version - {}", (Object)projectModel.getPomFile());
            return projectModel;
        }
        if (!this.isRelatedProject(projectGAV)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("skip model - unrelated project - {}", (Object)projectModel.getPomFile());
            }
            return projectModel;
        }
        File canonicalProjectPomFile = projectModel.getPomFile().getCanonicalFile();
        Model cachedProjectModel = this.sessionModelCache.get(canonicalProjectPomFile);
        if (cachedProjectModel != null) {
            return cachedProjectModel;
        }
        this.sessionModelCache.put(canonicalProjectPomFile, projectModel);
        if (this.logger.isInfoEnabled()) {
            this.logger.info(GitVersioningModelProcessor.projectLogHeader(projectGAV));
        }
        this.updateModel(projectModel, this.gitVersionDetails.getPatchDescription());
        File gitVersionedPomFile = this.writePomFile(projectModel);
        if (this.updatePom) {
            this.logger.debug("updating original POM file");
            Files.copy(gitVersionedPomFile.toPath(), this.locatePom(projectModel.getProjectDirectory()).toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        this.addBuildPlugin(projectModel);
        this.logger.info("");
        return projectModel;
    }

    private void updateModel(Model projectModel, Configuration.RefPatchDescription patchDescription) {
        Map propertyFormats;
        GAV originalProjectGAV = GAV.of(projectModel);
        String versionFormat = patchDescription.version;
        if (versionFormat != null) {
            this.updateParentVersion(projectModel, versionFormat);
            this.updateVersion(projectModel, versionFormat);
            this.updateDependencyVersions((ModelBase)projectModel, versionFormat);
            this.updatePluginVersions((ModelBase)projectModel, versionFormat);
        }
        if ((propertyFormats = patchDescription.properties) != null) {
            this.updatePropertyValues((ModelBase)projectModel, propertyFormats, originalProjectGAV);
        }
        this.addProjectProperties(projectModel);
        this.updateProfiles(projectModel, patchDescription, originalProjectGAV);
    }

    private void updateProfiles(Model model, Configuration.RefPatchDescription patchDescription, GAV originalProjectGAV) {
        List profiles = model.getProfiles();
        if (!profiles.isEmpty()) {
            for (Profile profile : profiles) {
                Map propertyFormats;
                String version = patchDescription.version;
                if (version != null) {
                    this.updateDependencyVersions((ModelBase)profile, version);
                    this.updatePluginVersions((ModelBase)profile, version);
                }
                if ((propertyFormats = patchDescription.properties) == null || propertyFormats.isEmpty()) continue;
                this.updatePropertyValues((ModelBase)profile, propertyFormats, originalProjectGAV);
            }
        }
    }

    private void updateParentVersion(Model projectModel, String versionFormat) {
        GAV parentGAV;
        Parent parent = projectModel.getParent();
        if (parent != null && this.isRelatedProject(parentGAV = GAV.of(parent))) {
            String gitVersion = this.getGitVersion(versionFormat, parentGAV.getVersion());
            this.logger.debug("set parent version to {} ({})", (Object)gitVersion, (Object)parentGAV);
            parent.setVersion(gitVersion);
        }
    }

    private void updateVersion(Model projectModel, String versionFormat) {
        if (projectModel.getVersion() != null) {
            GAV projectGAV = GAV.of(projectModel);
            String gitVersion = this.getGitVersion(versionFormat, projectGAV.getVersion());
            this.logger.info("set version to {}", (Object)gitVersion);
            projectModel.setVersion(gitVersion);
        }
    }

    private void updatePropertyValues(ModelBase model, Map<String, String> propertyFormats, GAV originalProjectGAV) {
        if (propertyFormats.isEmpty()) {
            return;
        }
        model.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(modelPropertyName, modelPropertyValue) -> {
            String gitPropertyValue;
            String propertyFormat = (String)propertyFormats.get((String)modelPropertyName);
            if (propertyFormat != null && !(gitPropertyValue = this.getGitPropertyValue(propertyFormat, (String)modelPropertyValue, originalProjectGAV.getVersion())).equals(modelPropertyValue)) {
                this.logger.info("set property {} to {}", modelPropertyName, (Object)gitPropertyValue);
                model.addProperty((String)modelPropertyName, gitPropertyValue);
            }
        }));
    }

    private void updatePluginVersions(ModelBase model, String versionFormat) {
        List<ReportPlugin> list;
        Reporting reporting;
        BuildBase build = MavenUtil.getBuild(model);
        if (build == null) {
            return;
        }
        List<Plugin> relatedPlugins2 = this.filterRelatedPlugins(build.getPlugins());
        if (!relatedPlugins2.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("plugins", model));
            }
            for (Plugin plugin : relatedPlugins2) {
                this.updateVersion(plugin, versionFormat);
            }
        }
        this.updatePluginDependencyVersions(model, versionFormat, build.getPlugins());
        PluginManagement pluginManagement = build.getPluginManagement();
        if (pluginManagement != null) {
            List<Plugin> relatedPlugins3 = this.filterRelatedPlugins(pluginManagement.getPlugins());
            if (!relatedPlugins3.isEmpty()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("plugin management", model));
                }
                for (Plugin plugin : relatedPlugins3) {
                    this.updateVersion(plugin, versionFormat);
                }
            }
            this.updatePluginDependencyVersions(model, versionFormat, pluginManagement.getPlugins());
        }
        if ((reporting = model.getReporting()) != null && !(list = this.filterRelatedReportPlugins(reporting.getPlugins())).isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("reporting plugins", model));
            }
            for (ReportPlugin plugin : list) {
                this.updateVersion(plugin, versionFormat);
            }
        }
    }

    private void updatePluginDependencyVersions(ModelBase model, String versionFormat, List<Plugin> plugins) {
        List<Dependency> pluginDepsList = this.filterRelatedDependencies(plugins.stream().map(Plugin::getDependencies).flatMap(Collection::stream).collect(Collectors.toList()));
        if (!pluginDepsList.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("plugins dependencies", model));
            }
            for (Dependency dep : pluginDepsList) {
                this.updateVersion(dep, versionFormat);
            }
        }
    }

    private void updateVersion(Plugin plugin, String versionFormat) {
        if (plugin.getVersion() != null) {
            GAV pluginGAV = GAV.of(plugin);
            String gitVersion = this.getGitVersion(versionFormat, pluginGAV.getVersion());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}: set version to {}", (Object)pluginGAV.getProjectId(), (Object)gitVersion);
            }
            plugin.setVersion(gitVersion);
        }
    }

    private void updateVersion(ReportPlugin plugin, String versionFormat) {
        if (plugin.getVersion() != null) {
            GAV pluginGAV = GAV.of(plugin);
            String gitVersion = this.getGitVersion(versionFormat, pluginGAV.getVersion());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}: set version to {}", (Object)pluginGAV.getProjectId(), (Object)gitVersion);
            }
            plugin.setVersion(gitVersion);
        }
    }

    private List<Plugin> filterRelatedPlugins(List<Plugin> plugins) {
        return plugins.stream().filter(it -> this.isRelatedProject(GAV.of(it))).collect(Collectors.toList());
    }

    private List<ReportPlugin> filterRelatedReportPlugins(List<ReportPlugin> plugins) {
        return plugins.stream().filter(it -> this.isRelatedProject(GAV.of(it))).collect(Collectors.toList());
    }

    private void updateDependencyVersions(ModelBase model, String versionFormat) {
        List<Dependency> relatedDependencies;
        DependencyManagement dependencyManagement;
        List<Dependency> relatedDependencies2 = this.filterRelatedDependencies(model.getDependencies());
        if (!relatedDependencies2.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("dependencies", model));
            }
            for (Dependency dependency : relatedDependencies2) {
                this.updateVersion(dependency, versionFormat);
            }
        }
        if ((dependencyManagement = model.getDependencyManagement()) != null && !(relatedDependencies = this.filterRelatedDependencies(dependencyManagement.getDependencies())).isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(GitVersioningModelProcessor.sectionLogHeader("dependency management", model));
            }
            for (Dependency dependency : relatedDependencies) {
                this.updateVersion(dependency, versionFormat);
            }
        }
    }

    private void updateVersion(Dependency dependency, String versionFormat) {
        if (dependency.getVersion() != null) {
            GAV dependencyGAV = GAV.of(dependency);
            String gitVersion = this.getGitVersion(versionFormat, dependencyGAV.getVersion());
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{}: set version to {}", (Object)dependencyGAV.getProjectId(), (Object)gitVersion);
            }
            dependency.setVersion(gitVersion);
        }
    }

    public List<Dependency> filterRelatedDependencies(List<Dependency> dependencies) {
        return dependencies.stream().filter(it -> this.isRelatedProject(GAV.of(it))).collect(Collectors.toList());
    }

    private void addProjectProperties(Model projectModel) {
        Properties projectProperties = projectModel.getProperties();
        if (!projectProperties.contains("git.worktree")) {
            projectModel.addProperty("git.worktree", this.gitSituation.getRootDirectory().getAbsolutePath());
        }
        if (!projectProperties.contains("git.commit")) {
            projectModel.addProperty("git.commit", this.gitVersionDetails.getCommit());
        }
        if (!projectProperties.contains("git.commit.short")) {
            projectModel.addProperty("git.commit.short", this.gitVersionDetails.getCommit().substring(0, 7));
        }
        ZonedDateTime headCommitDateTime = this.gitSituation.getTimestamp();
        if (!projectProperties.contains("git.commit.timestamp")) {
            projectModel.addProperty("git.commit.timestamp", String.valueOf(headCommitDateTime.toEpochSecond()));
        }
        if (!projectProperties.contains("git.commit.timestamp.datetime")) {
            projectModel.addProperty("git.commit.timestamp.datetime", headCommitDateTime.toEpochSecond() > 0L ? headCommitDateTime.format(DateTimeFormatter.ISO_INSTANT) : "0000-00-00T00:00:00Z");
        }
        String refName = this.gitVersionDetails.getRefName();
        if (!projectProperties.contains(OPTION_NAME_GIT_REF)) {
            projectModel.addProperty(OPTION_NAME_GIT_REF, refName);
        }
        if (!projectProperties.contains("git.ref.slug")) {
            projectModel.addProperty("git.ref.slug", GitVersioningModelProcessor.slugify(refName));
        }
    }

    private void addBuildPlugin(Model projectModel) {
        this.logger.debug("add version build plugin");
        Plugin gitVersioningPlugin = GitVersioningMojo.asPlugin();
        PluginExecution execution = new PluginExecution();
        execution.setId("git-versioning");
        execution.getGoals().add("git-versioning");
        gitVersioningPlugin.getExecutions().add(execution);
        if (projectModel.getBuild() == null) {
            projectModel.setBuild(new Build());
        }
        projectModel.getBuild().getPlugins().add(0, gitVersioningPlugin);
        LinkedList plugins = new LinkedList(projectModel.getBuild().getPlugins());
        if (projectModel.getBuild().getPluginManagement() != null) {
            plugins.addAll(projectModel.getBuild().getPluginManagement().getPlugins());
        }
        plugins.stream().filter(it -> it.getKey().equals("org.apache.maven.plugins:maven-enforcer-plugin")).forEach(plugin -> plugin.getExecutions().forEach(execution -> {
            Xpp3Dom requirePluginVersions;
            Xpp3Dom rules;
            Xpp3Dom configuration = (Xpp3Dom)execution.getConfiguration();
            if (configuration != null && (rules = configuration.getChild("rules")) != null && (requirePluginVersions = rules.getChild("requirePluginVersions")) != null) {
                Xpp3Dom unCheckedPluginList = requirePluginVersions.getChild("unCheckedPluginList");
                if (unCheckedPluginList == null) {
                    unCheckedPluginList = new Xpp3Dom("unCheckedPluginList");
                    requirePluginVersions.addChild(unCheckedPluginList);
                }
                unCheckedPluginList.setValue(gitVersioningPlugin.getKey() + "," + Objects.requireNonNullElse(unCheckedPluginList.getValue(), ""));
            }
        }));
    }

    private GitSituation getGitSituation(File pomFile) throws IOException {
        File baseDirectory = pomFile.getParentFile();
        FileRepositoryBuilder repositoryBuilder = (FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(baseDirectory);
        if (repositoryBuilder.getGitDir() == null) {
            return null;
        }
        final Repository repository = repositoryBuilder.build();
        return new GitSituation(repository){
            {
                super(repository3);
                this.handleEnvironment(repository);
            }

            private void handleEnvironment(Repository repository2) throws IOException {
                String commitTag;
                String commitBranch;
                String overrideBranch = GitVersioningModelProcessor.this.getCommandOption(GitVersioningModelProcessor.OPTION_NAME_GIT_BRANCH);
                String overrideTag = GitVersioningModelProcessor.this.getCommandOption(GitVersioningModelProcessor.OPTION_NAME_GIT_TAG);
                if (overrideBranch != null || overrideTag != null) {
                    overrideBranch = overrideBranch == null || overrideBranch.trim().isEmpty() ? null : overrideBranch.trim();
                    this.setBranch(overrideBranch);
                    overrideTag = overrideTag == null || overrideTag.trim().isEmpty() ? null : overrideTag.trim();
                    this.setTags(overrideTag == null ? Collections.emptyList() : Collections.singletonList(overrideTag));
                    return;
                }
                String providedRef = GitVersioningModelProcessor.this.getCommandOption(GitVersioningModelProcessor.OPTION_NAME_GIT_REF);
                if (providedRef != null) {
                    if (!providedRef.startsWith("refs/")) {
                        throw new IllegalArgumentException("invalid provided ref " + providedRef + " -  needs to start with refs/");
                    }
                    if (providedRef.startsWith("refs/tags/")) {
                        this.setBranch(null);
                        this.setTags(Collections.singletonList(providedRef));
                    } else {
                        this.setBranch(providedRef);
                        this.setTags(Collections.emptyList());
                    }
                    return;
                }
                if (repository2.getBranch() == null) {
                    return;
                }
                if ("true".equalsIgnoreCase(System.getenv("GITHUB_ACTIONS"))) {
                    if (!this.getRev().equals(System.getenv("GITHUB_SHA"))) {
                        return;
                    }
                    GitVersioningModelProcessor.this.logger.info("gather git situation from GitHub Actions environment variable: GITHUB_REF");
                    String githubRef = System.getenv("GITHUB_REF");
                    GitVersioningModelProcessor.this.logger.debug("  GITHUB_REF: {}", (Object)githubRef);
                    if (githubRef.startsWith("refs/tags/")) {
                        this.addTag(githubRef);
                    } else {
                        this.setBranch(githubRef);
                    }
                    return;
                }
                if ("true".equalsIgnoreCase(System.getenv("GITLAB_CI"))) {
                    if (!this.getRev().equals(System.getenv("CI_COMMIT_SHA"))) {
                        return;
                    }
                    GitVersioningModelProcessor.this.logger.info("gather git situation from GitLab CI environment variables: CI_COMMIT_BRANCH, CI_MERGE_REQUEST_SOURCE_BRANCH_NAME and CI_COMMIT_TAG");
                    commitBranch = System.getenv("CI_COMMIT_BRANCH");
                    commitTag = System.getenv("CI_COMMIT_TAG");
                    String mrSourceBranch = System.getenv("CI_MERGE_REQUEST_SOURCE_BRANCH_NAME");
                    GitVersioningModelProcessor.this.logger.debug("  CI_COMMIT_BRANCH: {}", (Object)commitBranch);
                    GitVersioningModelProcessor.this.logger.debug("  CI_COMMIT_TAG: {}", (Object)commitTag);
                    GitVersioningModelProcessor.this.logger.debug("  CI_MERGE_REQUEST_SOURCE_BRANCH_NAME: {}", (Object)mrSourceBranch);
                    if (commitBranch != null) {
                        this.setBranch(commitBranch);
                    } else if (mrSourceBranch != null) {
                        this.setBranch(mrSourceBranch);
                    } else if (commitTag != null) {
                        this.addTag(commitTag);
                    }
                    return;
                }
                if ("true".equalsIgnoreCase(System.getenv("CIRCLECI"))) {
                    if (!this.getRev().equals(System.getenv("CIRCLE_SHA1"))) {
                        return;
                    }
                    GitVersioningModelProcessor.this.logger.info("gather git situation from Circle CI environment variables: CIRCLE_BRANCH and CIRCLE_TAG");
                    commitBranch = System.getenv("CIRCLE_BRANCH");
                    commitTag = System.getenv("CIRCLE_TAG");
                    GitVersioningModelProcessor.this.logger.debug("  CIRCLE_BRANCH: {}", (Object)commitBranch);
                    GitVersioningModelProcessor.this.logger.debug("  CIRCLE_TAG: {}", (Object)commitTag);
                    if (commitBranch != null) {
                        this.setBranch(commitBranch);
                    } else if (commitTag != null) {
                        this.addTag(commitTag);
                    }
                    return;
                }
                if (System.getenv("JENKINS_HOME") != null && !System.getenv("JENKINS_HOME").trim().isEmpty()) {
                    if (!this.getRev().equals(System.getenv("GIT_COMMIT"))) {
                        return;
                    }
                    GitVersioningModelProcessor.this.logger.info("gather git situation from jenkins environment variables: BRANCH_NAME and TAG_NAME");
                    commitBranch = System.getenv("BRANCH_NAME");
                    commitTag = System.getenv("TAG_NAME");
                    GitVersioningModelProcessor.this.logger.debug("  BRANCH_NAME: {}", (Object)commitBranch);
                    GitVersioningModelProcessor.this.logger.debug("  TAG_NAME: {}", (Object)commitTag);
                    if (commitBranch != null) {
                        if (commitBranch.equals(commitTag)) {
                            this.addTag(commitBranch);
                        } else {
                            this.setBranch(commitBranch);
                        }
                    } else if (commitTag != null) {
                        this.addTag(commitTag);
                    }
                    return;
                }
            }

            @Override
            protected void setBranch(String branch) {
                GitVersioningModelProcessor.this.logger.debug("override git branch with {}", (Object)branch);
                super.setBranch(branch);
            }

            @Override
            protected void setTags(List<String> tags) {
                GitVersioningModelProcessor.this.logger.debug("override git tags with single tag {}", tags);
                super.setTags(tags);
            }

            @Override
            protected void addTag(String tag) {
                GitVersioningModelProcessor.this.logger.debug("add git tag {}", (Object)tag);
                super.addTag(tag);
            }
        };
    }

    private static GitVersionDetails getGitVersionDetails(GitSituation gitSituation, Configuration config) {
        Lazy<List> sortedTags = Lazy.by(gitSituation::getTags);
        block4: for (Configuration.RefPatchDescription refConfig : config.refs.list) {
            switch (refConfig.type) {
                case TAG: {
                    if (!gitSituation.isDetached() && !config.refs.considerTagsOnBranches.booleanValue()) continue block4;
                    for (String tag : sortedTags.get()) {
                        if (refConfig.pattern != null && !refConfig.pattern().matcher(tag).matches()) continue;
                        return new GitVersionDetails(gitSituation.getRev(), GitRefType.TAG, tag, refConfig);
                    }
                    continue block4;
                }
                case BRANCH: {
                    if (gitSituation.isDetached()) continue block4;
                    String branch = gitSituation.getBranch();
                    if (refConfig.pattern != null && !refConfig.pattern().matcher(branch).matches()) continue block4;
                    return new GitVersionDetails(gitSituation.getRev(), GitRefType.BRANCH, branch, refConfig);
                }
                default: {
                    throw new IllegalArgumentException("Unexpected ref type: " + refConfig.type);
                }
            }
        }
        if (config.rev != null) {
            return new GitVersionDetails(gitSituation.getRev(), GitRefType.COMMIT, gitSituation.getRev(), new Configuration.RefPatchDescription(GitRefType.COMMIT, null, config.rev));
        }
        return null;
    }

    private String getGitVersion(String versionFormat, String projectVersion) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(projectVersion);
        return GitVersioningModelProcessor.slugify(StringUtil.substituteText(versionFormat, placeholderMap));
    }

    private String getGitPropertyValue(String propertyFormat, String originalValue, String projectVersion) {
        Map<String, Supplier<String>> placeholderMap = this.generateFormatPlaceholderMap(projectVersion);
        placeholderMap.put("value", () -> originalValue);
        return StringUtil.substituteText(propertyFormat, placeholderMap);
    }

    private Map<String, Supplier<String>> generateFormatPlaceholderMap(String projectVersion) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>(this.globalFormatPlaceholderMap);
        placeholderMap.put("version", Lazy.of(projectVersion));
        Lazy<Matcher> versionComponents = Lazy.by(() -> this.matchVersion(projectVersion));
        placeholderMap.put("version.core", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)versionComponents.get()).group("core"), "0.0.0")));
        placeholderMap.put("version.major", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)versionComponents.get()).group("major"), "0")));
        placeholderMap.put("version.major.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("version.major")).get(), 1L)));
        placeholderMap.put("version.minor", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)versionComponents.get()).group("minor"), "0")));
        placeholderMap.put("version.minor.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("version.minor")).get(), 1L)));
        placeholderMap.put("version.patch", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)versionComponents.get()).group("patch"), "0")));
        placeholderMap.put("version.patch.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("version.patch")).get(), 1L)));
        placeholderMap.put("version.label", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)versionComponents.get()).group("label"), "")));
        placeholderMap.put("version.label.prefixed", Lazy.by(() -> {
            String label = (String)((Supplier)placeholderMap.get("version.label")).get();
            return !label.isEmpty() ? "-" + label : "";
        }));
        placeholderMap.put("version.release", Lazy.by(() -> projectVersion.replaceFirst("-.*$", "")));
        Pattern projectVersionPattern = this.config.projectVersionPattern();
        if (projectVersionPattern != null) {
            for (Map.Entry<String, String> patternGroup : StringUtil.patternGroupValues(projectVersionPattern, projectVersion).entrySet()) {
                String groupName = patternGroup.getKey();
                String value = patternGroup.getValue() != null ? patternGroup.getValue() : "";
                String placeholderKey = "version." + groupName;
                if (placeholderMap.containsKey(placeholderKey)) {
                    throw new IllegalArgumentException("project version pattern capture group can not be named '" + groupName + "', because this would overwrite extension placeholder ${" + placeholderKey + "}");
                }
                placeholderMap.put(placeholderKey, () -> value);
            }
        }
        return placeholderMap;
    }

    private Map<String, Supplier<String>> generateGlobalFormatPlaceholderMap(GitSituation gitSituation, GitVersionDetails gitVersionDetails, MavenSession mavenSession) {
        HashMap<String, Supplier<String>> placeholderMap = new HashMap<String, Supplier<String>>();
        Lazy<String> hash = Lazy.by(gitSituation::getRev);
        placeholderMap.put("commit", hash);
        placeholderMap.put("commit.short", Lazy.by(() -> ((String)hash.get()).substring(0, 7)));
        Lazy<ZonedDateTime> headCommitDateTime = Lazy.by(gitSituation::getTimestamp);
        placeholderMap.put("commit.timestamp", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).toEpochSecond())));
        placeholderMap.put("commit.timestamp.year", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear())));
        placeholderMap.put("commit.timestamp.year.2digit", Lazy.by(() -> String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getYear() % 100)));
        placeholderMap.put("commit.timestamp.month", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMonthValue()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.day", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getDayOfMonth()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.hour", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getHour()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.minute", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getMinute()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.second", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)headCommitDateTime.get()).getSecond()), (int)2, (String)"0")));
        placeholderMap.put("commit.timestamp.datetime", Lazy.by(() -> ((ZonedDateTime)headCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)headCommitDateTime.get()).format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000101.000000"));
        placeholderMap.put("commit.timestamp.iso", Lazy.by(() -> ((ZonedDateTime)headCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)headCommitDateTime.get()).format(DateTimeFormatter.ISO_INSTANT) : "0000-01-01T00:00:00Z"));
        Lazy<ZonedDateTime> buildCommitDateTime = Lazy.by(() -> mavenSession.getStartTime().toInstant().atZone(ZoneId.systemDefault()));
        placeholderMap.put("build.timestamp", Lazy.by(() -> String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).toEpochSecond())));
        placeholderMap.put("build.timestamp.year", Lazy.by(() -> String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getYear())));
        placeholderMap.put("build.timestamp.year.2digit", Lazy.by(() -> String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getYear() % 100)));
        placeholderMap.put("build.timestamp.month", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getMonthValue()), (int)2, (String)"0")));
        placeholderMap.put("build.timestamp.day", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getDayOfMonth()), (int)2, (String)"0")));
        placeholderMap.put("build.timestamp.hour", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getHour()), (int)2, (String)"0")));
        placeholderMap.put("build.timestamp.minute", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getMinute()), (int)2, (String)"0")));
        placeholderMap.put("build.timestamp.second", Lazy.by(() -> StringUtils.leftPad((String)String.valueOf(((ZonedDateTime)buildCommitDateTime.get()).getSecond()), (int)2, (String)"0")));
        placeholderMap.put("build.timestamp.datetime", Lazy.by(() -> ((ZonedDateTime)buildCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)buildCommitDateTime.get()).format(DateTimeFormatter.ofPattern("yyyyMMdd.HHmmss")) : "00000000.000000"));
        placeholderMap.put("build.timestamp.iso", Lazy.by(() -> ((ZonedDateTime)buildCommitDateTime.get()).toEpochSecond() > 0L ? ((ZonedDateTime)headCommitDateTime.get()).format(DateTimeFormatter.ISO_INSTANT) : "0000-01-01T00:00:00Z"));
        String refName = gitVersionDetails.getRefName();
        Lazy<String> refNameSlug = Lazy.by(() -> GitVersioningModelProcessor.slugify(refName));
        placeholderMap.put("ref", () -> refName);
        placeholderMap.put("ref.slug", refNameSlug);
        Pattern refPattern = gitVersionDetails.getPatchDescription().pattern();
        if (refPattern != null) {
            for (Map.Entry<String, String> patternGroup : StringUtil.patternGroupValues(refPattern, refName).entrySet()) {
                String groupName = patternGroup.getKey();
                String value2 = patternGroup.getValue() != null ? patternGroup.getValue() : "";
                String placeholderKey = "ref." + groupName;
                if (placeholderMap.containsKey(placeholderKey)) {
                    throw new IllegalArgumentException("ref pattern capture group can not be named '" + groupName + "', because this would overwrite extension placeholder ${" + placeholderKey + "}");
                }
                placeholderMap.put(placeholderKey, () -> value2);
                placeholderMap.put(placeholderKey + ".slug", Lazy.by(() -> GitVersioningModelProcessor.slugify(value2)));
            }
        }
        Lazy<Boolean> dirty = Lazy.by(() -> !gitSituation.isClean());
        placeholderMap.put("dirty", Lazy.by(() -> (Boolean)dirty.get() != false ? "-DIRTY" : ""));
        placeholderMap.put("dirty.snapshot", Lazy.by(() -> (Boolean)dirty.get() != false ? "-SNAPSHOT" : ""));
        Lazy<GitDescription> description = Lazy.by(gitSituation::getDescription);
        placeholderMap.put("describe", Lazy.by(() -> ((GitDescription)description.get()).toString()));
        Lazy<String> descriptionTag = Lazy.by(() -> ((GitDescription)description.get()).getTag());
        placeholderMap.put("describe.tag", descriptionTag);
        Lazy<Matcher> descriptionTagVersionMatcher = Lazy.by(() -> this.matchVersion((String)descriptionTag.get()));
        placeholderMap.put("describe.tag.version", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)descriptionTagVersionMatcher.get()).group("version"), "0.0.0")));
        placeholderMap.put("describe.tag.version.core", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)descriptionTagVersionMatcher.get()).group("core"), "0")));
        placeholderMap.put("describe.tag.version.major", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)descriptionTagVersionMatcher.get()).group("major"), "0")));
        placeholderMap.put("describe.tag.version.major.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.major")).get(), 1L)));
        placeholderMap.put("describe.tag.version.minor", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)descriptionTagVersionMatcher.get()).group("minor"), "0")));
        placeholderMap.put("describe.tag.version.minor.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.minor")).get(), 1L)));
        placeholderMap.put("describe.tag.version.patch", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)descriptionTagVersionMatcher.get()).group("patch"), "0")));
        placeholderMap.put("describe.tag.version.patch.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.patch")).get(), 1L)));
        placeholderMap.put("describe.tag.version.label", Lazy.by(() -> Objects.requireNonNullElse(((Matcher)descriptionTagVersionMatcher.get()).group("label"), "")));
        placeholderMap.put("describe.tag.version.label.next", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.label")).get(), 1L)));
        Lazy<Integer> descriptionDistance = Lazy.by(() -> ((GitDescription)description.get()).getDistance());
        placeholderMap.put("describe.distance", Lazy.by(() -> String.valueOf(descriptionDistance.get())));
        placeholderMap.put("describe.distance.snapshot", Lazy.by(() -> (Integer)descriptionDistance.get() == 0 ? "" : "-SNAPSHOT"));
        placeholderMap.put("describe.tag.version.patch.plus.describe.distance", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.patch")).get(), ((Integer)descriptionDistance.get()).intValue())));
        placeholderMap.put("describe.tag.version.patch.next.plus.describe.distance", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.patch.next")).get(), ((Integer)descriptionDistance.get()).intValue())));
        placeholderMap.put("describe.tag.version.label.plus.describe.distance", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.label")).get(), ((Integer)descriptionDistance.get()).intValue())));
        placeholderMap.put("describe.tag.version.label.next.plus.describe.distance", Lazy.by(() -> GitVersioningModelProcessor.increase((String)((Supplier)placeholderMap.get("describe.tag.version.label.next")).get(), ((Integer)descriptionDistance.get()).intValue())));
        Lazy<Map> describeTagPatternValues = Lazy.by(() -> StringUtil.patternGroupValues(gitSituation.getDescribeTagPattern(), (String)descriptionTag.get()));
        for (String string : StringUtil.patternGroups(gitSituation.getDescribeTagPattern())) {
            String placeholderKey = "describe.tag." + string;
            if (placeholderMap.containsKey(placeholderKey)) {
                throw new IllegalArgumentException("describe tag pattern capture group can not be named '" + string + "', because this would overwrite extension placeholder ${" + placeholderKey + "}");
            }
            Lazy<String> groupValue = Lazy.by(() -> (String)((Map)describeTagPatternValues.get()).get(groupName));
            placeholderMap.put(placeholderKey, groupValue);
            placeholderMap.put(placeholderKey + ".slug", Lazy.by(() -> GitVersioningModelProcessor.slugify((String)groupValue.get())));
        }
        for (Map.Entry entry : mavenSession.getUserProperties().entrySet()) {
            if (entry.getValue() == null) continue;
            placeholderMap.put("property." + entry.getKey(), () -> property.getValue().toString());
        }
        System.getenv().forEach((key, value) -> placeholderMap.put("env." + key, () -> value));
        return placeholderMap;
    }

    private Matcher matchVersion(String input) {
        Matcher matcher = VERSION_PATTERN.matcher(input);
        matcher.find();
        return matcher;
    }

    private static File findMvnDirectory(File pomFile) throws IOException {
        for (File searchDirectory = pomFile.getParentFile(); searchDirectory != null; searchDirectory = searchDirectory.getParentFile()) {
            File mvnDir = new File(searchDirectory, ".mvn");
            if (!mvnDir.exists()) continue;
            return mvnDir;
        }
        throw new FileNotFoundException("Can not find .mvn directory in hierarchy of " + pomFile);
    }

    private static Configuration readConfig(File configFile) throws IOException {
        XmlMapper xmlMapper = (XmlMapper)((XmlMapper.Builder)XmlMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).build();
        Configuration config = (Configuration)xmlMapper.readValue(configFile, Configuration.class);
        ArrayList<Configuration.RefPatchDescription> patchDescriptions = new ArrayList<Configuration.RefPatchDescription>(config.refs.list);
        if (config.rev != null) {
            patchDescriptions.add((Configuration.RefPatchDescription)config.rev);
        }
        for (Configuration.PatchDescription patchDescription : patchDescriptions) {
            if (patchDescription.describeTagPattern == null) {
                patchDescription.describeTagPattern = config.describeTagPattern;
            }
            if (patchDescription.describeTagFirstParent == null) {
                patchDescription.describeTagFirstParent = config.describeTagFirstParent;
            }
            if (patchDescription.updatePom != null) continue;
            patchDescription.updatePom = config.updatePom;
        }
        return config;
    }

    private String getCommandOption(String name) {
        String value = this.mavenSession.getUserProperties().getProperty(name);
        if (value == null) {
            String plainName = name.replaceFirst("^versioning\\.", "");
            String environmentVariableName = "VERSIONING_" + String.join((CharSequence)"_", plainName.split("(?=\\p{Lu})")).replaceAll("\\.", "_").toUpperCase();
            value = System.getenv(environmentVariableName);
        }
        if (value == null) {
            value = System.getProperty(name);
        }
        return value;
    }

    private boolean getUpdatePomOption(Configuration.PatchDescription gitRefConfig) {
        String updatePomCommandOption = this.getCommandOption(OPTION_UPDATE_POM);
        if (updatePomCommandOption != null) {
            return Boolean.parseBoolean(updatePomCommandOption);
        }
        if (gitRefConfig.updatePom != null) {
            return gitRefConfig.updatePom;
        }
        return false;
    }

    private Set<GAV> determineRelatedProjects(Model projectModel) throws IOException {
        HashSet<GAV> relatedProjects = new HashSet<GAV>();
        this.determineRelatedProjects(projectModel, relatedProjects);
        this.config.relatedProjects.stream().map(it -> new GAV(it.groupId, it.artifactId, "*")).forEach(relatedProjects::add);
        return relatedProjects;
    }

    private void determineRelatedProjects(Model projectModel, Set<GAV> relatedProjects) throws IOException {
        Model parentProjectModel;
        GAV projectGAV = GAV.of(projectModel);
        if (relatedProjects.contains(projectGAV)) {
            return;
        }
        relatedProjects.add(projectGAV);
        if (projectModel.getParent() != null) {
            Model parentProjectModel2;
            GAV parentProjectGAV;
            GAV parentGAV = GAV.of(projectModel.getParent());
            File parentProjectPomFile = GitVersioningModelProcessor.getParentProjectPomFile(projectModel);
            if (this.isRelatedPom(parentProjectPomFile) && (parentProjectGAV = GAV.of(parentProjectModel2 = MavenUtil.readModel(parentProjectPomFile))).equals(parentGAV)) {
                this.determineRelatedProjects(parentProjectModel2, relatedProjects);
            }
        }
        if ((parentProjectModel = this.searchParentProjectInParentDirectory(projectModel)) != null) {
            this.determineRelatedProjects(parentProjectModel, relatedProjects);
        }
        for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(projectModel)) {
            Model moduleProjectModel = MavenUtil.readModel(modulePomFile);
            this.determineRelatedProjects(moduleProjectModel, relatedProjects);
        }
    }

    private boolean isRelatedProject(GAV project) {
        return this.relatedProjects.contains(project) || this.relatedProjects.contains(new GAV(project.getGroupId(), project.getArtifactId(), "*"));
    }

    private boolean isRelatedPom(File pomFile) throws IOException {
        return pomFile != null && pomFile.exists() && pomFile.isFile() && pomFile.getName().endsWith(".xml") && pomFile.getCanonicalPath().startsWith(this.mvnDirectory.getParentFile().getCanonicalPath() + File.separator) && pomFile.getCanonicalPath().startsWith(this.gitSituation.getRootDirectory().getCanonicalPath() + File.separator);
    }

    private Model searchParentProjectInParentDirectory(Model projectModel) throws IOException {
        File parentDirectoryPomFile = MavenUtil.pomFile(projectModel.getProjectDirectory().getParentFile(), "pom.xml");
        if (parentDirectoryPomFile.exists() && this.isRelatedPom(parentDirectoryPomFile)) {
            Model parentDirectoryProjectModel = MavenUtil.readModel(parentDirectoryPomFile);
            for (File modulePomFile : GitVersioningModelProcessor.getProjectModules(parentDirectoryProjectModel)) {
                if (!modulePomFile.getCanonicalFile().equals(projectModel.getPomFile().getCanonicalFile())) continue;
                return parentDirectoryProjectModel;
            }
        }
        return null;
    }

    private static File getParentProjectPomFile(Model projectModel) {
        if (projectModel.getParent() == null) {
            return null;
        }
        File parentProjectPomFile = MavenUtil.pomFile(projectModel.getProjectDirectory(), projectModel.getParent().getRelativePath());
        if (parentProjectPomFile.exists()) {
            return parentProjectPomFile;
        }
        return null;
    }

    private static Set<File> getProjectModules(Model projectModel) {
        HashSet<File> modules = new HashSet<File>();
        for (String module : projectModel.getModules()) {
            modules.add(MavenUtil.pomFile(projectModel.getProjectDirectory(), module));
        }
        for (Profile profile : projectModel.getProfiles()) {
            for (String module : profile.getModules()) {
                modules.add(MavenUtil.pomFile(projectModel.getProjectDirectory(), module));
            }
        }
        return modules.stream().filter(File::exists).collect(Collectors.toSet());
    }

    private File writePomFile(Model projectModel) throws IOException {
        File gitVersionedPomFile = new File(projectModel.getProjectDirectory(), GIT_VERSIONING_POM_NAME);
        this.logger.debug("generate {}", (Object)gitVersionedPomFile);
        Document gitVersionedPomDocument = MavenUtil.readXml(this.locatePom(projectModel.getProjectDirectory()));
        Element projectElement = gitVersionedPomDocument.getChild("project");
        GitVersioningModelProcessor.updateParentVersion(projectElement, projectModel.getParent());
        GitVersioningModelProcessor.updateVersion(projectElement, projectModel);
        this.updatePropertyValues(projectElement, (ModelBase)projectModel);
        GitVersioningModelProcessor.updateDependencyVersions(projectElement, (ModelBase)projectModel);
        GitVersioningModelProcessor.updatePluginVersions(projectElement, (BuildBase)projectModel.getBuild(), projectModel.getReporting());
        this.updateProfiles(projectElement, projectModel.getProfiles());
        MavenUtil.writeXml(gitVersionedPomFile, gitVersionedPomDocument);
        return gitVersionedPomFile;
    }

    private static void updateParentVersion(Element projectElement, Parent parent) {
        Element parentElement = projectElement.getChild("parent");
        if (parentElement != null) {
            Element parentVersionElement = parentElement.getChild("version");
            parentVersionElement.setText(parent.getVersion());
        }
    }

    private static void updateVersion(Element projectElement, Model projectModel) {
        Element versionElement = projectElement.getChild("version");
        if (versionElement != null) {
            versionElement.setText(projectModel.getVersion());
        }
    }

    private void updatePropertyValues(Element element, ModelBase model) {
        Element propertiesElement = element.getChild("properties");
        if (propertiesElement != null) {
            propertiesElement.getChildren().forEach(propertyElement -> {
                String modelPropertyValue = model.getProperties().getProperty(propertyElement.getName());
                if (modelPropertyValue != null && !Objects.equals(propertyElement.getText(), modelPropertyValue)) {
                    propertyElement.setText(modelPropertyValue);
                }
            });
        }
    }

    private static void updateDependencyVersions(Element element, ModelBase model) {
        Element dependenciesElement;
        Element dependencyManagementElement;
        Element dependenciesElement2 = element.getChild("dependencies");
        if (dependenciesElement2 != null) {
            GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement2, model.getDependencies());
        }
        if ((dependencyManagementElement = element.getChild("dependencyManagement")) != null && (dependenciesElement = dependencyManagementElement.getChild("dependencies")) != null) {
            GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement, model.getDependencyManagement().getDependencies());
        }
    }

    private static void updateDependencyVersions(Element dependenciesElement, List<Dependency> dependencies) {
        GitVersioningModelProcessor.forEachPair(dependenciesElement.getChildren(), dependencies, (dependencyElement, dependency) -> {
            if (!Objects.equals(dependency.getManagementKey(), GitVersioningModelProcessor.getDependencyManagementKey(dependencyElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model dependencies order");
            }
            Element dependencyVersionElement = dependencyElement.getChild("version");
            if (dependencyVersionElement != null) {
                dependencyVersionElement.setText(dependency.getVersion());
            }
        });
    }

    private static String getDependencyManagementKey(Element element) {
        Element groupId = element.getChild("groupId");
        Element artifactId = element.getChild("artifactId");
        Element type = element.getChild("type");
        Element classifier = element.getChild("classifier");
        return (groupId != null ? groupId.getText().trim() : "") + ":" + (artifactId != null ? artifactId.getText().trim() : "") + ":" + (type != null ? type.getText().trim() : "jar") + (String)(classifier != null ? ":" + classifier.getText().trim() : "");
    }

    private static void updatePluginVersions(Element projectElement, BuildBase build, Reporting reporting) {
        Element reportingElement;
        Element pluginsElement;
        Element buildElement = projectElement.getChild("build");
        if (buildElement != null) {
            Element pluginsManagementElement;
            Element pluginsElement2 = buildElement.getChild("plugins");
            if (pluginsElement2 != null) {
                GitVersioningModelProcessor.updatePluginVersions(pluginsElement2, build.getPlugins());
            }
            if ((pluginsManagementElement = buildElement.getChild("pluginsManagement")) != null && (pluginsElement = pluginsManagementElement.getChild("plugins")) != null) {
                GitVersioningModelProcessor.updatePluginVersions(pluginsElement, build.getPluginManagement().getPlugins());
            }
        }
        if ((reportingElement = projectElement.getChild("reporting")) != null && (pluginsElement = reportingElement.getChild("plugins")) != null) {
            GitVersioningModelProcessor.updateReportPluginVersions(pluginsElement, reporting.getPlugins());
        }
    }

    private static void updatePluginVersions(Element pluginsElement, List<Plugin> plugins) {
        GitVersioningModelProcessor.forEachPair(pluginsElement.getChildren(), plugins, (pluginElement, plugin) -> {
            if (!Objects.equals(plugin.getKey(), GitVersioningModelProcessor.getPluginKey(pluginElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model plugin order");
            }
            Element pluginVersionElement = pluginElement.getChild("version");
            if (pluginVersionElement != null) {
                pluginVersionElement.setText(plugin.getVersion());
            }
            Element dependenciesElement = pluginElement.getChild("dependencies");
            List dependencies = plugin.getDependencies();
            if (!dependencies.isEmpty() && dependenciesElement != null) {
                GitVersioningModelProcessor.updateDependencyVersions(dependenciesElement, dependencies);
            }
        });
    }

    private static void updateReportPluginVersions(Element pluginsElement, List<ReportPlugin> plugins) {
        GitVersioningModelProcessor.forEachPair(pluginsElement.getChildren(), plugins, (pluginElement, plugin) -> {
            if (!Objects.equals(plugin.getKey(), GitVersioningModelProcessor.getPluginKey(pluginElement))) {
                throw new IllegalArgumentException("Unexpected difference of xml and model report plugin order");
            }
            Element pluginVersionElement = pluginElement.getChild("version");
            if (pluginVersionElement != null) {
                pluginVersionElement.setText(plugin.getVersion());
            }
        });
    }

    private static String getPluginKey(Element element) {
        Element groupId = element.getChild("groupId");
        Element artifactId = element.getChild("artifactId");
        return (groupId != null ? groupId.getText().trim() : "org.apache.maven.plugins") + ":" + (artifactId != null ? artifactId.getText().trim() : "");
    }

    private void updateProfiles(Element projectElement, List<Profile> profiles) {
        Element profilesElement = projectElement.getChild("profiles");
        if (profilesElement != null) {
            Map<String, Profile> profileMap = profiles.stream().collect(Collectors.toMap(Profile::getId, it -> it));
            for (Element profileElement : profilesElement.getChildren("profile")) {
                String profileId = profileElement.getChild("id").getText().trim();
                Profile profile = profileMap.get(profileId);
                this.updatePropertyValues(profileElement, (ModelBase)profile);
                GitVersioningModelProcessor.updateDependencyVersions(profileElement, (ModelBase)profile);
                GitVersioningModelProcessor.updatePluginVersions(profileElement, profile.getBuild(), profile.getReporting());
            }
        }
    }

    private static String extensionLogHeader(GAV extensionGAV) {
        String extension = extensionGAV.toString();
        String metaInfo = "[core extension]";
        String plainLog = extension + " " + metaInfo;
        String formattedLog = MessageUtils.buffer().a((CharSequence)" ").mojo((Object)extension).a((CharSequence)" ").strong((Object)metaInfo).a((CharSequence)" ").toString();
        return GitVersioningModelProcessor.padLogHeaderPadding(plainLog, formattedLog);
    }

    private static String padLogHeaderPadding(String plainLog, String formattedLog) {
        String pad = "-";
        int padding = Math.max(6, 70 - plainLog.length());
        int paddingLeft = (int)Math.floor((double)padding / 2.0);
        int paddingRight = (int)Math.ceil((double)padding / 2.0);
        return MessageUtils.buffer().strong((Object)StringUtils.repeat((String)pad, (int)paddingLeft)).a((CharSequence)formattedLog).strong((Object)StringUtils.repeat((String)pad, (int)paddingRight)).toString();
    }

    private static String projectLogHeader(GAV projectGAV) {
        String project = projectGAV.getProjectId();
        return MessageUtils.buffer().project((Object)project).toString();
    }

    private static String sectionLogHeader(String title, ModelBase model) {
        String header = title + ":";
        if (model instanceof Profile) {
            header = MessageUtils.buffer().strong((Object)("profile " + ((Profile)model).getId() + " ")) + header;
        }
        return header;
    }

    public static <T1, T2> void forEachPair(Collection<T1> collection1, Collection<T2> collection2, BiConsumer<T1, T2> consumer) {
        if (collection1.size() != collection2.size()) {
            throw new IllegalArgumentException("Collections sizes are not equals");
        }
        Iterator<T1> iter1 = collection1.iterator();
        Iterator<T2> iter2 = collection2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            consumer.accept(iter1.next(), iter2.next());
        }
    }

    private static String slugify(String value) {
        if (value == null) {
            return "";
        }
        return value.replace("/", "-");
    }

    private static String increase(String number, long increment) {
        String sanitized = number.isEmpty() ? "0" : number;
        return String.format("%0" + sanitized.length() + "d", Long.parseLong(number.isEmpty() ? "0" : number) + increment);
    }
}

