/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.GitUtil;
import me.qoomon.gitversioning.commons.Lazy;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;

public class GitSituation {
    private final Repository repository;
    private final File rootDirectory;
    private final ObjectId head;
    private final String rev;
    private final Supplier<ZonedDateTime> timestamp = Lazy.by(this::timestamp);
    private Supplier<String> branch = Lazy.by(this::branch);
    private Supplier<List<String>> tags = Lazy.by(this::tags);
    private final Supplier<Boolean> clean = Lazy.by(this::clean);
    private Pattern describeTagPattern = Pattern.compile(".*");
    private boolean firstParent = true;
    private Supplier<GitDescription> description = Lazy.by(this::describe);

    public GitSituation(Repository repository) throws IOException {
        this.repository = repository;
        this.rootDirectory = this.getWorkTree(repository);
        this.head = repository.resolve("HEAD");
        this.rev = this.head != null ? this.head.getName() : GitUtil.NO_COMMIT;
    }

    private File getWorkTree(Repository repository) throws IOException {
        try {
            return repository.getWorkTree();
        }
        catch (NoWorkTreeException e) {
            File gitDirFile = new File(repository.getDirectory(), "gitdir");
            if (gitDirFile.exists()) {
                String gitDirPath = Files.readAllLines(gitDirFile.toPath()).get(0);
                return new File(gitDirPath).getParentFile();
            }
            throw e;
        }
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public String getRev() {
        return this.rev;
    }

    public ZonedDateTime getTimestamp() {
        return this.timestamp.get();
    }

    public String getBranch() {
        return this.branch.get();
    }

    protected void setBranch(String branch) {
        if (branch != null) {
            if (branch.startsWith("refs/tags/")) {
                throw new IllegalArgumentException("invalid branch ref" + branch);
            }
            branch = branch.replaceFirst("^refs/heads/", "").replaceFirst("^refs/", "");
        }
        String finalBranch = branch;
        this.branch = () -> finalBranch;
    }

    public boolean isDetached() {
        return this.branch.get() == null;
    }

    public List<String> getTags() {
        return this.tags.get();
    }

    protected void addTag(String tag) {
        Objects.requireNonNull(tag);
        if (tag.startsWith("refs/") && !tag.startsWith("refs/tags/")) {
            throw new IllegalArgumentException("invalid tag ref" + tag);
        }
        String finalTag = tag.replaceFirst("^refs/tags/", "");
        Supplier<List<String>> currentTags = this.tags;
        this.tags = Lazy.by(() -> {
            ArrayList<String> tags = new ArrayList<String>((Collection)currentTags.get());
            tags.add(finalTag);
            return tags;
        });
    }

    protected void setTags(List<String> tags) {
        Objects.requireNonNull(tags);
        tags.forEach(tag -> {
            Objects.requireNonNull(tag);
            if (tag.startsWith("refs/") && !tag.startsWith("refs/tags/")) {
                throw new IllegalArgumentException("invalid tag ref" + tag);
            }
        });
        List<String> finalTags = tags = tags.stream().map(tag -> tag.replaceFirst("^refs/tags/", "")).collect(Collectors.toList());
        this.tags = () -> finalTags;
    }

    public boolean isClean() {
        return this.clean.get();
    }

    public void setDescribeTagPattern(Pattern describeTagPattern) {
        this.describeTagPattern = Objects.requireNonNull(describeTagPattern);
        this.description = Lazy.by(this::describe);
    }

    public Pattern getDescribeTagPattern() {
        return this.describeTagPattern;
    }

    public boolean isFirstParent() {
        return this.firstParent;
    }

    public void setFirstParent(boolean firstParent) {
        this.firstParent = firstParent;
    }

    public GitDescription getDescription() {
        return this.description.get();
    }

    private ZonedDateTime timestamp() throws IOException {
        return this.head != null ? GitUtil.revTimestamp(this.repository, this.head) : ZonedDateTime.ofInstant(Instant.EPOCH, ZoneOffset.UTC);
    }

    private String branch() throws IOException {
        return GitUtil.branch(this.repository);
    }

    private List<String> tags() throws IOException {
        return this.head != null ? GitUtil.tagsPointAt(this.head, this.repository) : Collections.emptyList();
    }

    private boolean clean() throws GitAPIException {
        return GitUtil.status(this.repository).isClean();
    }

    private GitDescription describe() throws IOException {
        return GitUtil.describe(this.head, this.describeTagPattern, this.repository, this.firstParent);
    }
}

