/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.qoomon.gitversioning.commons.GitDescription;
import me.qoomon.gitversioning.commons.TagComparator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public final class GitUtil {
    public static String NO_COMMIT = "0000000000000000000000000000000000000000";

    public static Status status(Repository repository) throws GitAPIException {
        return Git.wrap((Repository)repository).status().call();
    }

    public static String branch(Repository repository) throws IOException {
        String branch = repository.getBranch();
        if (ObjectId.isId((String)branch)) {
            return null;
        }
        return branch;
    }

    public static List<String> tagsPointAt(ObjectId revObjectId, Repository repository) throws IOException {
        return GitUtil.reverseTagRefMap(repository).getOrDefault(revObjectId, Collections.emptyList());
    }

    public static GitDescription describe(ObjectId revObjectId, Pattern tagPattern, Repository repository, boolean firstParent) throws IOException {
        if (revObjectId == null) {
            return new GitDescription(NO_COMMIT, "root", 0);
        }
        Map<ObjectId, List<String>> objectIdListMap = GitUtil.reverseTagRefMap(repository);
        try (RevWalk walk = new RevWalk(repository);){
            walk.setRetainBody(false);
            walk.setFirstParent(firstParent);
            walk.markStart(walk.parseCommit((AnyObjectId)revObjectId));
            Iterator walkIterator = walk.iterator();
            int depth = 0;
            while (walkIterator.hasNext()) {
                RevCommit rev = (RevCommit)walkIterator.next();
                Optional<String> matchingTag = objectIdListMap.getOrDefault(rev, Collections.emptyList()).stream().filter(tag -> tagPattern.matcher((CharSequence)tag).matches()).findFirst();
                if (matchingTag.isPresent()) {
                    GitDescription gitDescription = new GitDescription(revObjectId.getName(), matchingTag.get(), depth);
                    return gitDescription;
                }
                ++depth;
            }
            if (GitUtil.isShallowRepository(repository)) {
                throw new IllegalStateException("couldn't find matching tag in shallow git repository");
            }
            GitDescription gitDescription = new GitDescription(revObjectId.getName(), "root", depth);
            return gitDescription;
        }
    }

    public static boolean isShallowRepository(Repository repository) {
        return new File(repository.getDirectory(), "shallow").isFile();
    }

    public static List<Ref> tags(Repository repository) throws IOException {
        return repository.getRefDatabase().getRefsByPrefix("refs/tags/").stream().collect(Collectors.toList());
    }

    public static Map<ObjectId, List<String>> reverseTagRefMap(Repository repository) throws IOException {
        TagComparator tagComparator = new TagComparator(repository);
        return GitUtil.tags(repository).stream().collect(Collectors.groupingBy(r -> {
            try {
                Ref peel = repository.getRefDatabase().peel(r);
                return peel.getPeeledObjectId() != null ? peel.getPeeledObjectId() : peel.getObjectId();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        })).entrySet().stream().collect(Collectors.toMap(e -> (ObjectId)e.getKey(), e -> ((List)e.getValue()).stream().sorted(tagComparator).map(v -> Repository.shortenRefName((String)v.getName())).collect(Collectors.toList())));
    }

    public static ZonedDateTime revTimestamp(Repository repository, ObjectId rev) throws IOException {
        Instant commitTime = Instant.ofEpochSecond(repository.parseCommit((AnyObjectId)rev).getCommitTime());
        return ZonedDateTime.ofInstant(commitTime, ZoneOffset.UTC);
    }
}

