/*
 * Decompiled with CFR 0.152.
 */
package me.qoomon.gitversioning.commons;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public final class Lazy<T>
implements Supplier<T> {
    private volatile Callable<T> initializer;
    private T value;

    public Lazy(Callable<T> initializer) {
        this.initializer = Objects.requireNonNull(initializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.initializer != null) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.initializer != null) {
                    try {
                        this.value = this.initializer.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    this.initializer = null;
                }
            }
        }
        return this.value;
    }

    public static <T> Lazy<T> of(T value) {
        return new Lazy<Object>(() -> value);
    }

    public static <T> Lazy<T> by(Callable<T> supplier) {
        return new Lazy<T>(supplier);
    }

    public static <V> V get(Lazy<V> value) {
        if (value != null) {
            return value.get();
        }
        return null;
    }
}

