/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.qoi.plugin;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import lombok.NonNull;
import me.saharnooby.qoi.QOIColorSpace;
import me.saharnooby.qoi.QOIImage;
import me.saharnooby.qoi.QOIUtil;
import me.saharnooby.qoi.plugin.ImageParamUtil;
import me.saharnooby.qoi.plugin.WrappedImageInputStream;

public final class QOIImageReader
extends ImageReader {
    static final int[] OFFSETS_3 = new int[]{0, 1, 2};
    static final int[] OFFSETS_4 = new int[]{0, 1, 2, 3};
    private QOIImage image;

    QOIImageReader(@NonNull ImageReaderSpi originatingProvider) {
        super(originatingProvider);
        if (originatingProvider == null) {
            throw new NullPointerException("originatingProvider is marked non-null but is null");
        }
    }

    private void readImage() throws IOException {
        if (this.image != null) {
            return;
        }
        if (this.input == null) {
            throw new IllegalStateException("Input not set");
        }
        ImageInputStream input = (ImageInputStream)this.input;
        this.image = QOIUtil.readImage((InputStream)new WrappedImageInputStream(input));
    }

    private void checkIndex(int imageIndex) {
        if (imageIndex != 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public int getNumImages(boolean allowSearch) {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readImage();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.checkIndex(imageIndex);
        this.readImage();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readImage();
        boolean hasAlpha = this.image.getChannels() == 4;
        ColorSpace colorSpace = QOIImageReader.getAwtColorSpace(this.image.getColorSpace());
        ImageTypeSpecifier type = ImageTypeSpecifier.createInterleaved(colorSpace, hasAlpha ? OFFSETS_4 : OFFSETS_3, 0, hasAlpha, false);
        return Collections.singletonList(type).iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        this.checkIndex(imageIndex);
        this.clearAbortRequest();
        this.processImageStarted(imageIndex);
        this.readImage();
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        BufferedImage source = QOIImageReader.convertToBufferedImage(this.image);
        if (param == null || ImageParamUtil.isDefault(param)) {
            this.processImageComplete();
            return source;
        }
        Rectangle sourceRegion = QOIImageReader.getSourceRegion(param, width, height);
        int sourceXSubsampling = param.getSourceXSubsampling();
        int sourceYSubsampling = param.getSourceYSubsampling();
        int[] sourceBands = param.getSourceBands();
        int[] destinationBands = param.getDestinationBands();
        Point destinationOffset = param.getDestinationOffset();
        BufferedImage dest = QOIImageReader.getDestination(param, this.getImageTypes(0), width, height);
        SampleModel destSampleModel = dest.getSampleModel();
        int destBands = destSampleModel.getNumBands();
        for (int band = 0; band < destBands; ++band) {
            if (destSampleModel.getSampleSize(band) == 8) continue;
            throw new IIOException("Reading into images with band size != 8 bits is not supported");
        }
        QOIImageReader.checkReadParamBandSettings(param, this.image.getChannels(), destBands);
        WritableRaster sourceRaster = source.getWritableTile(0, 0);
        WritableRaster destRaster = dest.getWritableTile(0, 0);
        if (sourceBands != null) {
            sourceRaster = sourceRaster.createWritableChild(0, 0, width, height, 0, 0, sourceBands);
        }
        if (destinationBands != null) {
            destRaster = destRaster.createWritableChild(0, 0, destRaster.getWidth(), destRaster.getHeight(), 0, 0, destinationBands);
        }
        int destMinX = destRaster.getMinX();
        int destMaxX = destMinX + destRaster.getWidth() - 1;
        int destMinY = destRaster.getMinY();
        int destMaxY = destMinY + destRaster.getHeight() - 1;
        int[] pixel = new int[sourceRaster.getNumBands()];
        for (int y = sourceRegion.y; y < sourceRegion.y + sourceRegion.height; y += sourceYSubsampling) {
            int destY;
            if (y < 0 || y >= height || (destY = destinationOffset.y + (y - sourceRegion.y) / sourceYSubsampling) < destMinY || destY > destMaxY) continue;
            for (int x = sourceRegion.x; x < sourceRegion.x + sourceRegion.width; x += sourceXSubsampling) {
                int destX;
                if (x < 0 || x >= width || (destX = destinationOffset.x + (x - sourceRegion.x) / sourceXSubsampling) < destMinX || destX > destMaxX) continue;
                sourceRaster.getPixel(x, y, pixel);
                destRaster.setPixel(destX, destY, pixel);
            }
            this.processImageProgress((float)(y - sourceRegion.y) * 100.0f / (float)sourceRegion.height);
            if (!this.abortRequested()) continue;
            this.processReadAborted();
            return dest;
        }
        this.processImageComplete();
        return dest;
    }

    @Override
    public void reset() {
        super.reset();
        this.image = null;
    }

    public static BufferedImage convertToBufferedImage(@NonNull QOIImage image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int channels = image.getChannels();
        boolean hasAlpha = channels == 4;
        DataBufferByte buffer = new DataBufferByte(image.getPixelData(), width * height * channels);
        WritableRaster raster = Raster.createInterleavedRaster(buffer, width, height, channels * width, channels, hasAlpha ? OFFSETS_4 : OFFSETS_3, new Point(0, 0));
        ColorSpace awtColorSpace = QOIImageReader.getAwtColorSpace(image.getColorSpace());
        ComponentColorModel colorModel = new ComponentColorModel(awtColorSpace, hasAlpha, false, hasAlpha ? 3 : 1, 0);
        return new BufferedImage(colorModel, raster, false, new Hashtable());
    }

    private static ColorSpace getAwtColorSpace(@NonNull QOIColorSpace colorSpace) {
        if (colorSpace == null) {
            throw new NullPointerException("colorSpace is marked non-null but is null");
        }
        switch (colorSpace) {
            case SRGB: {
                return ColorSpace.getInstance(1000);
            }
            case LINEAR: {
                return ColorSpace.getInstance(1004);
            }
        }
        throw new RuntimeException();
    }
}

