/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.qoi.plugin;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import lombok.NonNull;
import me.saharnooby.qoi.QOIColorSpace;
import me.saharnooby.qoi.QOIImage;
import me.saharnooby.qoi.QOIUtil;
import me.saharnooby.qoi.plugin.ImageParamUtil;
import me.saharnooby.qoi.plugin.QOIImageReader;
import me.saharnooby.qoi.plugin.WrappedImageOutputStream;

public final class QOIImageWriter
extends ImageWriter {
    QOIImageWriter(@NonNull ImageWriterSpi originatingProvider) {
        super(originatingProvider);
        if (originatingProvider == null) {
            throw new NullPointerException("originatingProvider is marked non-null but is null");
        }
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
        return null;
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int bandCount;
        this.clearAbortRequest();
        this.processImageStarted(0);
        RenderedImage rendered = image.getRenderedImage();
        if (param == null || ImageParamUtil.isDefault(param)) {
            this.writeImage(QOIImageWriter.createFromRenderedImage(rendered));
            return;
        }
        Rectangle sourceRegion = new Rectangle(0, 0, rendered.getWidth(), rendered.getHeight());
        if (param.getSourceRegion() != null) {
            sourceRegion = sourceRegion.intersection(param.getSourceRegion());
        }
        int sourceXSubsampling = param.getSourceXSubsampling();
        int sourceYSubsampling = param.getSourceYSubsampling();
        int[] sourceBands = param.getSourceBands();
        int subsamplingXOffset = param.getSubsamplingXOffset();
        int subsamplingYOffset = param.getSubsamplingYOffset();
        sourceRegion.x += subsamplingXOffset;
        sourceRegion.y += subsamplingYOffset;
        sourceRegion.width -= subsamplingXOffset;
        sourceRegion.height -= subsamplingYOffset;
        int width = sourceRegion.width;
        int height = sourceRegion.height;
        Raster raster = rendered.getData(sourceRegion);
        int n = bandCount = sourceBands == null ? raster.getNumBands() : sourceBands.length;
        if (bandCount != 3 && bandCount != 4) {
            throw new IllegalArgumentException("Band count not supported");
        }
        if (sourceBands != null) {
            for (int sourceBand : sourceBands) {
                if (sourceBand < raster.getNumBands()) continue;
                throw new IllegalArgumentException("Invalid band");
            }
        }
        raster = raster.createChild(sourceRegion.x, sourceRegion.y, width, height, 0, 0, sourceBands);
        width = (width + sourceXSubsampling - 1) / sourceXSubsampling;
        height = (height + sourceYSubsampling - 1) / sourceYSubsampling;
        byte[] pixels = new byte[width * height * bandCount];
        int[] pixel = new int[bandCount];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                raster.getPixel(x * sourceXSubsampling, y * sourceYSubsampling, pixel);
                int i = (y * width + x) * bandCount;
                pixels[i] = (byte)pixel[0];
                pixels[i + 1] = (byte)pixel[1];
                pixels[i + 2] = (byte)pixel[2];
                if (bandCount != 4) continue;
                pixels[i + 3] = (byte)pixel[3];
            }
            this.processImageProgress((float)y * 100.0f / (float)height);
            if (!this.abortRequested()) continue;
            this.processWriteAborted();
            return;
        }
        this.writeImage(QOIUtil.createFromPixelData((byte[])pixels, (int)width, (int)height, (int)bandCount));
    }

    private void writeImage(@NonNull QOIImage converted) throws IOException {
        if (converted == null) {
            throw new NullPointerException("converted is marked non-null but is null");
        }
        ImageOutputStream output = (ImageOutputStream)this.output;
        QOIUtil.writeImage((QOIImage)converted, (OutputStream)new WrappedImageOutputStream(output));
        output.flush();
        this.processImageComplete();
    }

    public static QOIImage createFromRenderedImage(@NonNull RenderedImage image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (image instanceof BufferedImage) {
            return QOIImageWriter.createFromBufferedImage((BufferedImage)image);
        }
        return QOIImageWriter.createFromRaster(image.getData(), image.getColorModel());
    }

    private static QOIImage createFromBufferedImage(@NonNull BufferedImage image) {
        ColorModel colorModel;
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster raster = image.getRaster();
        if (raster.getClass().getName().equals("sun.awt.image.ByteInterleavedRaster") && raster.getMinX() == 0 && raster.getMinY() == 0 && raster.getWidth() == width && raster.getHeight() == height && !(colorModel = image.getColorModel()).isAlphaPremultiplied()) {
            byte[] buffer = ((DataBufferByte)raster.getDataBuffer()).getData();
            SampleModel model = raster.getSampleModel();
            if (model instanceof PixelInterleavedSampleModel && model.getTransferType() == 0 && model.getWidth() == width && model.getHeight() == height && model.getNumBands() == 3 && ((PixelInterleavedSampleModel)model).getPixelStride() == 3 && ((PixelInterleavedSampleModel)model).getScanlineStride() == 3 * width && Arrays.equals(((PixelInterleavedSampleModel)model).getBandOffsets(), QOIImageReader.OFFSETS_3) && buffer.length == width * height * 3) {
                return QOIUtil.createFromPixelData((byte[])buffer, (int)width, (int)height, (int)3);
            }
            if (model instanceof PixelInterleavedSampleModel && model.getTransferType() == 0 && model.getWidth() == width && model.getHeight() == height && model.getNumBands() == 4 && ((PixelInterleavedSampleModel)model).getPixelStride() == 4 && ((PixelInterleavedSampleModel)model).getScanlineStride() == 4 * width && Arrays.equals(((PixelInterleavedSampleModel)model).getBandOffsets(), QOIImageReader.OFFSETS_4) && buffer.length == width * height * 4) {
                return QOIUtil.createFromPixelData((byte[])buffer, (int)width, (int)height, (int)4);
            }
        }
        int channels = image.getTransparency() != 1 ? 4 : 3;
        byte[] pixelData = new byte[width * height * channels];
        switch (image.getType()) {
            case 2: {
                assert (channels == 4);
                WritableRaster raster2 = image.getRaster();
                DataBuffer buffer = (DataBufferInt)raster2.getDataBuffer();
                int[] data = ((DataBufferInt)buffer).getData();
                int total = width * height * 4;
                int i = 0;
                int j = buffer.getOffset();
                while (i < total) {
                    int pixel = data[j];
                    pixelData[i] = (byte)(pixel >> 16);
                    pixelData[i + 1] = (byte)(pixel >> 8);
                    pixelData[i + 2] = (byte)pixel;
                    pixelData[i + 3] = (byte)(pixel >> 24);
                    i += 4;
                    ++j;
                }
                break;
            }
            case 1: {
                assert (channels == 3);
                WritableRaster raster2 = image.getRaster();
                DataBuffer buffer = (DataBufferInt)raster2.getDataBuffer();
                int[] data = ((DataBufferInt)buffer).getData();
                int total = width * height * 3;
                int i = 0;
                int j = buffer.getOffset();
                while (i < total) {
                    int pixel = data[j];
                    pixelData[i] = (byte)(pixel >> 16);
                    pixelData[i + 1] = (byte)(pixel >> 8);
                    pixelData[i + 2] = (byte)pixel;
                    i += 3;
                    ++j;
                }
                break;
            }
            case 4: {
                assert (channels == 3);
                WritableRaster raster2 = image.getRaster();
                DataBuffer buffer = (DataBufferInt)raster2.getDataBuffer();
                int[] data = ((DataBufferInt)buffer).getData();
                int total = width * height * 3;
                int i = 0;
                int j = buffer.getOffset();
                while (i < total) {
                    int pixel = data[j];
                    pixelData[i] = (byte)pixel;
                    pixelData[i + 1] = (byte)(pixel >> 8);
                    pixelData[i + 2] = (byte)(pixel >> 16);
                    i += 3;
                    ++j;
                }
                break;
            }
            case 5: {
                assert (channels == 3);
                WritableRaster raster2 = image.getRaster();
                DataBuffer buffer = (DataBufferByte)raster2.getDataBuffer();
                byte[] data = ((DataBufferByte)buffer).getData();
                int total = width * height * 3;
                int i = 0;
                int j = buffer.getOffset();
                while (i < total) {
                    pixelData[i] = data[j + 2];
                    pixelData[i + 1] = data[j + 1];
                    pixelData[i + 2] = data[j];
                    i += 3;
                    j += 3;
                }
                break;
            }
            case 6: {
                assert (channels == 4);
                WritableRaster raster2 = image.getRaster();
                DataBuffer buffer = (DataBufferByte)raster2.getDataBuffer();
                byte[] data = ((DataBufferByte)buffer).getData();
                int total = width * height * 4;
                int i = 0;
                int j = buffer.getOffset();
                while (i < total) {
                    pixelData[i] = data[j + 3];
                    pixelData[i + 1] = data[j + 2];
                    pixelData[i + 2] = data[j + 1];
                    pixelData[i + 3] = data[j];
                    i += 4;
                    j += 4;
                }
                break;
            }
            case 10: {
                assert (channels == 3);
                WritableRaster raster2 = image.getRaster();
                DataBuffer buffer = (DataBufferByte)raster2.getDataBuffer();
                byte[] data = ((DataBufferByte)buffer).getData();
                int total = width * height * 3;
                int i = 0;
                int j = buffer.getOffset();
                while (i < total) {
                    byte value;
                    pixelData[i] = value = data[j];
                    pixelData[i + 1] = value;
                    pixelData[i + 2] = value;
                    i += 3;
                    ++j;
                }
                break;
            }
            default: {
                return QOIImageWriter.createFromRaster(image.getRaster(), image.getColorModel());
            }
        }
        return QOIUtil.createFromPixelData((byte[])pixelData, (int)width, (int)height, (int)channels, (QOIColorSpace)QOIColorSpace.SRGB);
    }

    private static QOIImage createFromRaster(@NonNull Raster raster, @NonNull ColorModel colorModel) {
        if (raster == null) {
            throw new NullPointerException("raster is marked non-null but is null");
        }
        if (colorModel == null) {
            throw new NullPointerException("colorModel is marked non-null but is null");
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        int channels = colorModel.getTransparency() != 1 ? 4 : 3;
        byte[] pixelData = new byte[width * height * channels];
        Object pixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                pixel = raster.getDataElements(x, y, pixel);
                int rgb = colorModel.getRGB(pixel);
                int i = (y * width + x) * channels;
                pixelData[i] = (byte)(rgb >> 16);
                pixelData[i + 1] = (byte)(rgb >> 8);
                pixelData[i + 2] = (byte)rgb;
                if (channels != 4) continue;
                pixelData[i + 3] = (byte)(rgb >> 24);
            }
        }
        return QOIUtil.createFromPixelData((byte[])pixelData, (int)width, (int)height, (int)channels, (QOIColorSpace)QOIColorSpace.SRGB);
    }
}

