/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.qoi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import lombok.NonNull;
import me.saharnooby.qoi.QOIColorSpace;
import me.saharnooby.qoi.QOIDecoder;
import me.saharnooby.qoi.QOIEncoder;
import me.saharnooby.qoi.QOIImage;

public final class QOIUtil {
    public static QOIImage createFromPixelData(byte @NonNull [] pixelData, int width, int height) {
        if (pixelData == null) {
            throw new NullPointerException("pixelData is marked non-null but is null");
        }
        return QOIUtil.createFromPixelData(pixelData, width, height, pixelData.length / width / height);
    }

    public static QOIImage createFromPixelData(byte @NonNull [] pixelData, int width, int height, int channels) {
        if (pixelData == null) {
            throw new NullPointerException("pixelData is marked non-null but is null");
        }
        return QOIUtil.createFromPixelData(pixelData, width, height, channels, QOIColorSpace.SRGB);
    }

    public static QOIImage createFromPixelData(byte @NonNull [] pixelData, int width, int height, int channels, @NonNull QOIColorSpace colorSpace) {
        if (pixelData == null) {
            throw new NullPointerException("pixelData is marked non-null but is null");
        }
        if (colorSpace == null) {
            throw new NullPointerException("colorSpace is marked non-null but is null");
        }
        if (width < 1) {
            throw new IllegalArgumentException("Width must be positive");
        }
        if (height < 1) {
            throw new IllegalArgumentException("Height must be positive");
        }
        if (channels != 3 && channels != 4) {
            throw new IllegalArgumentException("3 or 4 channels are supported");
        }
        if (pixelData.length != width * height * channels) {
            throw new IllegalArgumentException("Unexpected pixel data array length, must match width * height * channels");
        }
        return new QOIImage(width, height, channels, colorSpace, pixelData);
    }

    public static QOIImage readImage(@NonNull InputStream in) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return QOIUtil.readImage(in, 0);
    }

    public static QOIImage readImage(@NonNull InputStream in, int channels) throws IOException {
        if (in == null) {
            throw new NullPointerException("in is marked non-null but is null");
        }
        return QOIDecoder.decode(in, channels);
    }

    public static QOIImage readFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        return QOIUtil.readFile(file, 0);
    }

    public static QOIImage readFile(@NonNull File file, int channels) throws IOException {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileInputStream in = new FileInputStream(file);){
            QOIImage qOIImage = QOIUtil.readImage(in, channels);
            return qOIImage;
        }
    }

    public static void writeImage(@NonNull QOIImage image, @NonNull OutputStream out) throws IOException {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (out == null) {
            throw new NullPointerException("out is marked non-null but is null");
        }
        QOIEncoder.encode(image, out);
    }

    public static void writeImage(@NonNull QOIImage image, @NonNull File file) throws IOException {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            QOIUtil.writeImage(image, out);
        }
    }

    public static QOIImage removeAlpha(@NonNull QOIImage image) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (image.getChannels() != 4) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] pixelData = image.getPixelData();
        byte[] newData = new byte[width * height * 3];
        int i = 0;
        int j = 0;
        while (i < pixelData.length) {
            newData[j] = pixelData[i];
            newData[j + 1] = pixelData[i + 1];
            newData[j + 2] = pixelData[i + 2];
            i += 4;
            j += 3;
        }
        return new QOIImage(width, height, 3, image.getColorSpace(), newData);
    }

    public static QOIImage addAlpha(@NonNull QOIImage image, int alpha) {
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        if (image.getChannels() != 3) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        byte[] pixelData = image.getPixelData();
        byte[] newData = new byte[width * height * 4];
        byte alphaByte = (byte)alpha;
        int i = 0;
        int j = 0;
        while (i < pixelData.length) {
            newData[j] = pixelData[i];
            newData[j + 1] = pixelData[i + 1];
            newData[j + 2] = pixelData[i + 2];
            newData[j + 3] = alphaByte;
            i += 3;
            j += 4;
        }
        return new QOIImage(width, height, 4, image.getColorSpace(), newData);
    }
}

